/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisearch.codec;

import com.livk.autoconfigure.redisearch.codec.AbstractRedisCodec;
import com.livk.autoconfigure.redisearch.codec.CodecException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.springframework.core.ConfigurableObjectInputStream;

public class JdkRedisCodec
extends AbstractRedisCodec<Object> {
    private ClassLoader classLoader;

    public JdkRedisCodec() {
    }

    public JdkRedisCodec(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    protected byte[] serialize(Object value) throws CodecException {
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires a Serializable payload but received an object of type [" + value.getClass().getName() + "]");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
            objectOutputStream.writeObject(value);
            objectOutputStream.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new CodecException("Cannot serialize", e);
        }
    }

    @Override
    protected Object deserialize(byte[] bytes) throws CodecException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream((InputStream)inputStream, this.classLoader);
            return objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CodecException("Cannot deserialize", e);
        }
    }
}

