/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.livk.commons.jackson.core.JacksonSupport;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.api.NameMapper;
import org.redisson.api.NatMapper;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.CommandMapper;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.CredentialsResolver;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.balancer.LoadBalancer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public abstract class ConfigBaseConverter<T>
implements Converter<String, T> {
    private static final JacksonSupport support = new JacksonSupport((ObjectMapper)ConfigBaseConverter.createMapper());
    private final Class<T> type = GenericTypeResolver.resolveTypeArgument(this.getClass(), ConfigBaseConverter.class);

    private static YAMLMapper createMapper() {
        YAMLMapper mapper = new YAMLMapper();
        mapper.addMixIn(Config.class, ConfigSupport.ConfigMixIn.class);
        mapper.addMixIn(BaseMasterSlaveServersConfig.class, ConfigSupport.ConfigPropsMixIn.class);
        mapper.addMixIn(ReferenceCodecProvider.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(AddressResolverGroupFactory.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(Codec.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(RedissonNodeInitializer.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(LoadBalancer.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(NatMapper.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(NameMapper.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(NettyHook.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(CredentialsResolver.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(EventLoopGroup.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(ConnectionListener.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(ExecutorService.class, ConfigSupport.ClassMixIn.class);
        mapper.addMixIn(KeyManagerFactory.class, ConfigSupport.IgnoreMixIn.class);
        mapper.addMixIn(TrustManagerFactory.class, ConfigSupport.IgnoreMixIn.class);
        mapper.addMixIn(CommandMapper.class, ConfigSupport.ClassMixIn.class);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("classFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[0]));
        mapper.setFilterProvider((FilterProvider)filterProvider);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    public T convert(@NonNull String source) {
        return (T)support.readValue((Object)source, this.type);
    }
}

