/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisson;

import com.livk.commons.util.BeanUtils;
import io.netty.channel.EventLoopGroup;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.api.NameMapper;
import org.redisson.api.NatMapper;
import org.redisson.client.DefaultCredentialsResolver;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.CommandMapper;
import org.redisson.config.Config;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SslProvider;
import org.redisson.config.SubscriptionMode;
import org.redisson.config.TransportMode;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.redisson")
public class ConfigProperties {
    public static final String PREFIX = "spring.redisson";
    private RedissonConfig config;

    public RedissonConfig getConfig() {
        return this.config;
    }

    public void setConfig(RedissonConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigProperties)) {
            return false;
        }
        ConfigProperties other = (ConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedissonConfig this$config = this.getConfig();
        RedissonConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedissonConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigProperties(config=" + String.valueOf((Object)this.getConfig()) + ")";
    }

    public static class RedissonConfig
    extends Config {
        @ConstructorBinding
        public RedissonConfig(ClusterServers clusterServersConfig, ReplicatedServers replicatedServersConfig, SingleServer singleServerConfig, SentinelServers sentinelServersConfig, MasterSlaveServers masterSlaveServersConfig, @DefaultValue(value={"!<org.redisson.client.DefaultNettyHook> {}"}) NettyHook nettyHook, Codec codec, @DefaultValue(value={"true"}) Boolean redissonReferenceEnabled, @DefaultValue(value={"16"}) Integer threads, @DefaultValue(value={"NIO"}) TransportMode transportMode, @DefaultValue(value={"32"}) Integer nettyThreads, ExecutorService executor, EventLoopGroup eventLoopGroup, @DefaultValue(value={"30000"}) Long lockWatchdogTimeout, @DefaultValue(value={"true"}) Boolean checkLockSyncedSlaves, @DefaultValue(value={"true"}) Boolean keepPubSubOrder, @DefaultValue(value={"!<org.redisson.connection.SequentialDnsAddressResolverFactory> {}"}) AddressResolverGroupFactory addressResolverGroupFactory, @DefaultValue(value={"false"}) Boolean useScriptCache, @DefaultValue(value={"5"}) Integer minCleanUpDelay, @DefaultValue(value={"1800"}) Integer maxCleanUpDelay, @DefaultValue(value={"100"}) Integer cleanUpKeysAmount, @DefaultValue(value={"true"}) Boolean useThreadClassLoader, @DefaultValue(value={"600000"}) Long reliableTopicWatchdogTimeout, ConnectionListener connectionListener, Boolean lazyInitialization, @DefaultValue(value={"1000"}) Long slavesSyncTimeout) {
            this.setConfig(clusterServersConfig, x$0 -> super.setClusterServersConfig(x$0));
            this.setConfig(replicatedServersConfig, x$0 -> super.setReplicatedServersConfig(x$0));
            this.setConfig(singleServerConfig, x$0 -> super.setSingleServerConfig(x$0));
            this.setConfig(sentinelServersConfig, x$0 -> super.setSentinelServersConfig(x$0));
            this.setConfig(masterSlaveServersConfig, x$0 -> super.setMasterSlaveServersConfig(x$0));
            this.set(nettyHook, x$0 -> super.setNettyHook(x$0));
            this.set(codec, x$0 -> super.setCodec(x$0));
            this.set(redissonReferenceEnabled, x$0 -> super.setReferenceEnabled(x$0));
            this.set(threads, x$0 -> super.setThreads(x$0));
            this.set(transportMode, x$0 -> super.setTransportMode(x$0));
            this.set(nettyThreads, x$0 -> super.setNettyThreads(x$0));
            this.set(executor, x$0 -> super.setExecutor(x$0));
            this.set(eventLoopGroup, x$0 -> super.setEventLoopGroup(x$0));
            this.set(lockWatchdogTimeout, x$0 -> super.setLockWatchdogTimeout(x$0));
            this.set(checkLockSyncedSlaves, x$0 -> super.setCheckLockSyncedSlaves(x$0));
            this.set(keepPubSubOrder, x$0 -> super.setKeepPubSubOrder(x$0));
            this.set(addressResolverGroupFactory, x$0 -> super.setAddressResolverGroupFactory(x$0));
            this.set(useScriptCache, x$0 -> super.setUseScriptCache(x$0));
            this.set(minCleanUpDelay, x$0 -> super.setMinCleanUpDelay(x$0));
            this.set(maxCleanUpDelay, x$0 -> super.setMaxCleanUpDelay(x$0));
            this.set(cleanUpKeysAmount, x$0 -> super.setCleanUpKeysAmount(x$0));
            this.set(useThreadClassLoader, x$0 -> super.setUseThreadClassLoader(x$0));
            this.set(reliableTopicWatchdogTimeout, x$0 -> super.setReliableTopicWatchdogTimeout(x$0));
            this.set(connectionListener, x$0 -> super.setConnectionListener(x$0));
            this.set(lazyInitialization, x$0 -> super.setLazyInitialization(x$0));
            this.set(slavesSyncTimeout, x$0 -> super.setSlavesSyncTimeout(x$0));
        }

        private <T extends Base<R>, R extends BaseConfig<R>> void setConfig(T t, Consumer<R> consumer) {
            if (t != null) {
                consumer.accept(t.convert());
            }
        }

        private <T> void set(T t, Consumer<T> consumer) {
            if (t != null) {
                consumer.accept(t);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedissonConfig)) {
                return false;
            }
            RedissonConfig other = (RedissonConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        protected boolean canEqual(Object other) {
            return other instanceof RedissonConfig;
        }

        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        public String toString() {
            return "ConfigProperties.RedissonConfig()";
        }
    }

    public static abstract class Base<T extends BaseConfig<T>> {
        private int idleConnectionTimeout = 10000;
        private int connectTimeout = 10000;
        private int timeout = 3000;
        private int subscriptionTimeout = 7500;
        private int retryAttempts = 3;
        private int retryInterval = 1500;
        private String password;
        private String username;
        private CredentialsResolver credentialsResolver = new DefaultCredentialsResolver();
        private int subscriptionsPerConnection = 5;
        private String clientName;
        private boolean sslEnableEndpointIdentification = true;
        private SslProvider sslProvider = SslProvider.JDK;
        private URL sslTruststore;
        private String sslTruststorePassword;
        private URL sslKeystore;
        private String sslKeystorePassword;
        private String[] sslProtocols;
        private String[] sslCiphers;
        private TrustManagerFactory sslTrustManagerFactory;
        private KeyManagerFactory sslKeyManagerFactory;
        private int pingConnectionInterval = 30000;
        private boolean keepAlive;
        private boolean tcpNoDelay = true;
        private NameMapper nameMapper = NameMapper.direct();
        private CommandMapper commandMapper = CommandMapper.direct();

        public T convert() {
            Class type = GenericTypeResolver.resolveTypeArgument(this.getClass(), Base.class);
            Assert.notNull((Object)type, (String)"type must not be null");
            return (T)((BaseConfig)BeanUtils.copy((Object)this, (Class)type));
        }

        public int getIdleConnectionTimeout() {
            return this.idleConnectionTimeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int getSubscriptionTimeout() {
            return this.subscriptionTimeout;
        }

        public int getRetryAttempts() {
            return this.retryAttempts;
        }

        public int getRetryInterval() {
            return this.retryInterval;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.username;
        }

        public CredentialsResolver getCredentialsResolver() {
            return this.credentialsResolver;
        }

        public int getSubscriptionsPerConnection() {
            return this.subscriptionsPerConnection;
        }

        public String getClientName() {
            return this.clientName;
        }

        public boolean isSslEnableEndpointIdentification() {
            return this.sslEnableEndpointIdentification;
        }

        public SslProvider getSslProvider() {
            return this.sslProvider;
        }

        public URL getSslTruststore() {
            return this.sslTruststore;
        }

        public String getSslTruststorePassword() {
            return this.sslTruststorePassword;
        }

        public URL getSslKeystore() {
            return this.sslKeystore;
        }

        public String getSslKeystorePassword() {
            return this.sslKeystorePassword;
        }

        public String[] getSslProtocols() {
            return this.sslProtocols;
        }

        public String[] getSslCiphers() {
            return this.sslCiphers;
        }

        public TrustManagerFactory getSslTrustManagerFactory() {
            return this.sslTrustManagerFactory;
        }

        public KeyManagerFactory getSslKeyManagerFactory() {
            return this.sslKeyManagerFactory;
        }

        public int getPingConnectionInterval() {
            return this.pingConnectionInterval;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }

        public boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public NameMapper getNameMapper() {
            return this.nameMapper;
        }

        public CommandMapper getCommandMapper() {
            return this.commandMapper;
        }

        public void setIdleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setSubscriptionTimeout(int subscriptionTimeout) {
            this.subscriptionTimeout = subscriptionTimeout;
        }

        public void setRetryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        public void setRetryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setCredentialsResolver(CredentialsResolver credentialsResolver) {
            this.credentialsResolver = credentialsResolver;
        }

        public void setSubscriptionsPerConnection(int subscriptionsPerConnection) {
            this.subscriptionsPerConnection = subscriptionsPerConnection;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public void setSslEnableEndpointIdentification(boolean sslEnableEndpointIdentification) {
            this.sslEnableEndpointIdentification = sslEnableEndpointIdentification;
        }

        public void setSslProvider(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        public void setSslTruststore(URL sslTruststore) {
            this.sslTruststore = sslTruststore;
        }

        public void setSslTruststorePassword(String sslTruststorePassword) {
            this.sslTruststorePassword = sslTruststorePassword;
        }

        public void setSslKeystore(URL sslKeystore) {
            this.sslKeystore = sslKeystore;
        }

        public void setSslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
        }

        public void setSslProtocols(String[] sslProtocols) {
            this.sslProtocols = sslProtocols;
        }

        public void setSslCiphers(String[] sslCiphers) {
            this.sslCiphers = sslCiphers;
        }

        public void setSslTrustManagerFactory(TrustManagerFactory sslTrustManagerFactory) {
            this.sslTrustManagerFactory = sslTrustManagerFactory;
        }

        public void setSslKeyManagerFactory(KeyManagerFactory sslKeyManagerFactory) {
            this.sslKeyManagerFactory = sslKeyManagerFactory;
        }

        public void setPingConnectionInterval(int pingConnectionInterval) {
            this.pingConnectionInterval = pingConnectionInterval;
        }

        public void setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
        }

        public void setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
        }

        public void setNameMapper(NameMapper nameMapper) {
            this.nameMapper = nameMapper;
        }

        public void setCommandMapper(CommandMapper commandMapper) {
            this.commandMapper = commandMapper;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIdleConnectionTimeout() != other.getIdleConnectionTimeout()) {
                return false;
            }
            if (this.getConnectTimeout() != other.getConnectTimeout()) {
                return false;
            }
            if (this.getTimeout() != other.getTimeout()) {
                return false;
            }
            if (this.getSubscriptionTimeout() != other.getSubscriptionTimeout()) {
                return false;
            }
            if (this.getRetryAttempts() != other.getRetryAttempts()) {
                return false;
            }
            if (this.getRetryInterval() != other.getRetryInterval()) {
                return false;
            }
            if (this.getSubscriptionsPerConnection() != other.getSubscriptionsPerConnection()) {
                return false;
            }
            if (this.isSslEnableEndpointIdentification() != other.isSslEnableEndpointIdentification()) {
                return false;
            }
            if (this.getPingConnectionInterval() != other.getPingConnectionInterval()) {
                return false;
            }
            if (this.isKeepAlive() != other.isKeepAlive()) {
                return false;
            }
            if (this.isTcpNoDelay() != other.isTcpNoDelay()) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            CredentialsResolver this$credentialsResolver = this.getCredentialsResolver();
            CredentialsResolver other$credentialsResolver = other.getCredentialsResolver();
            if (this$credentialsResolver == null ? other$credentialsResolver != null : !this$credentialsResolver.equals(other$credentialsResolver)) {
                return false;
            }
            String this$clientName = this.getClientName();
            String other$clientName = other.getClientName();
            if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
                return false;
            }
            SslProvider this$sslProvider = this.getSslProvider();
            SslProvider other$sslProvider = other.getSslProvider();
            if (this$sslProvider == null ? other$sslProvider != null : !this$sslProvider.equals(other$sslProvider)) {
                return false;
            }
            URL this$sslTruststore = this.getSslTruststore();
            URL other$sslTruststore = other.getSslTruststore();
            if (this$sslTruststore == null ? other$sslTruststore != null : !((Object)this$sslTruststore).equals(other$sslTruststore)) {
                return false;
            }
            String this$sslTruststorePassword = this.getSslTruststorePassword();
            String other$sslTruststorePassword = other.getSslTruststorePassword();
            if (this$sslTruststorePassword == null ? other$sslTruststorePassword != null : !this$sslTruststorePassword.equals(other$sslTruststorePassword)) {
                return false;
            }
            URL this$sslKeystore = this.getSslKeystore();
            URL other$sslKeystore = other.getSslKeystore();
            if (this$sslKeystore == null ? other$sslKeystore != null : !((Object)this$sslKeystore).equals(other$sslKeystore)) {
                return false;
            }
            String this$sslKeystorePassword = this.getSslKeystorePassword();
            String other$sslKeystorePassword = other.getSslKeystorePassword();
            if (this$sslKeystorePassword == null ? other$sslKeystorePassword != null : !this$sslKeystorePassword.equals(other$sslKeystorePassword)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getSslProtocols(), other.getSslProtocols())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getSslCiphers(), other.getSslCiphers())) {
                return false;
            }
            TrustManagerFactory this$sslTrustManagerFactory = this.getSslTrustManagerFactory();
            TrustManagerFactory other$sslTrustManagerFactory = other.getSslTrustManagerFactory();
            if (this$sslTrustManagerFactory == null ? other$sslTrustManagerFactory != null : !this$sslTrustManagerFactory.equals(other$sslTrustManagerFactory)) {
                return false;
            }
            KeyManagerFactory this$sslKeyManagerFactory = this.getSslKeyManagerFactory();
            KeyManagerFactory other$sslKeyManagerFactory = other.getSslKeyManagerFactory();
            if (this$sslKeyManagerFactory == null ? other$sslKeyManagerFactory != null : !this$sslKeyManagerFactory.equals(other$sslKeyManagerFactory)) {
                return false;
            }
            NameMapper this$nameMapper = this.getNameMapper();
            NameMapper other$nameMapper = other.getNameMapper();
            if (this$nameMapper == null ? other$nameMapper != null : !this$nameMapper.equals(other$nameMapper)) {
                return false;
            }
            CommandMapper this$commandMapper = this.getCommandMapper();
            CommandMapper other$commandMapper = other.getCommandMapper();
            return !(this$commandMapper == null ? other$commandMapper != null : !this$commandMapper.equals(other$commandMapper));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIdleConnectionTimeout();
            result = result * 59 + this.getConnectTimeout();
            result = result * 59 + this.getTimeout();
            result = result * 59 + this.getSubscriptionTimeout();
            result = result * 59 + this.getRetryAttempts();
            result = result * 59 + this.getRetryInterval();
            result = result * 59 + this.getSubscriptionsPerConnection();
            result = result * 59 + (this.isSslEnableEndpointIdentification() ? 79 : 97);
            result = result * 59 + this.getPingConnectionInterval();
            result = result * 59 + (this.isKeepAlive() ? 79 : 97);
            result = result * 59 + (this.isTcpNoDelay() ? 79 : 97);
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            CredentialsResolver $credentialsResolver = this.getCredentialsResolver();
            result = result * 59 + ($credentialsResolver == null ? 43 : $credentialsResolver.hashCode());
            String $clientName = this.getClientName();
            result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
            SslProvider $sslProvider = this.getSslProvider();
            result = result * 59 + ($sslProvider == null ? 43 : $sslProvider.hashCode());
            URL $sslTruststore = this.getSslTruststore();
            result = result * 59 + ($sslTruststore == null ? 43 : ((Object)$sslTruststore).hashCode());
            String $sslTruststorePassword = this.getSslTruststorePassword();
            result = result * 59 + ($sslTruststorePassword == null ? 43 : $sslTruststorePassword.hashCode());
            URL $sslKeystore = this.getSslKeystore();
            result = result * 59 + ($sslKeystore == null ? 43 : ((Object)$sslKeystore).hashCode());
            String $sslKeystorePassword = this.getSslKeystorePassword();
            result = result * 59 + ($sslKeystorePassword == null ? 43 : $sslKeystorePassword.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getSslProtocols());
            result = result * 59 + Arrays.deepHashCode(this.getSslCiphers());
            TrustManagerFactory $sslTrustManagerFactory = this.getSslTrustManagerFactory();
            result = result * 59 + ($sslTrustManagerFactory == null ? 43 : $sslTrustManagerFactory.hashCode());
            KeyManagerFactory $sslKeyManagerFactory = this.getSslKeyManagerFactory();
            result = result * 59 + ($sslKeyManagerFactory == null ? 43 : $sslKeyManagerFactory.hashCode());
            NameMapper $nameMapper = this.getNameMapper();
            result = result * 59 + ($nameMapper == null ? 43 : $nameMapper.hashCode());
            CommandMapper $commandMapper = this.getCommandMapper();
            result = result * 59 + ($commandMapper == null ? 43 : $commandMapper.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigProperties.Base(idleConnectionTimeout=" + this.getIdleConnectionTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", timeout=" + this.getTimeout() + ", subscriptionTimeout=" + this.getSubscriptionTimeout() + ", retryAttempts=" + this.getRetryAttempts() + ", retryInterval=" + this.getRetryInterval() + ", password=" + this.getPassword() + ", username=" + this.getUsername() + ", credentialsResolver=" + String.valueOf(this.getCredentialsResolver()) + ", subscriptionsPerConnection=" + this.getSubscriptionsPerConnection() + ", clientName=" + this.getClientName() + ", sslEnableEndpointIdentification=" + this.isSslEnableEndpointIdentification() + ", sslProvider=" + String.valueOf(this.getSslProvider()) + ", sslTruststore=" + String.valueOf(this.getSslTruststore()) + ", sslTruststorePassword=" + this.getSslTruststorePassword() + ", sslKeystore=" + String.valueOf(this.getSslKeystore()) + ", sslKeystorePassword=" + this.getSslKeystorePassword() + ", sslProtocols=" + Arrays.deepToString(this.getSslProtocols()) + ", sslCiphers=" + Arrays.deepToString(this.getSslCiphers()) + ", sslTrustManagerFactory=" + String.valueOf(this.getSslTrustManagerFactory()) + ", sslKeyManagerFactory=" + String.valueOf(this.getSslKeyManagerFactory()) + ", pingConnectionInterval=" + this.getPingConnectionInterval() + ", keepAlive=" + this.isKeepAlive() + ", tcpNoDelay=" + this.isTcpNoDelay() + ", nameMapper=" + String.valueOf(this.getNameMapper()) + ", commandMapper=" + String.valueOf(this.getCommandMapper()) + ")";
        }
    }

    public static abstract class BaseMasterSlaveServers<T extends BaseMasterSlaveServersConfig<T>>
    extends Base<T> {
        private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
        private int slaveConnectionMinimumIdleSize = 24;
        private int slaveConnectionPoolSize = 64;
        private int failedSlaveReconnectionInterval = 3000;
        private int failedSlaveCheckInterval = 180000;
        private int masterConnectionMinimumIdleSize = 24;
        private int masterConnectionPoolSize = 64;
        private ReadMode readMode = ReadMode.SLAVE;
        private SubscriptionMode subscriptionMode = SubscriptionMode.MASTER;
        private int subscriptionConnectionMinimumIdleSize = 1;
        private int subscriptionConnectionPoolSize = 50;
        private long dnsMonitoringInterval = 5000L;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseMasterSlaveServers)) {
                return false;
            }
            BaseMasterSlaveServers other = (BaseMasterSlaveServers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getSlaveConnectionMinimumIdleSize() != other.getSlaveConnectionMinimumIdleSize()) {
                return false;
            }
            if (this.getSlaveConnectionPoolSize() != other.getSlaveConnectionPoolSize()) {
                return false;
            }
            if (this.getFailedSlaveReconnectionInterval() != other.getFailedSlaveReconnectionInterval()) {
                return false;
            }
            if (this.getFailedSlaveCheckInterval() != other.getFailedSlaveCheckInterval()) {
                return false;
            }
            if (this.getMasterConnectionMinimumIdleSize() != other.getMasterConnectionMinimumIdleSize()) {
                return false;
            }
            if (this.getMasterConnectionPoolSize() != other.getMasterConnectionPoolSize()) {
                return false;
            }
            if (this.getSubscriptionConnectionMinimumIdleSize() != other.getSubscriptionConnectionMinimumIdleSize()) {
                return false;
            }
            if (this.getSubscriptionConnectionPoolSize() != other.getSubscriptionConnectionPoolSize()) {
                return false;
            }
            if (this.getDnsMonitoringInterval() != other.getDnsMonitoringInterval()) {
                return false;
            }
            LoadBalancer this$loadBalancer = this.getLoadBalancer();
            LoadBalancer other$loadBalancer = other.getLoadBalancer();
            if (this$loadBalancer == null ? other$loadBalancer != null : !this$loadBalancer.equals(other$loadBalancer)) {
                return false;
            }
            ReadMode this$readMode = this.getReadMode();
            ReadMode other$readMode = other.getReadMode();
            if (this$readMode == null ? other$readMode != null : !this$readMode.equals(other$readMode)) {
                return false;
            }
            SubscriptionMode this$subscriptionMode = this.getSubscriptionMode();
            SubscriptionMode other$subscriptionMode = other.getSubscriptionMode();
            return !(this$subscriptionMode == null ? other$subscriptionMode != null : !this$subscriptionMode.equals(other$subscriptionMode));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BaseMasterSlaveServers;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getSlaveConnectionMinimumIdleSize();
            result = result * 59 + this.getSlaveConnectionPoolSize();
            result = result * 59 + this.getFailedSlaveReconnectionInterval();
            result = result * 59 + this.getFailedSlaveCheckInterval();
            result = result * 59 + this.getMasterConnectionMinimumIdleSize();
            result = result * 59 + this.getMasterConnectionPoolSize();
            result = result * 59 + this.getSubscriptionConnectionMinimumIdleSize();
            result = result * 59 + this.getSubscriptionConnectionPoolSize();
            long $dnsMonitoringInterval = this.getDnsMonitoringInterval();
            result = result * 59 + (int)($dnsMonitoringInterval >>> 32 ^ $dnsMonitoringInterval);
            LoadBalancer $loadBalancer = this.getLoadBalancer();
            result = result * 59 + ($loadBalancer == null ? 43 : $loadBalancer.hashCode());
            ReadMode $readMode = this.getReadMode();
            result = result * 59 + ($readMode == null ? 43 : $readMode.hashCode());
            SubscriptionMode $subscriptionMode = this.getSubscriptionMode();
            result = result * 59 + ($subscriptionMode == null ? 43 : $subscriptionMode.hashCode());
            return result;
        }

        public LoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        public int getSlaveConnectionMinimumIdleSize() {
            return this.slaveConnectionMinimumIdleSize;
        }

        public int getSlaveConnectionPoolSize() {
            return this.slaveConnectionPoolSize;
        }

        public int getFailedSlaveReconnectionInterval() {
            return this.failedSlaveReconnectionInterval;
        }

        public int getFailedSlaveCheckInterval() {
            return this.failedSlaveCheckInterval;
        }

        public int getMasterConnectionMinimumIdleSize() {
            return this.masterConnectionMinimumIdleSize;
        }

        public int getMasterConnectionPoolSize() {
            return this.masterConnectionPoolSize;
        }

        public ReadMode getReadMode() {
            return this.readMode;
        }

        public SubscriptionMode getSubscriptionMode() {
            return this.subscriptionMode;
        }

        public int getSubscriptionConnectionMinimumIdleSize() {
            return this.subscriptionConnectionMinimumIdleSize;
        }

        public int getSubscriptionConnectionPoolSize() {
            return this.subscriptionConnectionPoolSize;
        }

        public long getDnsMonitoringInterval() {
            return this.dnsMonitoringInterval;
        }

        public void setLoadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        public void setSlaveConnectionMinimumIdleSize(int slaveConnectionMinimumIdleSize) {
            this.slaveConnectionMinimumIdleSize = slaveConnectionMinimumIdleSize;
        }

        public void setSlaveConnectionPoolSize(int slaveConnectionPoolSize) {
            this.slaveConnectionPoolSize = slaveConnectionPoolSize;
        }

        public void setFailedSlaveReconnectionInterval(int failedSlaveReconnectionInterval) {
            this.failedSlaveReconnectionInterval = failedSlaveReconnectionInterval;
        }

        public void setFailedSlaveCheckInterval(int failedSlaveCheckInterval) {
            this.failedSlaveCheckInterval = failedSlaveCheckInterval;
        }

        public void setMasterConnectionMinimumIdleSize(int masterConnectionMinimumIdleSize) {
            this.masterConnectionMinimumIdleSize = masterConnectionMinimumIdleSize;
        }

        public void setMasterConnectionPoolSize(int masterConnectionPoolSize) {
            this.masterConnectionPoolSize = masterConnectionPoolSize;
        }

        public void setReadMode(ReadMode readMode) {
            this.readMode = readMode;
        }

        public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
            this.subscriptionMode = subscriptionMode;
        }

        public void setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
            this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
        }

        public void setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
            this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
        }

        public void setDnsMonitoringInterval(long dnsMonitoringInterval) {
            this.dnsMonitoringInterval = dnsMonitoringInterval;
        }

        @Override
        public String toString() {
            return "ConfigProperties.BaseMasterSlaveServers(loadBalancer=" + String.valueOf(this.getLoadBalancer()) + ", slaveConnectionMinimumIdleSize=" + this.getSlaveConnectionMinimumIdleSize() + ", slaveConnectionPoolSize=" + this.getSlaveConnectionPoolSize() + ", failedSlaveReconnectionInterval=" + this.getFailedSlaveReconnectionInterval() + ", failedSlaveCheckInterval=" + this.getFailedSlaveCheckInterval() + ", masterConnectionMinimumIdleSize=" + this.getMasterConnectionMinimumIdleSize() + ", masterConnectionPoolSize=" + this.getMasterConnectionPoolSize() + ", readMode=" + String.valueOf(this.getReadMode()) + ", subscriptionMode=" + String.valueOf(this.getSubscriptionMode()) + ", subscriptionConnectionMinimumIdleSize=" + this.getSubscriptionConnectionMinimumIdleSize() + ", subscriptionConnectionPoolSize=" + this.getSubscriptionConnectionPoolSize() + ", dnsMonitoringInterval=" + this.getDnsMonitoringInterval() + ")";
        }
    }

    public static class SingleServer
    extends Base<SingleServerConfig> {
        private String address;
        private int subscriptionConnectionMinimumIdleSize = 1;
        private int subscriptionConnectionPoolSize = 50;
        private int connectionMinimumIdleSize = 24;
        private int connectionPoolSize = 64;
        private int database = 0;
        private long dnsMonitoringInterval = 5000L;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleServer)) {
                return false;
            }
            SingleServer other = (SingleServer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getSubscriptionConnectionMinimumIdleSize() != other.getSubscriptionConnectionMinimumIdleSize()) {
                return false;
            }
            if (this.getSubscriptionConnectionPoolSize() != other.getSubscriptionConnectionPoolSize()) {
                return false;
            }
            if (this.getConnectionMinimumIdleSize() != other.getConnectionMinimumIdleSize()) {
                return false;
            }
            if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
                return false;
            }
            if (this.getDatabase() != other.getDatabase()) {
                return false;
            }
            if (this.getDnsMonitoringInterval() != other.getDnsMonitoringInterval()) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SingleServer;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getSubscriptionConnectionMinimumIdleSize();
            result = result * 59 + this.getSubscriptionConnectionPoolSize();
            result = result * 59 + this.getConnectionMinimumIdleSize();
            result = result * 59 + this.getConnectionPoolSize();
            result = result * 59 + this.getDatabase();
            long $dnsMonitoringInterval = this.getDnsMonitoringInterval();
            result = result * 59 + (int)($dnsMonitoringInterval >>> 32 ^ $dnsMonitoringInterval);
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        public String getAddress() {
            return this.address;
        }

        public int getSubscriptionConnectionMinimumIdleSize() {
            return this.subscriptionConnectionMinimumIdleSize;
        }

        public int getSubscriptionConnectionPoolSize() {
            return this.subscriptionConnectionPoolSize;
        }

        public int getConnectionMinimumIdleSize() {
            return this.connectionMinimumIdleSize;
        }

        public int getConnectionPoolSize() {
            return this.connectionPoolSize;
        }

        public int getDatabase() {
            return this.database;
        }

        public long getDnsMonitoringInterval() {
            return this.dnsMonitoringInterval;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
            this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
        }

        public void setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
            this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
        }

        public void setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
            this.connectionMinimumIdleSize = connectionMinimumIdleSize;
        }

        public void setConnectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public void setDnsMonitoringInterval(long dnsMonitoringInterval) {
            this.dnsMonitoringInterval = dnsMonitoringInterval;
        }

        @Override
        public String toString() {
            return "ConfigProperties.SingleServer(address=" + this.getAddress() + ", subscriptionConnectionMinimumIdleSize=" + this.getSubscriptionConnectionMinimumIdleSize() + ", subscriptionConnectionPoolSize=" + this.getSubscriptionConnectionPoolSize() + ", connectionMinimumIdleSize=" + this.getConnectionMinimumIdleSize() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", database=" + this.getDatabase() + ", dnsMonitoringInterval=" + this.getDnsMonitoringInterval() + ")";
        }
    }

    public static class SentinelServers
    extends BaseMasterSlaveServers<SentinelServersConfig> {
        private List<String> sentinelAddresses = new ArrayList<String>();
        private NatMapper natMapper = NatMapper.direct();
        private String masterName;
        private String sentinelUsername;
        private String sentinelPassword;
        private int database = 0;
        private int scanInterval = 1000;
        private boolean checkSentinelsList = true;
        private boolean checkSlaveStatusWithSyncing = true;
        private boolean sentinelsDiscovery = true;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SentinelServers)) {
                return false;
            }
            SentinelServers other = (SentinelServers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getDatabase() != other.getDatabase()) {
                return false;
            }
            if (this.getScanInterval() != other.getScanInterval()) {
                return false;
            }
            if (this.isCheckSentinelsList() != other.isCheckSentinelsList()) {
                return false;
            }
            if (this.isCheckSlaveStatusWithSyncing() != other.isCheckSlaveStatusWithSyncing()) {
                return false;
            }
            if (this.isSentinelsDiscovery() != other.isSentinelsDiscovery()) {
                return false;
            }
            List<String> this$sentinelAddresses = this.getSentinelAddresses();
            List<String> other$sentinelAddresses = other.getSentinelAddresses();
            if (this$sentinelAddresses == null ? other$sentinelAddresses != null : !((Object)this$sentinelAddresses).equals(other$sentinelAddresses)) {
                return false;
            }
            NatMapper this$natMapper = this.getNatMapper();
            NatMapper other$natMapper = other.getNatMapper();
            if (this$natMapper == null ? other$natMapper != null : !this$natMapper.equals(other$natMapper)) {
                return false;
            }
            String this$masterName = this.getMasterName();
            String other$masterName = other.getMasterName();
            if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
                return false;
            }
            String this$sentinelUsername = this.getSentinelUsername();
            String other$sentinelUsername = other.getSentinelUsername();
            if (this$sentinelUsername == null ? other$sentinelUsername != null : !this$sentinelUsername.equals(other$sentinelUsername)) {
                return false;
            }
            String this$sentinelPassword = this.getSentinelPassword();
            String other$sentinelPassword = other.getSentinelPassword();
            return !(this$sentinelPassword == null ? other$sentinelPassword != null : !this$sentinelPassword.equals(other$sentinelPassword));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SentinelServers;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getDatabase();
            result = result * 59 + this.getScanInterval();
            result = result * 59 + (this.isCheckSentinelsList() ? 79 : 97);
            result = result * 59 + (this.isCheckSlaveStatusWithSyncing() ? 79 : 97);
            result = result * 59 + (this.isSentinelsDiscovery() ? 79 : 97);
            List<String> $sentinelAddresses = this.getSentinelAddresses();
            result = result * 59 + ($sentinelAddresses == null ? 43 : ((Object)$sentinelAddresses).hashCode());
            NatMapper $natMapper = this.getNatMapper();
            result = result * 59 + ($natMapper == null ? 43 : $natMapper.hashCode());
            String $masterName = this.getMasterName();
            result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
            String $sentinelUsername = this.getSentinelUsername();
            result = result * 59 + ($sentinelUsername == null ? 43 : $sentinelUsername.hashCode());
            String $sentinelPassword = this.getSentinelPassword();
            result = result * 59 + ($sentinelPassword == null ? 43 : $sentinelPassword.hashCode());
            return result;
        }

        public List<String> getSentinelAddresses() {
            return this.sentinelAddresses;
        }

        public NatMapper getNatMapper() {
            return this.natMapper;
        }

        public String getMasterName() {
            return this.masterName;
        }

        public String getSentinelUsername() {
            return this.sentinelUsername;
        }

        public String getSentinelPassword() {
            return this.sentinelPassword;
        }

        public int getDatabase() {
            return this.database;
        }

        public int getScanInterval() {
            return this.scanInterval;
        }

        public boolean isCheckSentinelsList() {
            return this.checkSentinelsList;
        }

        public boolean isCheckSlaveStatusWithSyncing() {
            return this.checkSlaveStatusWithSyncing;
        }

        public boolean isSentinelsDiscovery() {
            return this.sentinelsDiscovery;
        }

        public void setSentinelAddresses(List<String> sentinelAddresses) {
            this.sentinelAddresses = sentinelAddresses;
        }

        public void setNatMapper(NatMapper natMapper) {
            this.natMapper = natMapper;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public void setSentinelUsername(String sentinelUsername) {
            this.sentinelUsername = sentinelUsername;
        }

        public void setSentinelPassword(String sentinelPassword) {
            this.sentinelPassword = sentinelPassword;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public void setScanInterval(int scanInterval) {
            this.scanInterval = scanInterval;
        }

        public void setCheckSentinelsList(boolean checkSentinelsList) {
            this.checkSentinelsList = checkSentinelsList;
        }

        public void setCheckSlaveStatusWithSyncing(boolean checkSlaveStatusWithSyncing) {
            this.checkSlaveStatusWithSyncing = checkSlaveStatusWithSyncing;
        }

        public void setSentinelsDiscovery(boolean sentinelsDiscovery) {
            this.sentinelsDiscovery = sentinelsDiscovery;
        }

        @Override
        public String toString() {
            return "ConfigProperties.SentinelServers(sentinelAddresses=" + String.valueOf(this.getSentinelAddresses()) + ", natMapper=" + String.valueOf(this.getNatMapper()) + ", masterName=" + this.getMasterName() + ", sentinelUsername=" + this.getSentinelUsername() + ", sentinelPassword=" + this.getSentinelPassword() + ", database=" + this.getDatabase() + ", scanInterval=" + this.getScanInterval() + ", checkSentinelsList=" + this.isCheckSentinelsList() + ", checkSlaveStatusWithSyncing=" + this.isCheckSlaveStatusWithSyncing() + ", sentinelsDiscovery=" + this.isSentinelsDiscovery() + ")";
        }
    }

    public static class ReplicatedServers
    extends BaseMasterSlaveServers<ReplicatedServersConfig> {
        private List<String> nodeAddresses = new ArrayList<String>();
        private int scanInterval = 1000;
        private int database = 0;
        private boolean monitorIPChanges = false;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplicatedServers)) {
                return false;
            }
            ReplicatedServers other = (ReplicatedServers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getScanInterval() != other.getScanInterval()) {
                return false;
            }
            if (this.getDatabase() != other.getDatabase()) {
                return false;
            }
            if (this.isMonitorIPChanges() != other.isMonitorIPChanges()) {
                return false;
            }
            List<String> this$nodeAddresses = this.getNodeAddresses();
            List<String> other$nodeAddresses = other.getNodeAddresses();
            return !(this$nodeAddresses == null ? other$nodeAddresses != null : !((Object)this$nodeAddresses).equals(other$nodeAddresses));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReplicatedServers;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getScanInterval();
            result = result * 59 + this.getDatabase();
            result = result * 59 + (this.isMonitorIPChanges() ? 79 : 97);
            List<String> $nodeAddresses = this.getNodeAddresses();
            result = result * 59 + ($nodeAddresses == null ? 43 : ((Object)$nodeAddresses).hashCode());
            return result;
        }

        public List<String> getNodeAddresses() {
            return this.nodeAddresses;
        }

        public int getScanInterval() {
            return this.scanInterval;
        }

        public int getDatabase() {
            return this.database;
        }

        public boolean isMonitorIPChanges() {
            return this.monitorIPChanges;
        }

        public void setNodeAddresses(List<String> nodeAddresses) {
            this.nodeAddresses = nodeAddresses;
        }

        public void setScanInterval(int scanInterval) {
            this.scanInterval = scanInterval;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public void setMonitorIPChanges(boolean monitorIPChanges) {
            this.monitorIPChanges = monitorIPChanges;
        }

        @Override
        public String toString() {
            return "ConfigProperties.ReplicatedServers(nodeAddresses=" + String.valueOf(this.getNodeAddresses()) + ", scanInterval=" + this.getScanInterval() + ", database=" + this.getDatabase() + ", monitorIPChanges=" + this.isMonitorIPChanges() + ")";
        }
    }

    public static class MasterSlaveServers
    extends BaseMasterSlaveServers<MasterSlaveServersConfig> {
        private NatMapper natMapper = NatMapper.direct();
        private List<String> nodeAddresses = new ArrayList<String>();
        private int scanInterval = 5000;
        private boolean checkSlotsCoverage = true;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MasterSlaveServers)) {
                return false;
            }
            MasterSlaveServers other = (MasterSlaveServers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getScanInterval() != other.getScanInterval()) {
                return false;
            }
            if (this.isCheckSlotsCoverage() != other.isCheckSlotsCoverage()) {
                return false;
            }
            NatMapper this$natMapper = this.getNatMapper();
            NatMapper other$natMapper = other.getNatMapper();
            if (this$natMapper == null ? other$natMapper != null : !this$natMapper.equals(other$natMapper)) {
                return false;
            }
            List<String> this$nodeAddresses = this.getNodeAddresses();
            List<String> other$nodeAddresses = other.getNodeAddresses();
            return !(this$nodeAddresses == null ? other$nodeAddresses != null : !((Object)this$nodeAddresses).equals(other$nodeAddresses));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MasterSlaveServers;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getScanInterval();
            result = result * 59 + (this.isCheckSlotsCoverage() ? 79 : 97);
            NatMapper $natMapper = this.getNatMapper();
            result = result * 59 + ($natMapper == null ? 43 : $natMapper.hashCode());
            List<String> $nodeAddresses = this.getNodeAddresses();
            result = result * 59 + ($nodeAddresses == null ? 43 : ((Object)$nodeAddresses).hashCode());
            return result;
        }

        public NatMapper getNatMapper() {
            return this.natMapper;
        }

        public List<String> getNodeAddresses() {
            return this.nodeAddresses;
        }

        public int getScanInterval() {
            return this.scanInterval;
        }

        public boolean isCheckSlotsCoverage() {
            return this.checkSlotsCoverage;
        }

        public void setNatMapper(NatMapper natMapper) {
            this.natMapper = natMapper;
        }

        public void setNodeAddresses(List<String> nodeAddresses) {
            this.nodeAddresses = nodeAddresses;
        }

        public void setScanInterval(int scanInterval) {
            this.scanInterval = scanInterval;
        }

        public void setCheckSlotsCoverage(boolean checkSlotsCoverage) {
            this.checkSlotsCoverage = checkSlotsCoverage;
        }

        @Override
        public String toString() {
            return "ConfigProperties.MasterSlaveServers(natMapper=" + String.valueOf(this.getNatMapper()) + ", nodeAddresses=" + String.valueOf(this.getNodeAddresses()) + ", scanInterval=" + this.getScanInterval() + ", checkSlotsCoverage=" + this.isCheckSlotsCoverage() + ")";
        }
    }

    public static class ClusterServers
    extends BaseMasterSlaveServers<ClusterServersConfig> {
        private NatMapper natMapper = NatMapper.direct();
        private List<String> nodeAddresses = new ArrayList<String>();
        private int scanInterval = 5000;
        private boolean checkSlotsCoverage = true;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterServers)) {
                return false;
            }
            ClusterServers other = (ClusterServers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getScanInterval() != other.getScanInterval()) {
                return false;
            }
            if (this.isCheckSlotsCoverage() != other.isCheckSlotsCoverage()) {
                return false;
            }
            NatMapper this$natMapper = this.getNatMapper();
            NatMapper other$natMapper = other.getNatMapper();
            if (this$natMapper == null ? other$natMapper != null : !this$natMapper.equals(other$natMapper)) {
                return false;
            }
            List<String> this$nodeAddresses = this.getNodeAddresses();
            List<String> other$nodeAddresses = other.getNodeAddresses();
            return !(this$nodeAddresses == null ? other$nodeAddresses != null : !((Object)this$nodeAddresses).equals(other$nodeAddresses));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ClusterServers;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getScanInterval();
            result = result * 59 + (this.isCheckSlotsCoverage() ? 79 : 97);
            NatMapper $natMapper = this.getNatMapper();
            result = result * 59 + ($natMapper == null ? 43 : $natMapper.hashCode());
            List<String> $nodeAddresses = this.getNodeAddresses();
            result = result * 59 + ($nodeAddresses == null ? 43 : ((Object)$nodeAddresses).hashCode());
            return result;
        }

        public NatMapper getNatMapper() {
            return this.natMapper;
        }

        public List<String> getNodeAddresses() {
            return this.nodeAddresses;
        }

        public int getScanInterval() {
            return this.scanInterval;
        }

        public boolean isCheckSlotsCoverage() {
            return this.checkSlotsCoverage;
        }

        public void setNatMapper(NatMapper natMapper) {
            this.natMapper = natMapper;
        }

        public void setNodeAddresses(List<String> nodeAddresses) {
            this.nodeAddresses = nodeAddresses;
        }

        public void setScanInterval(int scanInterval) {
            this.scanInterval = scanInterval;
        }

        public void setCheckSlotsCoverage(boolean checkSlotsCoverage) {
            this.checkSlotsCoverage = checkSlotsCoverage;
        }

        @Override
        public String toString() {
            return "ConfigProperties.ClusterServers(natMapper=" + String.valueOf(this.getNatMapper()) + ", nodeAddresses=" + String.valueOf(this.getNodeAddresses()) + ", scanInterval=" + this.getScanInterval() + ", checkSlotsCoverage=" + this.isCheckSlotsCoverage() + ")";
        }
    }
}

