/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisson;

import com.livk.autoconfigure.redisson.ByteBuddySupport;
import com.livk.autoconfigure.redisson.ConfigBaseConverter;
import com.livk.autoconfigure.redisson.ConfigCustomizer;
import com.livk.autoconfigure.redisson.ConfigProperties;
import com.livk.autoconfigure.redisson.RedissonClientFactory;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;

@ConditionalOnClass(value={Redisson.class})
@AutoConfiguration(before={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigProperties.class, RedisProperties.class})
public class RedissonAutoConfiguration {
    @Bean
    public BeanFactoryPostProcessor codecConverterBeanFactoryPostProcessor(ObjectProvider<ConfigBaseConverter<?>> baseConverters) {
        return beanFactory -> {
            ConversionService conversionService = beanFactory.getConversionService();
            if (conversionService instanceof ConverterRegistry) {
                ConverterRegistry converterRegistry = (ConverterRegistry)conversionService;
                ByteBuddySupport.makeConverters().forEach(arg_0 -> ((ConverterRegistry)converterRegistry).addConverter(arg_0));
                baseConverters.orderedStream().forEach(arg_0 -> ((ConverterRegistry)converterRegistry).addConverter(arg_0));
            }
        };
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public RedissonClient redissonClient(ConfigProperties configProperties, RedisProperties redisProperties, ObjectProvider<ConfigCustomizer> configCustomizers) {
        return RedissonClientFactory.create(configProperties, redisProperties, configCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={RedissonConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }
}

