/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.redisson;

import com.livk.autoconfigure.redisson.ConfigCustomizer;
import com.livk.autoconfigure.redisson.ConfigProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;

public class RedissonClientFactory {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";

    public static RedissonClient create(ConfigProperties properties, RedisProperties redisProperties, ObjectProvider<ConfigCustomizer> configCustomizers) {
        Config config = Optional.ofNullable(properties.getConfig()).orElse((ConfigProperties.RedissonConfig)RedissonClientFactory.createConfig(redisProperties));
        configCustomizers.orderedStream().forEach(customizer -> customizer.customize(config));
        return Redisson.create((Config)config);
    }

    private static Config createConfig(RedisProperties redisProperties) {
        Config config;
        int timeout;
        Duration duration = redisProperties.getTimeout();
        int n = timeout = duration == null ? 10000 : (int)duration.toMillis();
        if (redisProperties.getSentinel() != null) {
            List nodeList = redisProperties.getSentinel().getNodes();
            String[] nodes = RedissonClientFactory.convert(nodeList);
            config = new Config();
            ((SentinelServersConfig)config.useSentinelServers().setMasterName(redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(redisProperties.getDatabase()).setConnectTimeout(timeout)).setPassword(redisProperties.getPassword());
        } else if (redisProperties.getCluster() != null) {
            List nodeList = redisProperties.getCluster().getNodes();
            String[] nodes = RedissonClientFactory.convert(nodeList);
            config = new Config();
            ((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(redisProperties.getPassword());
        } else {
            config = new Config();
            String prefix = REDIS_PROTOCOL_PREFIX;
            if (redisProperties.getSsl().isEnabled()) {
                prefix = REDISS_PROTOCOL_PREFIX;
            }
            ((SingleServerConfig)config.useSingleServer().setAddress(prefix + redisProperties.getHost() + ":" + redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(redisProperties.getDatabase()).setPassword(redisProperties.getPassword());
        }
        return config;
    }

    private static String[] convert(List<String> nodesObject) {
        ArrayList<Object> nodes = new ArrayList<Object>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }
}

