/*
 * Decompiled with CFR 0.152.
 */
package com.livk.autoconfigure.useragent;

import com.livk.context.useragent.UserAgentHelper;
import com.livk.context.useragent.reactive.ReactiveUserAgentFilter;
import com.livk.context.useragent.reactive.ReactiveUserAgentResolver;
import com.livk.context.useragent.servlet.UserAgentFilter;
import com.livk.context.useragent.servlet.UserAgentResolver;
import com.livk.context.useragent.support.UserAgentConverter;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnBean(value={UserAgentConverter.class})
public class UserAgentConfiguration {
    @Bean
    public UserAgentHelper userAgentHelper(ApplicationContext applicationContext) {
        return new UserAgentHelper(applicationContext);
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class UserAgentReactiveAutoConfiguration
    implements WebFluxConfigurer {
        private final UserAgentHelper userAgentHelper;

        @Bean
        public ReactiveUserAgentFilter reactiveUserAgentFilter() {
            return new ReactiveUserAgentFilter(this.userAgentHelper);
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            configurer.addCustomResolver(new org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver[]{new ReactiveUserAgentResolver(this.userAgentHelper)});
        }

        public UserAgentReactiveAutoConfiguration(UserAgentHelper userAgentHelper) {
            this.userAgentHelper = userAgentHelper;
        }
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class UserAgentMvcAutoConfiguration
    implements WebMvcConfigurer {
        private final UserAgentHelper userAgentHelper;

        @Bean
        public FilterRegistrationBean<UserAgentFilter> filterRegistrationBean() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)new UserAgentFilter(this.userAgentHelper));
            registrationBean.addUrlPatterns(new String[]{"/*"});
            registrationBean.setName("userAgentFilter");
            registrationBean.setOrder(1);
            return registrationBean;
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
            resolvers.add((HandlerMethodArgumentResolver)new UserAgentResolver(this.userAgentHelper));
        }

        public UserAgentMvcAutoConfiguration(UserAgentHelper userAgentHelper) {
            this.userAgentHelper = userAgentHelper;
        }
    }
}

