/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.RawString;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UserTagSectionHelper
extends IncludeSectionHelper
implements SectionHelper {
    private static final String NESTED_CONTENT = "nested-content";
    protected final boolean isNestedContentNeeded;
    private final HtmlEscaper htmlEscaper;
    private final String itKey;

    UserTagSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters, boolean isIsolated, boolean isNestedContentNeeded, HtmlEscaper htmlEscaper, String itKey) {
        super(templateSupplier, extendingBlocks, parameters, isIsolated);
        this.isNestedContentNeeded = isNestedContentNeeded;
        this.htmlEscaper = htmlEscaper;
        this.itKey = itKey;
    }

    @Override
    protected boolean optimizeIfNoParams() {
        return false;
    }

    @Override
    protected void addAdditionalEvaluatedParams(SectionHelper.SectionResolutionContext context, Map<String, Object> evaluatedParams) {
        Expression nestedContent;
        evaluatedParams.put("_args", new Arguments(evaluatedParams));
        if (this.isNestedContentNeeded && (nestedContent = ((TemplateImpl)this.template.get()).findExpression(this::isNestedContent)) != null) {
            evaluatedParams.put(NESTED_CONTENT, context.execute(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)));
        }
    }

    public boolean isNestedContentNeeded() {
        return this.isNestedContentNeeded;
    }

    public HtmlEscaper getHtmlEscaper() {
        return this.htmlEscaper;
    }

    public String getItKey() {
        return this.itKey;
    }

    private boolean isNestedContent(Expression expr) {
        return expr.getParts().size() == 1 && expr.getParts().get(0).getName().equals(NESTED_CONTENT);
    }

    private static String stripQuotationMarks(String value) {
        if (LiteralSupport.isStringLiteral(value)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static class Factory
    extends IncludeSectionHelper.AbstractIncludeFactory<UserTagSectionHelper> {
        public static final String ARGS = "_args";
        private static final String IT = "it";
        private static final String ISOLATED_DEFAULT_VALUE = "true";
        private final String name;
        private final String templateId;
        private final HtmlEscaper htmlEscaper;

        public Factory(String name, String templateId) {
            this.name = name;
            this.templateId = templateId;
            this.htmlEscaper = new HtmlEscaper(List.of());
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(this.name);
        }

        @Override
        String isolatedDefaultValue() {
            return ISOLATED_DEFAULT_VALUE;
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            SectionHelperFactory.ParametersInfo.Builder builder = SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder(IT).defaultValue(IT));
            this.addDefaultParams(builder);
            return builder.build();
        }

        @Override
        protected boolean ignoreParameterInit(Supplier<String> firstParamSupplier, String key, String value) {
            return super.ignoreParameterInit(firstParamSupplier, key, value) || key.equals("_isolated") || value.equals("_isolated") || value.equals("_unisolated") || key.equals(IT) && (!firstParamSupplier.get().equals(value) || value.equals(IT));
        }

        @Override
        protected String getTemplateId(SectionHelperFactory.SectionInitContext context) {
            return this.templateId;
        }

        @Override
        protected UserTagSectionHelper newHelper(Supplier<Template> template, Map<String, Expression> params, Map<String, SectionBlock> extendingBlocks, Boolean isolatedValue, SectionHelperFactory.SectionInitContext context) {
            boolean isNestedContentNeeded = !context.getBlock("$main").isEmpty();
            Expression itKeyExpr = params.getOrDefault(IT, null);
            return new UserTagSectionHelper(template, extendingBlocks, params, isolatedValue != null ? isolatedValue : Boolean.parseBoolean(context.getParameterOrDefault("_isolated", ISOLATED_DEFAULT_VALUE)), isNestedContentNeeded, this.htmlEscaper, itKeyExpr != null ? UserTagSectionHelper.stripQuotationMarks(itKeyExpr.toOriginalString()) : null);
        }

        @Override
        protected void handleParam(String key, String value, Supplier<String> firstParamSupplier, BiConsumer<String, String> paramConsumer) {
            if (key.equals(IT)) {
                if (value.equals(IT)) {
                    return;
                }
                if (this.isSinglePart(value)) {
                    String defaultedKey = UserTagSectionHelper.stripQuotationMarks(value);
                    paramConsumer.accept(defaultedKey, value);
                }
            }
            super.handleParam(key, value, firstParamSupplier, paramConsumer);
        }
    }

    public class Arguments
    implements Iterable<Map.Entry<String, Object>> {
        private final List<Map.Entry<String, Object>> args;

        Arguments(Map<String, Object> map) {
            this.args = new ArrayList<Map.Entry<String, Object>>(Objects.requireNonNull(map).size());
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (e.getKey().equals("it")) continue;
                this.args.add(e);
            }
            this.args.sort(Comparator.comparing(Map.Entry::getKey));
        }

        private Arguments(List<Map.Entry<String, Object>> args, HtmlEscaper htmlEscaper) {
            this.args = args;
        }

        public boolean isEmpty() {
            return this.args.isEmpty();
        }

        public int size() {
            return this.args.size();
        }

        public Object get(String key) {
            for (Map.Entry<String, Object> e : this.args) {
                if (!e.getKey().equals(key)) continue;
                return e.getValue();
            }
            return null;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return this.args.iterator();
        }

        public Arguments skip(String ... keys) {
            Set<String> keySet = Set.of(keys);
            return this.filter((Map.Entry<String, Object> e) -> !keySet.contains(e.getKey()));
        }

        public Arguments skipIdenticalKeyValue() {
            return this.filter((Map.Entry<String, Object> e) -> !((String)e.getKey()).equals(e.getValue()));
        }

        public Arguments skipIt() {
            return this.filter((Map.Entry<String, Object> e) -> !((String)e.getKey()).equals(UserTagSectionHelper.this.itKey));
        }

        public Arguments filter(String ... keys) {
            Set<String> keySet = Set.of(keys);
            return this.filter((Map.Entry<String, Object> e) -> keySet.contains(e.getKey()));
        }

        public Arguments filterIdenticalKeyValue() {
            return this.filter((Map.Entry<String, Object> e) -> ((String)e.getKey()).equals(e.getValue()));
        }

        public RawString asHtmlAttributes() {
            StringBuilder builder = new StringBuilder();
            Iterator<Map.Entry<String, Object>> it = this.args.iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> e = it.next();
                builder.append(e.getKey());
                builder.append("=\"");
                builder.append(UserTagSectionHelper.this.htmlEscaper.escape(String.valueOf(e.getValue())));
                builder.append("\"");
                if (!it.hasNext()) continue;
                builder.append(" ");
            }
            return new RawString(builder.toString());
        }

        public Arguments filter(Predicate<Map.Entry<String, Object>> predicate) {
            ArrayList<Map.Entry<String, Object>> newArgs = new ArrayList<Map.Entry<String, Object>>(this.args.size());
            for (Map.Entry<String, Object> e : this.args) {
                if (!predicate.test(e)) continue;
                newArgs.add(e);
            }
            return new Arguments(newArgs, UserTagSectionHelper.this.htmlEscaper);
        }
    }
}

