/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface HttpAuthenticationMechanism {
    public CompletionStage<SecurityIdentity> authenticate(RoutingContext var1, IdentityProviderManager var2);

    public CompletionStage<ChallengeData> getChallenge(RoutingContext var1);

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes();

    default public CompletionStage<Boolean> sendChallenge(RoutingContext context) {
        return this.getChallenge(context).thenApply(new ChallengeSender(context));
    }

    public HttpCredentialTransport getCredentialTransport();

    public static class ChallengeSender
    implements Function<ChallengeData, Boolean> {
        private final RoutingContext context;

        public ChallengeSender(RoutingContext context) {
            this.context = context;
        }

        @Override
        public Boolean apply(ChallengeData challengeData) {
            if (challengeData == null) {
                return false;
            }
            this.context.response().setStatusCode(challengeData.status);
            if (challengeData.headerName != null) {
                this.context.response().headers().set(challengeData.headerName, (CharSequence)challengeData.headerContent);
            }
            return true;
        }
    }
}

