/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.AuthenticationCompletionException;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

@Recorder
public class HttpSecurityRecorder {
    private static final Logger log = Logger.getLogger(HttpSecurityRecorder.class);
    static volatile String encryptionKey;

    public Handler<RoutingContext> authenticationMechanismHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthenticator authenticator;

            public void handle(final RoutingContext event) {
                if (this.authenticator == null) {
                    this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
                }
                event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
                this.authenticator.attemptAuthentication(event).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

                    @Override
                    public Object apply(SecurityIdentity identity, Throwable throwable) {
                        if (throwable != null) {
                            while (throwable instanceof CompletionException && throwable.getCause() != null) {
                                throwable = throwable.getCause();
                            }
                            if (throwable instanceof AuthenticationFailedException) {
                                authenticator.sendChallenge(event, new Runnable(){

                                    @Override
                                    public void run() {
                                        event.response().end();
                                    }
                                }).exceptionally(new Function<Throwable, Void>(){

                                    @Override
                                    public Void apply(Throwable throwable) {
                                        event.fail(throwable);
                                        return null;
                                    }
                                });
                            } else if (throwable instanceof AuthenticationCompletionException) {
                                event.response().setStatusCode(401);
                                event.response().end();
                            } else if (throwable instanceof AuthenticationRedirectException) {
                                AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                                event.response().setStatusCode(redirectEx.getCode());
                                event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                                event.response().end();
                            } else {
                                event.fail(throwable);
                            }
                            return null;
                        }
                        if (event.response().ended()) {
                            return null;
                        }
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        }
                        event.next();
                        return null;
                    }
                });
            }
        };
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public BeanContainerListener initPermissions(final HttpBuildTimeConfig permissions, final Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                ((PathMatchingHttpSecurityPolicy)container.instance(PathMatchingHttpSecurityPolicy.class, new Annotation[0])).init(permissions, policies);
            }
        };
    }

    public Supplier<FormAuthenticationMechanism> setupFormAuth(final HttpConfiguration httpConfiguration, final HttpBuildTimeConfig buildTimeConfig) {
        return new Supplier<FormAuthenticationMechanism>(){

            @Override
            public FormAuthenticationMechanism get() {
                String key;
                if (!httpConfiguration.encryptionKey.isPresent()) {
                    if (encryptionKey != null) {
                        key = encryptionKey;
                    } else {
                        byte[] data = new byte[32];
                        new SecureRandom().nextBytes(data);
                        key = encryptionKey = Base64.getEncoder().encodeToString(data);
                        log.warn((Object)("Encryption key was not specified for persistent FORM auth, using temporary key " + key));
                    }
                } else {
                    key = httpConfiguration.encryptionKey.get();
                }
                FormAuthConfig form = buildTimeConfig.auth.form;
                PersistentLoginManager loginManager = new PersistentLoginManager(key, form.cookieName, form.timeout.toMillis(), form.newCookieInterval.toMillis());
                String loginPage = form.loginPage.startsWith("/") ? form.loginPage : "/" + form.loginPage;
                String errorPage = form.errorPage.startsWith("/") ? form.errorPage : "/" + form.errorPage;
                String landingPage = form.landingPage.startsWith("/") ? form.landingPage : "/" + form.landingPage;
                boolean redirectAfterLogin = form.redirectAfterLogin;
                return new FormAuthenticationMechanism(loginPage, errorPage, landingPage, redirectAfterLogin, loginManager);
            }
        };
    }

    public Supplier<?> setupBasicAuth(final HttpBuildTimeConfig buildTimeConfig) {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism(buildTimeConfig.auth.realm, "BASIC", buildTimeConfig.auth.form.enabled);
            }
        };
    }
}

