/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class ConstantCodeWriter
implements CodeWriter {
    private final Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap;

    public ConstantCodeWriter(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap) {
        this.methodTypeArgMap = methodTypeArgMap;
    }

    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        for (ConstantInfo constant : model.getConstants()) {
            this.genConstant(model, constant, writer);
        }
    }

    private void genConstant(ClassModel model, ConstantInfo constant, PrintWriter writer) {
        Doc doc = constant.getDoc();
        if (doc != null) {
            writer.println("  /**");
            Token.toHtml((List)doc.getTokens(), (String)"   *", CodeGenHelper::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            writer.println("   */");
        }
        writer.print(model.isConcrete() ? "  public static final" : "");
        writer.format(" %s %s = %s;%n", this.genTypeName(constant.getType()), constant.getName(), CodeGenHelper.genConvReturn(this.methodTypeArgMap, constant.getType(), null, model.getType().getName() + "." + constant.getName()));
    }
}

