/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.eclipse;

import io.spring.javaformat.formatter.eclipse.DefaultCodeFormatterOptions;
import io.spring.javaformat.formatter.eclipse.Token;
import io.spring.javaformat.formatter.eclipse.TokenManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;

public class LineBreaksPreparator
extends ASTVisitor {
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private boolean declarationModifierVisited;

    public LineBreaksPreparator(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    public boolean visit(CompilationUnit node) {
        List imports = node.imports();
        if (!imports.isEmpty() && this.tm.firstIndexIn((ASTNode)imports.get(0), -1) > 0) {
            this.putBlankLinesBefore((ASTNode)imports.get(0), this.options.blank_lines_before_imports);
        }
        int i = 1;
        while (i < imports.size()) {
            int from = this.tm.lastIndexIn((ASTNode)imports.get(i - 1), -1);
            int to = this.tm.firstIndexIn((ASTNode)imports.get(i), -1);
            int j = from;
            while (j < to) {
                Token token2;
                Token token1 = this.tm.get(j);
                if (this.tm.countLineBreaksBetween(token1, token2 = this.tm.get(j + 1)) > 1) {
                    this.putBlankLinesAfter(token1, this.options.blank_lines_between_import_groups);
                }
                ++j;
            }
            ++i;
        }
        List types = node.types();
        if (!types.isEmpty()) {
            if (!imports.isEmpty()) {
                this.putBlankLinesBefore((ASTNode)types.get(0), this.options.blank_lines_after_imports);
            }
            int i2 = 1;
            while (i2 < types.size()) {
                this.putBlankLinesBefore((ASTNode)types.get(i2), this.options.blank_lines_between_type_declarations);
                ++i2;
            }
        }
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        if (node.getJavadoc() == null) {
            this.putBlankLinesBefore((ASTNode)node, this.options.blank_lines_before_package);
        } else {
            this.putBlankLinesAfter(this.tm.lastTokenIn((ASTNode)node.getJavadoc(), -1), this.options.blank_lines_before_package);
        }
        this.putBlankLinesAfter(this.tm.lastTokenIn((ASTNode)node, -1), this.options.blank_lines_after_package);
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        this.breakLineBefore((ASTNode)node);
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        this.handleBodyDeclarations(node.bodyDeclarations());
        if (node.getName().getStartPosition() == -1) {
            return true;
        }
        this.breakLineBefore((ASTNode)node);
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getName(), this.options.brace_position_for_type_declaration, this.options.indent_body_declarations_compare_to_type_header);
        this.declarationModifierVisited = false;
        return true;
    }

    private void handleBodyDeclarations(List<BodyDeclaration> bodyDeclarations) {
        BodyDeclaration previous = null;
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            int blankLines = 0;
            if (previous == null) {
                blankLines = this.options.blank_lines_before_first_class_body_declaration;
            } else if (!this.sameChunk(previous, bodyDeclaration)) {
                blankLines = this.options.blank_lines_before_new_chunk;
            } else if (bodyDeclaration instanceof FieldDeclaration) {
                blankLines = this.options.blank_lines_before_field;
            } else if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                blankLines = this.options.blank_lines_before_member_type;
            } else if (bodyDeclaration instanceof MethodDeclaration) {
                blankLines = ((MethodDeclaration)bodyDeclaration).getBody() == null && ((MethodDeclaration)previous).getBody() == null ? this.options.blank_lines_before_abstract_method : this.options.blank_lines_before_method;
            } else if (bodyDeclaration instanceof AnnotationTypeMemberDeclaration) {
                blankLines = this.options.blank_lines_before_method;
            }
            this.putBlankLinesBefore((ASTNode)bodyDeclaration, blankLines);
            previous = bodyDeclaration;
        }
        if (previous != null) {
            Token lastToken = this.tm.lastTokenIn(previous.getParent(), -1);
            if (lastToken.tokenType == 33) {
                this.putBlankLinesBefore(lastToken, this.options.blank_lines_after_last_class_body_declaration);
            }
        }
    }

    private boolean sameChunk(BodyDeclaration bd1, BodyDeclaration bd2) {
        if (bd1.getClass().equals(bd2.getClass())) {
            return true;
        }
        if (bd1 instanceof AbstractTypeDeclaration && bd2 instanceof AbstractTypeDeclaration) {
            return true;
        }
        return !(!(bd1 instanceof FieldDeclaration) && !(bd1 instanceof Initializer) || !(bd2 instanceof FieldDeclaration) && !(bd2 instanceof Initializer));
    }

    public boolean visit(EnumDeclaration node) {
        int index;
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getName(), this.options.brace_position_for_enum_declaration, this.options.indent_body_declarations_compare_to_enum_declaration_header);
        ArrayList<BodyDeclaration> declarations = node.bodyDeclarations();
        List enumConstants = node.enumConstants();
        if (!declarations.isEmpty()) {
            if (!enumConstants.isEmpty()) {
                declarations = new ArrayList<BodyDeclaration>(declarations);
                declarations.add(0, (BodyDeclaration)enumConstants.get(0));
            }
            this.handleBodyDeclarations((List<BodyDeclaration>)declarations);
        }
        int i = 0;
        while (i < enumConstants.size()) {
            EnumConstantDeclaration declaration = (EnumConstantDeclaration)enumConstants.get(i);
            if (declaration.getJavadoc() != null) {
                this.tm.firstTokenIn((ASTNode)declaration, 1003).breakBefore();
            }
            if (declaration.getAnonymousClassDeclaration() != null && i < enumConstants.size() - 1) {
                this.tm.firstTokenAfter((ASTNode)declaration, 32).breakAfter();
            }
            ++i;
        }
        int n = index = enumConstants.isEmpty() ? this.tm.firstIndexAfter((ASTNode)node.getName(), 49) + 1 : this.tm.firstIndexAfter((ASTNode)enumConstants.get(enumConstants.size() - 1), -1);
        while (true) {
            Token token;
            if (!(token = this.tm.get(index)).isComment()) {
                if (token.tokenType != 25) break;
                token.breakAfter();
            }
            ++index;
        }
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getName(), this.options.brace_position_for_annotation_type_declaration, this.options.indent_body_declarations_compare_to_annotation_declaration_header);
        this.handleBodyDeclarations(node.bodyDeclarations());
        if (node.getModifiers() == 0) {
            this.tm.firstTokenBefore((ASTNode)node.getName(), 37).breakBefore();
        }
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        if (node.getParent() instanceof EnumConstantDeclaration) {
            this.handleBracedCode((ASTNode)node, null, this.options.brace_position_for_enum_constant, this.options.indent_body_declarations_compare_to_enum_constant_header);
        } else {
            this.handleBracedCode((ASTNode)node, null, this.options.brace_position_for_anonymous_type_declaration, this.options.indent_body_declarations_compare_to_type_header);
        }
        this.handleBodyDeclarations(node.bodyDeclarations());
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        this.declarationModifierVisited = false;
        if (node.getBody() == null) {
            return true;
        }
        String bracePosition = node.isConstructor() ? this.options.brace_position_for_constructor_declaration : this.options.brace_position_for_method_declaration;
        this.handleBracedCode((ASTNode)node.getBody(), null, bracePosition, this.options.indent_statements_compare_to_body, this.options.blank_lines_at_beginning_of_method_body, this.options.blank_lines_at_end_of_method_body);
        return true;
    }

    public boolean visit(Block node) {
        List statements = node.statements();
        for (Statement statement : statements) {
            if (!this.options.put_empty_statement_on_new_line && statement instanceof EmptyStatement) continue;
            this.breakLineBefore((ASTNode)statement);
        }
        ASTNode parent = node.getParent();
        if (parent.getLength() == 0) {
            return true;
        }
        if (parent instanceof MethodDeclaration) {
            return true;
        }
        String bracePosition = this.options.brace_position_for_block;
        if (parent instanceof SwitchStatement) {
            boolean isFirstInCase;
            List siblings = ((SwitchStatement)parent).statements();
            int blockPosition = siblings.indexOf(node);
            boolean bl = isFirstInCase = blockPosition > 0 && siblings.get(blockPosition - 1) instanceof SwitchCase;
            if (isFirstInCase) {
                bracePosition = this.options.brace_position_for_block_in_case;
            }
        } else if (parent instanceof LambdaExpression) {
            bracePosition = this.options.brace_position_for_lambda_body;
        }
        this.handleBracedCode((ASTNode)node, null, bracePosition, this.options.indent_statements_compare_to_block, this.options.blank_lines_at_beginning_of_code_block, this.options.blank_lines_at_end_of_code_block);
        if (parent instanceof Block) {
            this.blankLinesAroundBlock((ASTNode)node, ((Block)parent).statements());
        } else if (parent instanceof Statement && parent.getParent() instanceof Block) {
            this.blankLinesAroundBlock(parent, ((Block)parent.getParent()).statements());
        }
        return true;
    }

    private void blankLinesAroundBlock(ASTNode blockStatement, List<ASTNode> siblings) {
        int blockIndex;
        this.putBlankLinesBefore(blockStatement, this.options.blank_lines_before_code_block);
        if (!this.options.put_empty_statement_on_new_line && (blockIndex = siblings.indexOf(blockStatement)) + 1 < siblings.size() && siblings.get(blockIndex + 1) instanceof EmptyStatement) {
            return;
        }
        this.putBlankLinesAfter(this.tm.lastTokenIn(blockStatement, -1), this.options.blank_lines_after_code_block);
    }

    public boolean visit(SwitchStatement node) {
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getExpression(), this.options.brace_position_for_switch, this.options.indent_switchstatements_compare_to_switch, this.options.blank_lines_at_beginning_of_code_block, this.options.blank_lines_at_end_of_code_block);
        List statements = node.statements();
        this.doSwitchStatementsIndentation((ASTNode)node, statements);
        this.doSwitchStatementsLineBreaks(statements);
        if (node.getParent() instanceof Block) {
            this.blankLinesAroundBlock((ASTNode)node, ((Block)node.getParent()).statements());
        }
        return true;
    }

    public boolean visit(SwitchExpression node) {
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getExpression(), this.options.brace_position_for_switch, this.options.indent_switchstatements_compare_to_switch, this.options.blank_lines_at_beginning_of_code_block, this.options.blank_lines_at_end_of_code_block);
        List statements = node.statements();
        this.doSwitchStatementsIndentation((ASTNode)node, statements);
        this.doSwitchStatementsLineBreaks(statements);
        return true;
    }

    private void doSwitchStatementsIndentation(ASTNode switchNode, List<Statement> statements) {
        if (this.options.indent_switchstatements_compare_to_cases) {
            int nonBreakStatementEnd = -1;
            for (Statement statement : statements) {
                boolean isBreaking = this.isSwitchBreakingStatement(statement);
                if (isBreaking && !(statement instanceof Block)) {
                    this.adjustEmptyLineAfter(this.tm.lastIndexIn((ASTNode)statement, -1), -1);
                }
                if (statement instanceof SwitchCase) {
                    if (nonBreakStatementEnd >= 0) {
                        this.tm.get(nonBreakStatementEnd + 1).indent();
                        this.tm.firstTokenIn((ASTNode)statement, -1).unindent();
                    }
                } else if (!(statement instanceof BreakStatement || statement instanceof YieldStatement || statement instanceof Block)) {
                    this.indent((ASTNode)statement);
                }
                int n = nonBreakStatementEnd = isBreaking ? -1 : this.tm.lastIndexIn((ASTNode)statement, -1);
            }
            if (nonBreakStatementEnd >= 0) {
                this.tm.get(nonBreakStatementEnd + 1).indent();
                this.tm.lastTokenIn(switchNode, 33).unindent();
            }
        }
        if (this.options.indent_breaks_compare_to_cases) {
            for (Statement statement : statements) {
                if (!(statement instanceof BreakStatement) && !(statement instanceof YieldStatement)) continue;
                this.indent((ASTNode)statement);
            }
        }
    }

    private void doSwitchStatementsLineBreaks(List<Statement> statements) {
        boolean arrowMode = statements.stream().anyMatch(s -> s instanceof SwitchCase && ((SwitchCase)s).isSwitchLabeledRule());
        Statement previous = null;
        for (Statement statement : statements) {
            boolean skip;
            boolean bl = skip = statement instanceof Block || arrowMode && !(statement instanceof SwitchCase) || statement instanceof EmptyStatement && !this.options.put_empty_statement_on_new_line;
            if (!skip) {
                boolean newGroup = !arrowMode && statement instanceof SwitchCase && this.isSwitchBreakingStatement(previous);
                int blankLines = newGroup ? this.options.blank_lines_between_statement_groups_in_switch : 0;
                this.putBlankLinesBefore((ASTNode)statement, blankLines);
            }
            previous = statement;
        }
    }

    private boolean isSwitchBreakingStatement(Statement statement) {
        return statement instanceof BreakStatement || statement instanceof ReturnStatement || statement instanceof ContinueStatement || statement instanceof ThrowStatement || statement instanceof YieldStatement || statement instanceof Block;
    }

    public boolean visit(DoStatement node) {
        Statement body = node.getBody();
        boolean sameLine = this.options.keep_simple_do_while_body_on_same_line;
        if (!sameLine) {
            this.handleLoopBody(body);
        }
        if (this.options.insert_new_line_before_while_in_do_statement || !(body instanceof Block) && !(body instanceof EmptyStatement) && !sameLine) {
            Token whileToken = this.tm.firstTokenBefore((ASTNode)node.getExpression(), 76);
            whileToken.breakBefore();
        }
        return true;
    }

    public boolean visit(LabeledStatement node) {
        if (this.options.insert_new_line_after_label) {
            this.tm.firstTokenIn((ASTNode)node, 63).breakAfter();
        }
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        int closeBraceIndex;
        boolean isEmpty;
        int openBraceIndex = this.tm.firstIndexIn((ASTNode)node, 49);
        boolean bl = isEmpty = openBraceIndex + 1 == (closeBraceIndex = this.tm.lastIndexIn((ASTNode)node, 33));
        if (isEmpty) {
            this.adjustEmptyLineAfter(openBraceIndex, this.options.continuation_indentation_for_array_initializer);
            closeBraceIndex = this.tm.lastIndexIn((ASTNode)node, 33);
        }
        Token openBraceToken = this.tm.get(openBraceIndex);
        Token closeBraceToken = this.tm.get(closeBraceIndex);
        if (!(node.getParent() instanceof ArrayInitializer)) {
            Token afterOpenBraceToken = this.tm.get(openBraceIndex + 1);
            int i = 0;
            while (i < this.options.continuation_indentation_for_array_initializer) {
                afterOpenBraceToken.indent();
                closeBraceToken.unindent();
                ++i;
            }
        }
        if (!isEmpty || !this.options.keep_empty_array_initializer_on_one_line) {
            this.handleBracePosition(openBraceToken, closeBraceIndex, this.options.brace_position_for_array_initializer);
        }
        if (!isEmpty) {
            if (this.options.insert_new_line_after_opening_brace_in_array_initializer) {
                openBraceToken.breakAfter();
            }
            if (this.options.insert_new_line_before_closing_brace_in_array_initializer) {
                closeBraceToken.breakBefore();
            }
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        this.handleAnnotation((Annotation)node);
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.handleAnnotation((Annotation)node);
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        this.handleAnnotation((Annotation)node);
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.declarationModifierVisited = false;
        if (node.getParent() instanceof MethodDeclaration) {
            this.declarationModifierVisited = node.getModifiers() == 0;
        }
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(Modifier node) {
        this.declarationModifierVisited = true;
        return true;
    }

    private void handleAnnotation(Annotation node) {
        ASTNode parentNode = node.getParent();
        boolean breakAfter = false;
        boolean isTypeAnnotation = this.declarationModifierVisited;
        if (isTypeAnnotation) {
            breakAfter = this.options.insert_new_line_after_type_annotation;
        } else if (parentNode instanceof PackageDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_package;
        } else if (parentNode instanceof AbstractTypeDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_type;
        } else if (parentNode instanceof EnumConstantDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_enum_constant;
        } else if (parentNode instanceof FieldDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_field;
        } else if (parentNode instanceof MethodDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_method;
        } else if (parentNode instanceof AnnotationTypeMemberDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_method && ((AnnotationTypeMemberDeclaration)parentNode).getDefault() != node;
        } else if (parentNode instanceof VariableDeclarationStatement || parentNode instanceof VariableDeclarationExpression) {
            breakAfter = this.options.insert_new_line_after_annotation_on_local_variable;
        } else if (parentNode instanceof SingleVariableDeclaration) {
            breakAfter = this.options.insert_new_line_after_annotation_on_parameter;
            if (parentNode.getParent() instanceof EnhancedForStatement) {
                breakAfter = this.options.insert_new_line_after_annotation_on_local_variable;
            }
        }
        if (breakAfter) {
            this.tm.lastTokenIn((ASTNode)node, -1).breakAfter();
        }
    }

    public boolean visit(WhileStatement node) {
        if (!this.options.keep_simple_while_body_on_same_line) {
            this.handleLoopBody(node.getBody());
        }
        return true;
    }

    public boolean visit(ForStatement node) {
        if (!this.options.keep_simple_for_body_on_same_line) {
            this.handleLoopBody(node.getBody());
        }
        return true;
    }

    public boolean visit(EnhancedForStatement node) {
        if (!this.options.keep_simple_for_body_on_same_line) {
            this.handleLoopBody(node.getBody());
        }
        return true;
    }

    private void handleLoopBody(Statement body) {
        if (body instanceof Block) {
            return;
        }
        if (body instanceof EmptyStatement && !this.options.put_empty_statement_on_new_line && !(body.getParent() instanceof IfStatement)) {
            return;
        }
        this.breakLineBefore((ASTNode)body);
        this.adjustEmptyLineAfter(this.tm.lastIndexIn((ASTNode)body, -1), -1);
        this.indent((ASTNode)body);
    }

    public boolean visit(IfStatement node) {
        boolean keepThenOnSameLine;
        Statement elseNode = node.getElseStatement();
        Statement thenNode = node.getThenStatement();
        if (elseNode != null) {
            boolean keepElseOnSameLine;
            if (this.options.insert_new_line_before_else_in_if_statement || !(thenNode instanceof Block)) {
                this.tm.firstTokenBefore((ASTNode)elseNode, 114).breakBefore();
            }
            boolean bl = keepElseOnSameLine = this.options.keep_else_statement_on_same_line || this.options.compact_else_if && elseNode instanceof IfStatement;
            if (!keepElseOnSameLine) {
                this.handleLoopBody(elseNode);
            }
        }
        boolean bl = keepThenOnSameLine = this.options.keep_then_statement_on_same_line || this.options.keep_simple_if_on_one_line && elseNode == null;
        if (!keepThenOnSameLine) {
            this.handleLoopBody(thenNode);
        }
        return true;
    }

    public boolean visit(TryStatement node) {
        if (node.getFinally() != null && this.options.insert_new_line_before_finally_in_try_statement) {
            this.tm.firstTokenBefore((ASTNode)node.getFinally(), 113).breakBefore();
        }
        return true;
    }

    public boolean visit(CatchClause node) {
        if (this.options.insert_new_line_before_catch_in_try_statement) {
            this.breakLineBefore((ASTNode)node);
        }
        return true;
    }

    public boolean visit(ModuleDeclaration node) {
        this.breakLineBefore((ASTNode)node);
        List statements = node.moduleStatements();
        this.handleBracedCode((ASTNode)node, (ASTNode)node.getName(), this.options.brace_position_for_type_declaration, this.options.indent_body_declarations_compare_to_type_header, statements.isEmpty() ? 0 : this.options.blank_lines_before_first_class_body_declaration, statements.isEmpty() ? 0 : this.options.blank_lines_after_last_class_body_declaration);
        Object previous = null;
        for (ModuleDirective statement : statements) {
            if (previous != null) {
                boolean cameChunk = previous.getClass().equals(statement.getClass());
                this.putBlankLinesBefore((ASTNode)statement, cameChunk ? this.options.blank_lines_before_field : this.options.blank_lines_before_new_chunk);
            }
            previous = statement;
        }
        this.declarationModifierVisited = false;
        return true;
    }

    public boolean visit(TextBlock node) {
        int indentOption = this.options.text_block_indentation;
        if (indentOption == 8) {
            return true;
        }
        Token block = this.tm.firstTokenIn((ASTNode)node, 48);
        ArrayList<Token> lines = new ArrayList<Token>();
        lines.add(new Token(block.originalStart, block.originalStart + 2, 0));
        int incidentalWhitespace = Integer.MAX_VALUE;
        int blankLines = -1;
        int i = block.originalStart + 3;
        while (i <= block.originalEnd) {
            int lineStart = i;
            int firstNonBlank = -1;
            int lastNonBlank = -1;
            while (i <= block.originalEnd) {
                char c;
                if ((c = this.tm.charAt(i++)) == '\r' || c == '\n') {
                    char c2 = this.tm.charAt(i);
                    if (c2 != '\r' && c2 != '\n' || c2 == c) break;
                    ++i;
                    break;
                }
                if (c == ' ' || c == '\t') continue;
                if (firstNonBlank == -1) {
                    firstNonBlank = i - 1;
                }
                lastNonBlank = i - 1;
            }
            if (firstNonBlank != -1) {
                Token line = new Token(lineStart, lastNonBlank, 0);
                line.putLineBreaksBefore(blankLines + 1);
                blankLines = 0;
                lines.add(line);
                incidentalWhitespace = Math.min(incidentalWhitespace, firstNonBlank - lineStart);
                continue;
            }
            ++blankLines;
        }
        Token.WrapPolicy wrapPolicy = new Token.WrapPolicy(Token.WrapMode.DISABLED, 0, -1, 0, 0, 1.0f, false, false);
        i = 1;
        while (i < lines.size()) {
            Token t = lines.get(i);
            Token line = new Token(t, t.originalStart + incidentalWhitespace, t.originalEnd, 48);
            line.setWrapPolicy(wrapPolicy);
            lines.set(i, line);
            ++i;
        }
        block.setInternalStructure(lines);
        return true;
    }

    private void breakLineBefore(ASTNode node) {
        this.tm.firstTokenIn(node, -1).breakBefore();
    }

    private void putBlankLinesBefore(ASTNode node, int linesCount) {
        int index = this.tm.firstIndexIn(node, -1);
        while (index > 0 && this.tm.get((int)(index - 1)).tokenType == 1003) {
            --index;
        }
        this.putBlankLinesBefore(this.tm.get(index), linesCount);
    }

    private void putBlankLinesBefore(Token token, int linesCount) {
        if (linesCount >= 0) {
            token.putLineBreaksBefore(linesCount + 1);
        } else {
            token.putLineBreaksBefore(~linesCount + 1);
            token.setPreserveLineBreaksBefore(false);
        }
    }

    private void putBlankLinesAfter(Token token, int linesCount) {
        if (linesCount >= 0) {
            token.putLineBreaksAfter(linesCount + 1);
        } else {
            token.putLineBreaksAfter(~linesCount + 1);
            token.setPreserveLineBreaksAfter(false);
        }
    }

    private void handleBracedCode(ASTNode node, ASTNode nodeBeforeOpenBrace, String bracePosition, boolean indentBody) {
        this.handleBracedCode(node, nodeBeforeOpenBrace, bracePosition, indentBody, 0, 0);
    }

    private void handleBracedCode(ASTNode node, ASTNode nodeBeforeOpenBrace, String bracePosition, boolean indentBody, int blankLinesAfterOpeningBrace, int blankLinesBeforeClosingBrace) {
        int openBraceIndex = nodeBeforeOpenBrace == null ? this.tm.firstIndexIn(node, 49) : this.tm.firstIndexAfter(nodeBeforeOpenBrace, 49);
        int closeBraceIndex = this.tm.lastIndexIn(node, 33);
        Token openBraceToken = this.tm.get(openBraceIndex);
        Token closeBraceToken = this.tm.get(closeBraceIndex);
        this.handleBracePosition(openBraceToken, closeBraceIndex, bracePosition);
        this.putBlankLinesAfter(openBraceToken, blankLinesAfterOpeningBrace);
        this.putBlankLinesBefore(closeBraceToken, blankLinesBeforeClosingBrace);
        if (indentBody) {
            this.adjustEmptyLineAfter(openBraceIndex, 1);
            this.tm.get(openBraceIndex + 1).indent();
            closeBraceToken.unindent();
        }
    }

    private void handleBracePosition(Token openBraceToken, int closeBraceIndex, String bracePosition) {
        if (bracePosition.equals("next_line")) {
            openBraceToken.breakBefore();
        } else if (bracePosition.equals("next_line_shifted")) {
            openBraceToken.breakBefore();
            openBraceToken.indent();
            if (closeBraceIndex + 1 < this.tm.size()) {
                this.tm.get(closeBraceIndex + 1).unindent();
            }
        } else if (bracePosition.equals("next_line_on_wrap")) {
            openBraceToken.setNextLineOnWrap();
        }
    }

    private void adjustEmptyLineAfter(int tokenIndex, int indentationAdjustment) {
        Token next;
        if (tokenIndex + 1 >= this.tm.size()) {
            return;
        }
        Token token = this.tm.get(tokenIndex);
        if (this.tm.countLineBreaksBetween(token, next = this.tm.get(tokenIndex + 1)) < 2 || !this.options.indent_empty_lines) {
            return;
        }
        next.setEmptyLineIndentAdjustment(indentationAdjustment * this.options.indentation_size);
    }

    private void indent(ASTNode node) {
        int startIndex = this.tm.firstIndexIn(node, -1);
        while (startIndex > 0 && this.tm.get(startIndex - 1).isComment()) {
            --startIndex;
        }
        this.tm.get(startIndex).indent();
        int lastIndex = this.tm.lastIndexIn(node, -1);
        if (lastIndex + 1 < this.tm.size()) {
            this.tm.get(lastIndex + 1).unindent();
        }
    }

    public void finishUp() {
        int currentIndent = this.options.initial_indentation_level;
        for (Token token : this.tm) {
            token.setIndent((currentIndent += token.getIndent()) * this.options.indentation_size);
        }
    }
}

