/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.eclipse.linewrap;

import io.spring.javaformat.formatter.eclipse.DefaultCodeFormatterOptions;
import io.spring.javaformat.formatter.eclipse.Token;
import io.spring.javaformat.formatter.eclipse.TokenManager;
import io.spring.javaformat.formatter.eclipse.TokenTraverser;
import io.spring.javaformat.formatter.eclipse.linewrap.CommentWrapExecutor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class WrapExecutor {
    private static final int[] EMPTY_ARRAY = new int[0];
    final HashMap<WrapInfo, WrapResult> wrapSearchResults = new HashMap();
    private final ArrayDeque<WrapInfo> wrapSearchStack = new ArrayDeque();
    private final LineAnalyzer lineAnalyzer;
    final TokenManager tm;
    final DefaultCodeFormatterOptions options;
    private final WrapInfo wrapInfoTemp = new WrapInfo();

    public WrapExecutor(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
        this.lineAnalyzer = new LineAnalyzer(tokenManager, options);
    }

    public void executeWraps() {
        this.tm.traverse(0, new WrapsApplier());
        this.tm.traverse(0, new NLSTagHandler());
    }

    /*
     * Unable to fully structure code
     */
    WrapResult findWrapsCached(int startTokenIndex, int indent) {
        this.wrapInfoTemp.wrapTokenIndex = startTokenIndex;
        this.wrapInfoTemp.indent = indent;
        wr = wrapResult = this.wrapSearchResults.get(this.wrapInfoTemp);
        cacheMissAllowed = true;
        lookupLimit = 50;
        while (wr != null && wr.nextWrap != null && lookupLimit-- > 0) {
            wi = wr.nextWrap;
            token = this.tm.get(wi.wrapTokenIndex);
            if (token.getWrapPolicy().wrapParentIndex < startTokenIndex && this.getWrapIndent(token) != wi.indent) {
                wrapResult = null;
                cacheMissAllowed = false;
                break;
            }
            wr = this.wrapSearchResults.get(wi);
        }
        if (wrapResult != null) {
            return wrapResult;
        }
        this.wrapSearchStack.push(new WrapInfo(startTokenIndex, indent));
        if (this.wrapSearchStack.size() > 1 && cacheMissAllowed) {
            return null;
        }
        reverseStackTemp = new ArrayList<WrapInfo>();
        while (true) {
            item = this.wrapSearchStack.peek();
            token = this.tm.get(item.wrapTokenIndex);
            token.setWrapped(true);
            wrapResult = this.findWraps(item.wrapTokenIndex, item.indent);
            if (!WrapExecutor.$assertionsDisabled && wrapResult == null != (this.wrapSearchStack.peek() != item)) {
                throw new AssertionError();
            }
            if (wrapResult == null) ** GOTO lbl40
            token.setWrapped(false);
            this.wrapSearchStack.pop();
            this.wrapSearchResults.put(item, wrapResult);
            if (!WrapExecutor.$assertionsDisabled && wrapResult.nextWrap != null && this.wrapSearchResults.get(wrapResult.nextWrap) == null) {
                throw new AssertionError();
            }
            if (item.wrapTokenIndex != startTokenIndex || item.indent != indent) continue;
            break;
lbl-1000:
            // 1 sources

            {
                reverseStackTemp.add(this.wrapSearchStack.pop());
lbl40:
                // 2 sources

                ** while (this.wrapSearchStack.peek() != item)
            }
lbl41:
            // 2 sources

            for (WrapInfo item2 : reverseStackTemp) {
                this.wrapSearchStack.push(item2);
            }
            reverseStackTemp.clear();
        }
        if (!WrapExecutor.$assertionsDisabled && wrapResult == null) {
            throw new AssertionError();
        }
        return wrapResult;
    }

    private WrapResult findWraps(int wrapTokenIndex, int indent) {
        int currentDepth;
        int lastIndex = this.lineAnalyzer.analyzeLine(wrapTokenIndex, indent);
        boolean nextLineWrapped = this.lineAnalyzer.isNextLineWrapped;
        int lineOverflow = Math.max(0, this.lineAnalyzer.lineWidthExtent - this.options.page_width);
        boolean wrapRequired = lineOverflow > 0 || nextLineWrapped;
        int extraLines = this.lineAnalyzer.extraLines;
        int firstPotentialWrap = this.lineAnalyzer.firstPotentialWrap;
        int activeTopPriorityWrap = this.lineAnalyzer.activeTopPriorityWrap;
        int[] extraLinesPerComment = this.toArray(this.lineAnalyzer.extraLinesPerComment);
        int commentIndex = extraLinesPerComment.length;
        int[] topPriorityGroupStarts = this.toArray(this.lineAnalyzer.topPriorityGroupStarts);
        int topPriorityIndex = topPriorityGroupStarts.length - 1;
        int nearestGroupEnd = topPriorityIndex == -1 ? 0 : this.tm.get((int)topPriorityGroupStarts[topPriorityIndex]).getWrapPolicy().groupEndIndex;
        double bestTotalPenalty = this.getWrapPenalty(wrapTokenIndex, indent, lastIndex + 1, -1, WrapResult.NO_WRAP_NEEDED);
        int bestExtraPenalty = lineOverflow + extraLines;
        int bestNextWrap = -1;
        int bestIndent = 0;
        boolean cacheMiss = false;
        if (!(wrapRequired || activeTopPriorityWrap >= 0 || this.options.join_wrapped_lines && this.options.wrap_outer_expressions_when_nested)) {
            return new WrapResult(bestTotalPenalty, bestExtraPenalty, null);
        }
        int depthLimit = Integer.MAX_VALUE;
        Token token = this.tm.get(wrapTokenIndex);
        if (token.isWrappable() && this.options.wrap_outer_expressions_when_nested && activeTopPriorityWrap < 0 && this.lineAnalyzer.minStructureDepth < (currentDepth = token.getWrapPolicy().structureDepth)) {
            depthLimit = currentDepth;
        }
        LinkedHashSet<Token.WrapPolicy> policiesTried = new LinkedHashSet<Token.WrapPolicy>();
        int i = lastIndex;
        while (firstPotentialWrap >= 0 && i >= firstPotentialWrap) {
            block16: {
                block15: {
                    token = this.tm.get(i);
                    if (commentIndex > 0 && (token.tokenType == 1002 || token.tokenType == 1003)) {
                        extraLines -= extraLinesPerComment[--commentIndex];
                        if (extraLinesPerComment[commentIndex] > 0) {
                            policiesTried.clear();
                        }
                    }
                    if (topPriorityIndex < 0 || i > nearestGroupEnd) break block15;
                    if (i > topPriorityGroupStarts[topPriorityIndex]) break block16;
                    assert (i == topPriorityGroupStarts[topPriorityIndex]);
                    nearestGroupEnd = --topPriorityIndex == -1 ? 0 : this.tm.get((int)topPriorityGroupStarts[topPriorityIndex]).getWrapPolicy().groupEndIndex;
                }
                Token.WrapPolicy wrapPolicy = token.getWrapPolicy();
                if (token.isWrappable() && (activeTopPriorityWrap < 0 || i == activeTopPriorityWrap) && !policiesTried.contains(wrapPolicy) && wrapPolicy.structureDepth < depthLimit) {
                    policiesTried.add(wrapPolicy);
                    int nextWrapIndent = this.getWrapIndent(token);
                    WrapResult nextWrapResult = this.findWrapsCached(i, nextWrapIndent);
                    if (!(cacheMiss |= nextWrapResult == null)) {
                        boolean isBetter;
                        double totalPenalty = this.getWrapPenalty(wrapTokenIndex, indent, i, nextWrapIndent, nextWrapResult);
                        int totalExtraPenalty = nextWrapResult.extraPenalty + extraLines;
                        if (lineOverflow > 0) {
                            int position = this.tm.getPositionInLine(i - 1);
                            position += this.tm.getLength(this.tm.get(i - 1), position);
                            lineOverflow = position - this.options.page_width;
                            totalExtraPenalty += Math.max(0, lineOverflow);
                        }
                        boolean bl = isBetter = totalExtraPenalty < bestExtraPenalty || i == activeTopPriorityWrap || bestNextWrap < 0 && wrapRequired;
                        if (!isBetter && totalExtraPenalty == bestExtraPenalty) {
                            boolean bl2 = isBetter = totalPenalty < bestTotalPenalty || bestTotalPenalty == Double.MAX_VALUE;
                        }
                        if (isBetter) {
                            bestTotalPenalty = totalPenalty;
                            bestExtraPenalty = totalExtraPenalty;
                            bestNextWrap = i;
                            bestIndent = nextWrapIndent;
                            if (!this.options.wrap_outer_expressions_when_nested || i == activeTopPriorityWrap || nextLineWrapped) break;
                        }
                    }
                }
            }
            --i;
        }
        if (cacheMiss) {
            return null;
        }
        return new WrapResult(bestTotalPenalty, bestExtraPenalty, bestNextWrap == -1 ? null : new WrapInfo(bestNextWrap, bestIndent));
    }

    private double getWrapPenalty(int lineStartIndex, int lineIndent, int wrapIndex, int wrapIndent, WrapResult wrapResult) {
        double penalty;
        Token.WrapPolicy wrapPolicy = null;
        Token wrapToken = null;
        if (wrapIndex < this.tm.size()) {
            wrapToken = this.tm.get(wrapIndex);
            wrapPolicy = wrapToken.getWrapPolicy();
            if (wrapIndent < 0) {
                wrapIndent = this.getWrapIndent(this.tm.get(wrapIndex));
            }
        }
        double d = penalty = wrapToken != null && wrapToken.isWrappable() ? this.getPenalty(wrapPolicy) : 0.0;
        if (wrapIndent > lineIndent) {
            penalty *= 1.1875;
        }
        Token lineStartToken = this.tm.get(lineStartIndex);
        Token.WrapPolicy lineStartWrapPolicy = lineStartToken.getWrapPolicy();
        if (wrapToken != null && wrapToken.isWrappable() && lineStartToken.isWrappable()) {
            int i = lineStartIndex + 1;
            while (i < wrapIndex) {
                Token.WrapPolicy intermediatePolicy = this.tm.get(i).getWrapPolicy();
                if (intermediatePolicy != null && intermediatePolicy.structureDepth < lineStartWrapPolicy.structureDepth && intermediatePolicy.structureDepth < wrapPolicy.structureDepth) {
                    penalty += this.getPenalty(intermediatePolicy) * 1.25;
                }
                ++i;
            }
        }
        WrapInfo nextWrap = wrapResult.nextWrap;
        boolean checkDepth = wrapToken != null && wrapToken.isWrappable() && (lineStartWrapPolicy == null || wrapPolicy.structureDepth >= lineStartWrapPolicy.structureDepth);
        double penaltyDiff = 0.0;
        while (checkDepth && nextWrap != null) {
            Token.WrapPolicy nextPolicy = this.tm.get(nextWrap.wrapTokenIndex).getWrapPolicy();
            if (nextPolicy.wrapParentIndex == wrapPolicy.wrapParentIndex || penaltyDiff != 0.0 && !wrapPolicy.isFirstInGroup) {
                penalty -= penaltyDiff * 1.015625;
                break;
            }
            if (nextPolicy.structureDepth <= wrapPolicy.structureDepth) break;
            penaltyDiff = Math.max(penaltyDiff, this.getPenalty(nextPolicy));
            nextWrap = this.wrapSearchResults.get((Object)nextWrap).nextWrap;
        }
        return penalty + wrapResult.penalty;
    }

    private double getPenalty(Token.WrapPolicy policy) {
        return Math.exp(policy.structureDepth) * (double)policy.penaltyMultiplier;
    }

    boolean checkForceWrap(Token token, int index, int currentIndent) {
        if (!token.isWrappable() || !this.options.wrap_outer_expressions_when_nested || this.getWrapIndent(token) >= currentIndent) {
            return false;
        }
        Token.WrapPolicy lineStartPolicy = this.tm.get(this.tm.findFirstTokenInLine(index, false, true)).getWrapPolicy();
        return lineStartPolicy != null && lineStartPolicy.wrapMode != Token.WrapMode.BLOCK_INDENT;
    }

    private int[] toArray(List<Integer> list) {
        if (list.isEmpty()) {
            return EMPTY_ARRAY;
        }
        int[] result = new int[list.size()];
        int i = 0;
        for (int item : list) {
            result[i++] = item;
        }
        return result;
    }

    int getWrapIndent(Token token) {
        Token.WrapPolicy policy = token.getWrapPolicy();
        if (policy == null) {
            return token.getIndent();
        }
        if (policy == Token.WrapPolicy.FORCE_FIRST_COLUMN) {
            return 0;
        }
        Token wrapParent = this.tm.get(policy.wrapParentIndex);
        int wrapIndent = wrapParent.getIndent();
        if (policy.indentOnColumn) {
            wrapIndent = this.tm.getPositionInLine(policy.wrapParentIndex);
            wrapIndent += this.tm.getLength(wrapParent, wrapIndent);
            Token next = this.tm.get(policy.wrapParentIndex + 1);
            if (wrapParent.isSpaceAfter() || next.isSpaceBefore() && !next.isComment()) {
                ++wrapIndent;
            }
        }
        return this.tm.toIndent(wrapIndent += policy.extraIndent, true);
    }

    void setIndent(Token token, int indent) {
        token.setIndent(indent);
        List<Token> structure = token.getInternalStructure();
        if (token.tokenType == 48 && structure != null) {
            int lineIndent;
            int indentOption = this.options.text_block_indentation;
            if (indentOption == 4) {
                lineIndent = 1 * this.options.indentation_size;
            } else if (indentOption == 0) {
                lineIndent = this.options.continuation_indentation * this.options.indentation_size;
            } else if (indentOption == 2) {
                lineIndent = this.tm.toIndent(this.tm.getPositionInLine(this.tm.indexOf(token)), true) - indent;
            } else {
                assert (false);
                lineIndent = 0;
            }
            structure.stream().skip(1L).forEach(t -> t.setIndent(lineIndent));
        }
    }

    private class LineAnalyzer
    extends TokenTraverser {
        private final TokenManager tm2;
        private final CommentWrapExecutor commentWrapper;
        private int lineIndent;
        int firstPotentialWrap;
        int activeTopPriorityWrap;
        int minStructureDepth;
        int extraLines;
        int lineWidthExtent;
        boolean isNextLineWrapped;
        final List<Integer> extraLinesPerComment;
        final List<Integer> topPriorityGroupStarts;
        private int currentTopPriorityGroupEnd;
        private boolean isNLSTagInLine;

        public LineAnalyzer(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
            this.tm2 = WrapExecutor.this.tm;
            this.extraLinesPerComment = new ArrayList<Integer>();
            this.topPriorityGroupStarts = new ArrayList<Integer>();
            this.commentWrapper = new CommentWrapExecutor(tokenManager, options);
        }

        public int analyzeLine(int startIndex, int indent) {
            Token startToken = this.tm2.get(startIndex);
            assert (startToken.getLineBreaksBefore() > 0);
            this.counter = this.tm2.toIndent(indent, startToken.isWrappable());
            this.lineIndent = indent;
            this.firstPotentialWrap = -1;
            this.activeTopPriorityWrap = -1;
            this.minStructureDepth = Integer.MAX_VALUE;
            this.extraLines = 0;
            this.lineWidthExtent = 0;
            this.isNextLineWrapped = false;
            this.extraLinesPerComment.clear();
            this.topPriorityGroupStarts.clear();
            this.currentTopPriorityGroupEnd = -1;
            this.isNLSTagInLine = false;
            int lastIndex = this.tm2.traverse(startIndex, this);
            return lastIndex + (this.isNextLineWrapped ? 1 : 0);
        }

        @Override
        protected boolean token(Token token, int index) {
            WrapExecutor.this.setIndent(token, this.lineIndent);
            if (token.hasNLSTag()) {
                this.isNLSTagInLine = true;
            }
            if (token.isWrappable()) {
                Token.WrapPolicy wrapPolicy = token.getWrapPolicy();
                if (wrapPolicy.wrapMode == Token.WrapMode.TOP_PRIORITY && this.getLineBreaksBefore() == 0 && index > this.currentTopPriorityGroupEnd) {
                    if (this.isActiveTopPriorityWrap(index, wrapPolicy)) {
                        this.activeTopPriorityWrap = index;
                    } else {
                        this.topPriorityGroupStarts.add(index);
                        this.currentTopPriorityGroupEnd = wrapPolicy.groupEndIndex;
                    }
                    if (this.firstPotentialWrap < 0) {
                        this.firstPotentialWrap = index;
                    }
                } else if (this.firstPotentialWrap < 0 && WrapExecutor.this.getWrapIndent(token) < this.counter) {
                    this.firstPotentialWrap = index;
                }
                this.minStructureDepth = Math.min(this.minStructureDepth, wrapPolicy.structureDepth);
            }
            if (token.getAlign() > 0) {
                this.counter = token.getAlign();
            } else if (this.isSpaceBefore() && this.getLineBreaksBefore() == 0 && index > 0 && token.tokenType != 1001) {
                ++this.counter;
            }
            if (token.tokenType == 48) {
                List<Token> lines = token.getInternalStructure();
                if (lines == null) {
                    this.counter = this.tm2.getLength(token, 0);
                } else {
                    this.lineWidthExtent = Math.max(this.lineWidthExtent, this.counter + this.tm2.getLength(lines.get(0), this.counter));
                    this.counter = this.lineIndent + lines.get(1).getIndent();
                    lines.stream().skip(1L).forEach(e -> {
                        int n = this.lineWidthExtent = Math.max(this.lineWidthExtent, this.counter + this.tm2.getLength((Token)e, this.counter));
                    });
                    this.counter += this.tm2.getLength(lines.get(lines.size() - 1), this.counter);
                }
            } else if (!token.isComment()) {
                this.counter += this.tm2.getLength(token, this.counter);
            } else if (token.tokenType != 1001) {
                this.counter = this.commentWrapper.wrapMultiLineComment(token, this.counter, true, this.isNLSTagInLine);
                this.extraLines += this.commentWrapper.getLinesCount() - 1;
                this.extraLinesPerComment.add(this.commentWrapper.getLinesCount() - 1);
            }
            this.lineWidthExtent = Math.max(this.lineWidthExtent, this.counter);
            if (this.lineWidthExtent > WrapExecutor.this.options.page_width && this.firstPotentialWrap >= 0) {
                return false;
            }
            if (this.getNext() != null && this.getNext().isWrappable() && this.getLineBreaksAfter() > 0) {
                this.isNextLineWrapped = true;
                if (this.firstPotentialWrap < 0) {
                    this.firstPotentialWrap = index + 1;
                }
                return false;
            }
            boolean isLineEnd = this.getLineBreaksAfter() > 0 || this.getNext() == null || this.getNext().isNextLineOnWrap() && this.tm2.get(this.tm2.findFirstTokenInLine(index)).isWrappable();
            return !isLineEnd;
        }

        private boolean isActiveTopPriorityWrap(int index, Token.WrapPolicy wrapPolicy) {
            if (this.activeTopPriorityWrap >= 0) {
                return false;
            }
            int i = index - 1;
            while (i > wrapPolicy.wrapParentIndex) {
                Token token = this.tm2.get(i);
                if (token.isWrappable() && token.getWrapPolicy().wrapParentIndex == wrapPolicy.wrapParentIndex && (token.getLineBreaksBefore() > 0 || this.tm2.get(i - 1).getLineBreaksAfter() > 0)) {
                    return true;
                }
                --i;
            }
            return false;
        }
    }

    private class NLSTagHandler
    extends TokenTraverser {
        private final ArrayList<Token> nlsTags = new ArrayList();

        @Override
        protected boolean token(Token token, int index) {
            if (token.hasNLSTag()) {
                this.nlsTags.add(token.getNLSTag());
            }
            if (this.getLineBreaksAfter() > 0 || this.getNext() == null) {
                Token lineComment = token;
                if (token.tokenType != 1001) {
                    if (this.nlsTags.isEmpty()) {
                        return true;
                    }
                    lineComment = new Token(token.originalEnd + 1, token.originalEnd + 1, 1001);
                    lineComment.breakAfter();
                    lineComment.spaceBefore();
                    lineComment.setAlign(WrapExecutor.this.tm.getNLSAlign(index));
                    lineComment.setInternalStructure(new ArrayList<Token>());
                    WrapExecutor.this.tm.insert(index + 1, lineComment);
                    this.structureChanged();
                    return true;
                }
                List<Token> structure = lineComment.getInternalStructure();
                if (structure == null) {
                    if (this.nlsTags.isEmpty()) {
                        return true;
                    }
                    structure = new ArrayList<Token>();
                    structure.add(lineComment);
                    lineComment.setInternalStructure(structure);
                }
                boolean isPrefixMissing = false;
                int i = 0;
                while (i < structure.size()) {
                    Token fragment = structure.get(i);
                    if (fragment.hasNLSTag()) {
                        if (!this.nlsTags.remove(fragment)) {
                            if (i == 0) {
                                isPrefixMissing = true;
                            }
                            structure.remove(i--);
                        } else {
                            isPrefixMissing = false;
                        }
                    } else if (isPrefixMissing) {
                        int pos = fragment.originalStart;
                        while (pos <= fragment.originalEnd && ScannerHelper.isWhitespace((char)WrapExecutor.this.tm.charAt(pos))) {
                            ++pos;
                        }
                        if (pos > fragment.originalEnd) {
                            structure.remove(i--);
                        } else {
                            String fragmentString;
                            if (pos > fragment.originalStart) {
                                fragment = new Token(pos, fragment.originalEnd, 1001);
                                structure.set(i, fragment);
                            }
                            if (!(fragmentString = WrapExecutor.this.tm.toString(fragment)).startsWith("//")) {
                                Token prefix = new Token(lineComment.originalStart, lineComment.originalStart + 1, 1001);
                                prefix.spaceBefore();
                                structure.add(i, prefix);
                            }
                            isPrefixMissing = false;
                        }
                    }
                    ++i;
                }
                structure.addAll(this.nlsTags);
                if (structure.isEmpty() || structure.size() == 1 && structure.get((int)0).tokenType == 1000) {
                    WrapExecutor.this.tm.remove(index);
                    this.structureChanged();
                }
                this.nlsTags.clear();
            }
            return true;
        }
    }

    private static class WrapInfo {
        public int wrapTokenIndex;
        public int indent;

        public WrapInfo(int wrapIndex, int indent) {
            this.wrapTokenIndex = wrapIndex;
            this.indent = indent;
        }

        public WrapInfo() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.indent;
            result = 31 * result + this.wrapTokenIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrapInfo other = (WrapInfo)obj;
            if (this.indent != other.indent) {
                return false;
            }
            return this.wrapTokenIndex == other.wrapTokenIndex;
        }
    }

    private static class WrapResult {
        public static final WrapResult NO_WRAP_NEEDED = new WrapResult(0.0, 0, null);
        public final double penalty;
        public final int extraPenalty;
        public final WrapInfo nextWrap;

        WrapResult(double penalty, int extraPenalty, WrapInfo nextWrap) {
            this.penalty = penalty;
            this.extraPenalty = extraPenalty;
            this.nextWrap = nextWrap;
        }
    }

    private class WrapsApplier
    extends TokenTraverser {
        private final TokenManager tm2;
        private ArrayDeque<Token> stack;
        private int initialIndent;
        private int currentIndent;
        private WrapInfo nextWrap;

        public WrapsApplier() {
            this.tm2 = WrapExecutor.this.tm;
            this.stack = new ArrayDeque();
        }

        @Override
        protected boolean token(Token token, int index) {
            if (index == 0 || this.getLineBreaksBefore() > 0) {
                this.newLine(token, index);
            } else if (this.nextWrap != null && index == this.nextWrap.wrapTokenIndex || WrapExecutor.this.checkForceWrap(token, index, this.currentIndent) || token.isNextLineOnWrap() && this.tm2.get(this.tm2.findFirstTokenInLine(index)).isWrappable()) {
                token.breakBefore();
                this.newLine(token, index);
            } else {
                this.checkOnColumnAlign(token, index);
                WrapExecutor.this.setIndent(token, this.currentIndent);
            }
            return true;
        }

        private void checkOnColumnAlign(Token token, int index) {
            Token.WrapPolicy wrapPolicy = token.getWrapPolicy();
            if (wrapPolicy == null || !wrapPolicy.indentOnColumn || !wrapPolicy.isFirstInGroup) {
                return;
            }
            int positionInLine = this.tm2.getPositionInLine(index);
            if (this.tm2.toIndent(positionInLine, true) == positionInLine) {
                return;
            }
            Predicate<Token> aligner = t -> {
                Token.WrapPolicy wp = t.getWrapPolicy();
                if (wp != null && wp.indentOnColumn && wp.wrapParentIndex == wrapPolicy.wrapParentIndex) {
                    this.currentIndent = this.tm2.toIndent(positionInLine, true);
                    token.setAlign(this.currentIndent);
                    this.stack.push(token);
                    return true;
                }
                return false;
            };
            WrapInfo furtherWrap = this.nextWrap;
            while (furtherWrap != null) {
                if (aligner.test(this.tm2.get(furtherWrap.wrapTokenIndex))) {
                    return;
                }
                furtherWrap = WrapExecutor.this.wrapSearchResults.get((Object)furtherWrap).nextWrap;
            }
            int i = index;
            while (i <= wrapPolicy.groupEndIndex) {
                Token t2 = this.tm2.get(i);
                if (t2.getLineBreaksBefore() > 0 && aligner.test(t2)) {
                    return;
                }
                ++i;
            }
        }

        private void newLine(Token token, int index) {
            while (!this.stack.isEmpty() && index > this.stack.peek().getWrapPolicy().groupEndIndex) {
                this.stack.pop();
            }
            if (token.getWrapPolicy() != null) {
                WrapExecutor.this.setIndent(token, WrapExecutor.this.getWrapIndent(token));
                this.stack.push(token);
            } else if (this.stack.isEmpty()) {
                this.initialIndent = token.getIndent();
                WrapExecutor.this.wrapSearchResults.clear();
            }
            this.currentIndent = this.stack.isEmpty() ? this.initialIndent : this.stack.peek().getIndent();
            WrapExecutor.this.setIndent(token, this.currentIndent);
            this.nextWrap = WrapExecutor.this.findWrapsCached((int)index, (int)this.currentIndent).nextWrap;
        }
    }
}

