/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.Scanner;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.ScannerHelper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Messages;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class JavaConventions {
    private static final Pattern DOT_DOT = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern PREFIX_JAVA = Pattern.compile("java$");
    private static final Scanner SCANNER = new Scanner(false, true, false, 0x2F0000L, null, null, true);
    private static Map<String, Set<String>> restrictedIdentifiersMap;
    private static Map<String, Set<String>> restrictedIdentifierPreviewMap;
    private static List<String> javaVersions;
    private static String VAR_ID;
    private static String YIELD_ID;
    private static String RECORD_ID;

    static {
        VAR_ID = "var";
        YIELD_ID = "yield";
        RECORD_ID = "record";
        javaVersions = new ArrayList<String>();
        javaVersions.add(0, "10");
        javaVersions.add(1, "11");
        javaVersions.add(2, "12");
        javaVersions.add(3, "13");
        javaVersions.add(4, "14");
        restrictedIdentifiersMap = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        set.add(new String(VAR_ID));
        restrictedIdentifiersMap.put("10", set);
        set = new HashSet();
        set.add(new String(YIELD_ID));
        restrictedIdentifiersMap.put("14", set);
        restrictedIdentifierPreviewMap = new HashMap<String, Set<String>>();
        set = new HashSet();
        set.add(new String(RECORD_ID));
        restrictedIdentifierPreviewMap.put("14", set);
    }

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel) {
        return JavaConventions.scannedIdentifier(id, sourceLevel, complianceLevel, null, true);
    }

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel, String previewEnabled, boolean allowRestrictedKeyWords) {
        block7: {
            if (id == null) {
                return null;
            }
            JavaConventions.SCANNER.sourceLevel = sourceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(sourceLevel);
            JavaConventions.SCANNER.complianceLevel = complianceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(complianceLevel);
            JavaConventions.SCANNER.previewEnabled = previewEnabled == null ? false : "enabled".equals(previewEnabled);
            try {
                SCANNER.setSource(id.toCharArray());
                int token = SCANNER.scanIdentifier();
                if (token == 19) break block7;
                return null;
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (JavaConventions.SCANNER.currentPosition == JavaConventions.SCANNER.eofPosition) {
            try {
                char[] src = SCANNER.getCurrentIdentifierSource();
                src = JavaConventions.scanForRestrictedKeyWords(src, sourceLevel, complianceLevel, JavaConventions.SCANNER.previewEnabled, allowRestrictedKeyWords);
                return src;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    private static char[] scanForRestrictedKeyWords(char[] id, String sourceLevel, String complianceLevel, boolean previewEnabled, boolean allowRestrictedKeyWords) {
        if (allowRestrictedKeyWords) {
            return id;
        }
        int index = javaVersions.indexOf(sourceLevel);
        String searchId = new String(id);
        int i = index;
        while (i >= 0) {
            String level = javaVersions.get(i);
            if (level != null) {
                Set<String> prIds;
                Set<String> rIds = restrictedIdentifiersMap.get(level);
                if (rIds != null && rIds.contains(searchId)) {
                    return null;
                }
                if (previewEnabled && (prIds = restrictedIdentifierPreviewMap.get(level)) != null && prIds.contains(searchId)) {
                    return null;
                }
            }
            --i;
        }
        return id;
    }

    public static IStatus validateCompilationUnitName(String name, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name == null) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!Util.isJavaLikeFileName(name)) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_unit_notJavaName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_unit_notJavaName, null);
        }
        String identifier = name.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name == null) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_classFile_nullName, null);
        }
        if (!io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util.isClassFileName(name)) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        String identifier = name.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateIdentifier(String id, String sourceLevel, String complianceLevel) {
        if (JavaConventions.scannedIdentifier(id, sourceLevel, complianceLevel) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.bind(Messages.convention_illegalIdentifier, id), null);
    }

    public static IStatus validateImportDeclaration(String name, String sourceLevel, String complianceLevel) {
        if (name == null || name.length() == 0) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_import_nullImport, null);
        }
        if (name.charAt(name.length() - 1) == '*') {
            if (name.charAt(name.length() - 2) == '.') {
                return JavaConventions.validatePackageName(name.substring(0, name.length() - 2), sourceLevel, complianceLevel);
            }
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_import_unqualifiedImport, null);
        }
        return JavaConventions.validatePackageName(name, sourceLevel, complianceLevel);
    }

    public static IStatus validatePackageName(String name, String sourceLevel, String complianceLevel) {
        if (name == null) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_nullName, null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_emptyName, null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_dotName, null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_nameWithBlanks, null);
        }
        if (DOT_DOT.matcher(name).find()) {
            return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_consecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, ".");
        boolean firstToken = true;
        Status warningStatus = null;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(typeName = typeName.trim(), sourceLevel, complianceLevel);
            if (scannedID == null) {
                return new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.bind(Messages.convention_illegalIdentifier, typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && ScannerHelper.isUpperCase(scannedID[0]) && warningStatus == null) {
                warningStatus = new Status(2, "io.spring.javaformat.eclipse.jdt.jdk11.core", -1, Messages.convention_package_uppercaseName, null);
            }
            firstToken = false;
        }
        if (warningStatus != null) {
            return warningStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

