/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.DefaultBindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IAnnotationBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IMemberValuePairBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ITypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MemberValuePairBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ElementValuePair;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ReferenceBinding;

class AnnotationBinding
implements IAnnotationBinding {
    static final AnnotationBinding[] NoAnnotations = new AnnotationBinding[0];
    private io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.AnnotationBinding binding;
    private BindingResolver bindingResolver;
    private String key;

    AnnotationBinding(io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.AnnotationBinding annotation, BindingResolver resolver) {
        if (annotation == null) {
            throw new IllegalStateException();
        }
        this.binding = annotation;
        this.bindingResolver = resolver;
    }

    public ITypeBinding getAnnotationType() {
        ITypeBinding typeBinding = this.bindingResolver.getTypeBinding(this.binding.getAnnotationType());
        if (typeBinding == null) {
            return null;
        }
        return typeBinding;
    }

    public IMemberValuePairBinding[] getDeclaredMemberValuePairs() {
        ReferenceBinding typeBinding = this.binding.getAnnotationType();
        if (typeBinding == null || (typeBinding.tagBits & 0x80L) != 0L) {
            return MemberValuePairBinding.NoPair;
        }
        ElementValuePair[] internalPairs = this.binding.getElementValuePairs();
        int length = internalPairs.length;
        IMemberValuePairBinding[] pairs = length == 0 ? MemberValuePairBinding.NoPair : new MemberValuePairBinding[length];
        int counter = 0;
        int i = 0;
        while (i < length) {
            ElementValuePair valuePair = internalPairs[i];
            if (valuePair.binding != null) {
                pairs[counter++] = this.bindingResolver.getMemberValuePairBinding(valuePair);
            }
            ++i;
        }
        if (counter == 0) {
            return MemberValuePairBinding.NoPair;
        }
        if (counter != length) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray = pairs;
            pairs = new MemberValuePairBinding[counter];
            System.arraycopy(iMemberValuePairBindingArray, 0, pairs, 0, counter);
        }
        return pairs;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            String recipientKey = this.getRecipientKey();
            this.key = new String(this.binding.computeUniqueKey(recipientKey.toCharArray()));
        }
        return this.key;
    }

    private String getRecipientKey() {
        if (!(this.bindingResolver instanceof DefaultBindingResolver)) {
            return "";
        }
        DefaultBindingResolver resolver = (DefaultBindingResolver)this.bindingResolver;
        ASTNode node = (ASTNode)resolver.bindingsToAstNodes.get(this);
        if (node == null) {
            return "";
        }
        ASTNode recipient = node.getParent();
        switch (recipient.getNodeType()) {
            case 35: {
                String pkgName = ((PackageDeclaration)recipient).getName().getFullyQualifiedName();
                return pkgName.replace('.', '/');
            }
            case 55: {
                return ((TypeDeclaration)recipient).resolveBinding().getKey();
            }
            case 23: {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)((FieldDeclaration)recipient).fragments().get(0);
                return fragment.resolveBinding().getKey();
            }
            case 31: {
                return ((MethodDeclaration)recipient).resolveBinding().getKey();
            }
            case 93: {
                return ((ModuleDeclaration)recipient).resolveBinding().getKey();
            }
            case 60: {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)((VariableDeclarationStatement)recipient).fragments().get(0);
                return fragment.resolveBinding().getKey();
            }
        }
        return "";
    }

    public String toString() {
        ITypeBinding type = this.getAnnotationType();
        StringBuilder buffer = new StringBuilder();
        buffer.append('@');
        if (type != null) {
            buffer.append(type.getName());
        }
        buffer.append('(');
        IMemberValuePairBinding[] pairs = this.getDeclaredMemberValuePairs();
        int i = 0;
        int len = pairs.length;
        while (i < len) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(pairs[i].toString());
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

