/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.Scanner;
import java.util.ArrayList;
import java.util.List;

public class CharacterLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(CharacterLiteral.class, "escapedValue", String.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "'X'";

    static {
        ArrayList properyList = new ArrayList(2);
        CharacterLiteral.createPropertyList(CharacterLiteral.class, properyList);
        CharacterLiteral.addProperty(ESCAPED_VALUE_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = CharacterLiteral.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    CharacterLiteral(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return CharacterLiteral.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 13;
    }

    @Override
    ASTNode clone0(AST target) {
        CharacterLiteral result = new CharacterLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] source = value.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 59: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = value;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String value) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = value;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    @Override
    int memSize() {
        int size = 44 + CharacterLiteral.stringSize(this.escapedValue);
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

