/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CategorizedProblem;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTConverter;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.DefaultBindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NameEnvironmentWithProgress;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NodeSearcher;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.CompilationResult;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.Compiler;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.DefaultErrorHandlingPolicies;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ICompilerRequestor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.IErrorHandlingPolicy;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.IProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.AbstractMethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.CompilationUnitDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.Initializer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch.FileSystem;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.AccessRestriction;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.INameEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ISourceType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.PackageBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.problem.AbortCompilation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.problem.DefaultProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.problem.ProblemReporter;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.HashtableOfObject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CancelableNameEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CancelableProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.INameEnvironmentWithProgress;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.NameLookup;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceTypeElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.CommentRecorderParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class CompilationUnitResolver
extends Compiler {
    HashtableOfObject requestedSources;
    HashtableOfObject requestedKeys;
    boolean hasCompilationAborted = false;
    CategorizedProblem abortProblem;
    private IProgressMonitor monitor;
    boolean fromJavaProject;

    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory, IProgressMonitor monitor, boolean fromJavaProject) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
        this.monitor = monitor;
        this.fromJavaProject = fromJavaProject;
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SourceTypeElementInfo sourceType = (SourceTypeElementInfo)sourceTypes[0];
        this.accept((ICompilationUnit)((Object)sourceType.getHandle().getCompilationUnit()), accessRestriction);
    }

    @Override
    public synchronized void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        super.accept(sourceUnit, accessRestriction);
    }

    public static CompilationUnit convert(CompilationUnitDeclaration compilationUnitDeclaration, char[] source, int apiLevel, Map options, boolean needToResolveBindings, WorkingCopyOwner owner, DefaultBindingResolver.BindingTables bindingTables, int flags, IProgressMonitor monitor, boolean fromJavaProject, IJavaProject project) {
        BindingResolver resolver = null;
        AST ast = AST.newAST(apiLevel, "enabled".equals(options.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enablePreviewFeatures")));
        String sourceModeSetting = (String)options.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source");
        long sourceLevel = CompilerOptions.versionToJdkLevel(sourceModeSetting);
        if (sourceLevel == 0L) {
            sourceLevel = 0x2F0000L;
        }
        ast.scanner.sourceLevel = sourceLevel;
        String compliance = (String)options.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance");
        long complianceLevel = CompilerOptions.versionToJdkLevel(compliance);
        if (complianceLevel == 0L) {
            complianceLevel = sourceLevel;
        }
        ast.scanner.complianceLevel = complianceLevel;
        ast.setDefaultNodeFlag(2);
        CompilationUnit compilationUnit = null;
        ASTConverter converter = new ASTConverter(options, needToResolveBindings, monitor);
        if (needToResolveBindings) {
            resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope, owner, bindingTables, (flags & 4) != 0, fromJavaProject);
            ast.setFlag(flags | Integer.MIN_VALUE);
        } else {
            resolver = new BindingResolver();
            ast.setFlag(flags);
        }
        ast.setBindingResolver(resolver);
        converter.setAST(ast);
        converter.docParser.setProjectPath(CompilationUnitResolver.getProjectPath(project));
        converter.docParser.setProjectSrcClasspath(CompilationUnitResolver.getSourceClassPaths(project));
        compilationUnit = converter.convert(compilationUnitDeclaration, source);
        compilationUnit.setLineEndTable(compilationUnitDeclaration.compilationResult.getLineSeparatorPositions());
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return compilationUnit;
    }

    private static String getProjectPath(IJavaProject project) {
        if (project == null) {
            return null;
        }
        IProject rp = project.getProject();
        if (rp == null) {
            return null;
        }
        IPath location = rp.getLocation();
        if (location == null) {
            return null;
        }
        return location.toOSString();
    }

    private static ArrayList<String> getSourceClassPaths(IJavaProject project) {
        ArrayList<String> srcClassPath = new ArrayList<String>();
        if (project == null) {
            return srcClassPath;
        }
        if (project.getProject() == null) {
            return srcClassPath;
        }
        IClasspathEntry[] resolvedClasspath = null;
        try {
            resolvedClasspath = project.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {}
        if (resolvedClasspath == null) {
            return srcClassPath;
        }
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry instanceof ClasspathEntry) {
                IPath path = ((ClasspathEntry)entry).getPath();
                srcClassPath.add(path.removeFirstSegments(1).toString());
            }
            ++n2;
        }
        return srcClassPath;
    }

    protected static CompilerOptions getCompilerOptions(Map options, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        compilerOptions.storeAnnotations = true;
        compilerOptions.ignoreSourceFolderWarningOption = true;
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    @Override
    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, false);
    }

    @Override
    public void process(CompilationUnitDeclaration unit, int i) {
        char[] fileName = unit.compilationResult.getFileName();
        if (this.requestedKeys.get(fileName) == null && this.requestedSources.get(fileName) == null) {
            super.process(unit, i);
        }
    }

    @Override
    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        super.handleInternalException(internalException, unit, result);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    @Override
    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        super.handleInternalException(abortException, unit);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
        this.hasCompilationAborted = true;
        this.abortProblem = abortException.problem;
    }

    public static CompilationUnitDeclaration parse(ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, Map settings, int flags) {
        return CompilationUnitResolver.parse(sourceUnit, nodeSearcher, settings, flags, null);
    }

    public static CompilationUnitDeclaration parse(ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, Map settings, int flags, IJavaProject project) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        block9: {
            CommentRecorderParser parser;
            block7: {
                ASTNode node;
                block10: {
                    TypeDeclaration enclosingTypeDeclaration;
                    block8: {
                        boolean statementsRecovery;
                        if (sourceUnit == null) {
                            throw new IllegalStateException();
                        }
                        CompilerOptions compilerOptions = new CompilerOptions(settings);
                        compilerOptions.performMethodsFullRecovery = statementsRecovery = (flags & 2) != 0;
                        compilerOptions.performStatementsRecovery = statementsRecovery;
                        compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
                        parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()), false);
                        if (project != null) {
                            parser.javadocParser.setProjectPath(CompilationUnitResolver.getProjectPath(project));
                            parser.javadocParser.setProjectSrcClasspath(CompilationUnitResolver.getSourceClassPaths(project));
                        }
                        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                        compilationUnitDeclaration = parser.dietParse(sourceUnit, compilationResult);
                        if (compilationUnitDeclaration.ignoreMethodBodies) {
                            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
                            return compilationUnitDeclaration;
                        }
                        if (nodeSearcher == null) break block7;
                        char[] source = parser.scanner.getSource();
                        int searchPosition = nodeSearcher.position;
                        if (searchPosition < 0 || searchPosition > source.length) {
                            return compilationUnitDeclaration;
                        }
                        compilationUnitDeclaration.traverse((ASTVisitor)nodeSearcher, compilationUnitDeclaration.scope);
                        node = nodeSearcher.found;
                        if (node == null) {
                            return compilationUnitDeclaration;
                        }
                        enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (!(node instanceof AbstractMethodDeclaration)) break block8;
                        ((AbstractMethodDeclaration)node).parseStatements(parser, compilationUnitDeclaration);
                        break block9;
                    }
                    if (enclosingTypeDeclaration == null) break block9;
                    if (!(node instanceof Initializer)) break block10;
                    ((Initializer)node).parseStatements(parser, enclosingTypeDeclaration, compilationUnitDeclaration);
                    break block9;
                }
                if (!(node instanceof TypeDeclaration)) break block9;
                ((TypeDeclaration)node).parseMethods(parser, compilationUnitDeclaration);
                break block9;
            }
            TypeDeclaration[] types = compilationUnitDeclaration.types;
            if (types != null) {
                int j = 0;
                int typeLength = types.length;
                while (j < typeLength) {
                    types[j].parseMethods(parser, compilationUnitDeclaration);
                    ++j;
                }
            }
        }
        return compilationUnitDeclaration;
    }

    public static CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, IJavaProject javaProject, List classpaths, NodeSearcher nodeSearcher, Map options, WorkingCopyOwner owner, int flags, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitDeclaration unit = null;
        INameEnvironmentWithProgress environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitResolver resolver = null;
        try {
            boolean ignoreMethodBodies;
            if (javaProject == null) {
                FileSystem.Classpath[] allEntries = new FileSystem.Classpath[classpaths.size()];
                classpaths.toArray(allEntries);
                environment = new NameEnvironmentWithProgress(allEntries, null, monitor);
            } else {
                environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, monitor);
            }
            problemFactory = new CancelableProblemFactory(monitor);
            CompilerOptions compilerOptions = CompilationUnitResolver.getCompilerOptions(options, (flags & 2) != 0);
            compilerOptions.ignoreMethodBodies = ignoreMethodBodies = (flags & 8) != 0;
            resolver = new CompilationUnitResolver((INameEnvironment)environment, CompilationUnitResolver.getHandlingPolicy(), compilerOptions, CompilationUnitResolver.getRequestor(), (IProblemFactory)problemFactory, monitor, javaProject != null);
            boolean analyzeAndGenerateCode = !ignoreMethodBodies;
            unit = resolver.resolve(null, sourceUnit, nodeSearcher, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
            if (resolver.hasCompilationAborted) {
                CompilationUnitDeclaration unitDeclaration = CompilationUnitResolver.parse(sourceUnit, nodeSearcher, options, flags);
                if (unit != null) {
                    int problemCount = unit.compilationResult.problemCount;
                    if (problemCount != 0) {
                        unitDeclaration.compilationResult.problems = new CategorizedProblem[problemCount];
                        System.arraycopy(unit.compilationResult.problems, 0, unitDeclaration.compilationResult.problems, 0, problemCount);
                        unitDeclaration.compilationResult.problemCount = problemCount;
                    }
                } else if (resolver.abortProblem != null) {
                    unitDeclaration.compilationResult.problemCount = 1;
                    unitDeclaration.compilationResult.problems = new CategorizedProblem[]{resolver.abortProblem};
                }
                CompilationUnitDeclaration compilationUnitDeclaration = unitDeclaration;
                return compilationUnitDeclaration;
            }
            if (NameLookup.VERBOSE && environment instanceof CancelableNameEnvironment) {
                CancelableNameEnvironment cancelableNameEnvironment = (CancelableNameEnvironment)environment;
                cancelableNameEnvironment.printTimeSpent();
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit;
            return compilationUnitDeclaration;
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
        }
    }

    public void removeUnresolvedBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = 0;
            int max = types.length;
            while (i < max) {
                this.removeUnresolvedBindings(types[i]);
                ++i;
            }
        }
    }

    private void removeUnresolvedBindings(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int max = memberTypes.length;
            while (i < max) {
                this.removeUnresolvedBindings(memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null && (type.binding.modifiers & 0x2000000) != 0) {
            type.binding = null;
        }
        if ((fields = type.fields) != null) {
            int i = 0;
            int max = fields.length;
            while (i < max) {
                if (fields[i].binding != null && (fields[i].binding.modifiers & 0x2000000) != 0) {
                    fields[i].binding = null;
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            int max = methods.length;
            while (i < max) {
                if (methods[i].binding != null && (methods[i].binding.modifiers & 0x2000000) != 0) {
                    methods[i].binding = null;
                }
                ++i;
            }
        }
    }

    private CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{sourceUnit});
                int i = 0;
                int max = this.totalUnits;
                while (i < max) {
                    CompilationUnitDeclaration currentCompilationUnitDeclaration = this.unitsToProcess[i];
                    if (currentCompilationUnitDeclaration != null && currentCompilationUnitDeclaration.compilationResult.compilationUnit == sourceUnit) {
                        unit = currentCompilationUnitDeclaration;
                        break;
                    }
                    ++i;
                }
                if (unit == null) {
                    unit = this.unitsToProcess[0];
                }
            } else {
                this.lookupEnvironment.buildTypeBindings(unit, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            if (nodeSearcher == null) {
                this.parser.getMethodBodies(unit);
            } else {
                int searchPosition = nodeSearcher.position;
                char[] source = sourceUnit.getContents();
                int length = source.length;
                if (searchPosition >= 0 && searchPosition <= length) {
                    unit.traverse((ASTVisitor)nodeSearcher, unit.scope);
                    ASTNode node = nodeSearcher.found;
                    if (node != null) {
                        int[] oldLineEnds = this.parser.scanner.lineEnds;
                        int oldLinePtr = this.parser.scanner.linePtr;
                        this.parser.scanner.setSource(source, unit.compilationResult);
                        TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (node instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)node).parseStatements(this.parser, unit);
                        } else if (enclosingTypeDeclaration != null) {
                            if (node instanceof Initializer) {
                                ((Initializer)node).parseStatements(this.parser, enclosingTypeDeclaration, unit);
                            } else if (node instanceof TypeDeclaration) {
                                ((TypeDeclaration)node).parseMethods(this.parser, unit);
                            }
                        }
                        this.parser.scanner.lineEnds = oldLineEnds;
                        this.parser.scanner.linePtr = oldLinePtr;
                    }
                }
            }
            if (unit.scope != null) {
                CompilationUnitDeclaration previousUnit = this.lookupEnvironment.unitBeingCompleted;
                this.lookupEnvironment.unitBeingCompleted = unit;
                try {
                    unit.scope.faultInTypes();
                    if (unit.scope != null && verifyMethods) {
                        unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                    }
                    unit.resolve();
                    if (analyzeCode) {
                        unit.analyseCode();
                    }
                    if (generateCode) {
                        unit.generateCode();
                    }
                    unit.finalizeProblems();
                }
                finally {
                    this.lookupEnvironment.unitBeingCompleted = previousUnit;
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error | RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    @Override
    public CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    @Override
    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(unit, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }
}

