/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EmptyStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Statement;
import java.util.ArrayList;
import java.util.List;

public class LabeledStatement
extends Statement {
    public static final ChildPropertyDescriptor LABEL_PROPERTY = new ChildPropertyDescriptor(LabeledStatement.class, "label", SimpleName.class, true, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(LabeledStatement.class, "body", Statement.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private SimpleName labelName = null;
    private Statement body = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        LabeledStatement.createPropertyList(LabeledStatement.class, propertyList);
        LabeledStatement.addProperty(LABEL_PROPERTY, propertyList);
        LabeledStatement.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = LabeledStatement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    LabeledStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return LabeledStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LABEL_PROPERTY) {
            if (get) {
                return this.getLabel();
            }
            this.setLabel((SimpleName)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 30;
    }

    @Override
    ASTNode clone0(AST target) {
        LabeledStatement result = new LabeledStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setLabel((SimpleName)ASTNode.copySubtree(target, this.getLabel()));
        result.setBody((Statement)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLabel());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getLabel() {
        if (this.labelName == null) {
            LabeledStatement labeledStatement = this;
            synchronized (labeledStatement) {
                if (this.labelName == null) {
                    this.preLazyInit();
                    this.labelName = new SimpleName(this.ast);
                    this.postLazyInit(this.labelName, LABEL_PROPERTY);
                }
            }
        }
        return this.labelName;
    }

    public void setLabel(SimpleName label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.labelName;
        this.preReplaceChild(oldChild, label, LABEL_PROPERTY);
        this.labelName = label;
        this.postReplaceChild(oldChild, label, LABEL_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getBody() {
        if (this.body == null) {
            LabeledStatement labeledStatement = this;
            synchronized (labeledStatement) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new EmptyStatement(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, statement, BODY_PROPERTY);
        this.body = statement;
        this.postReplaceChild(oldChild, statement, BODY_PROPERTY);
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.labelName == null ? 0 : this.getLabel().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

