/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IMemberValuePairBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IMethodBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ITypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.Constant;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.AnnotationBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ElementValuePair;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.FieldBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding;

class MemberValuePairBinding
implements IMemberValuePairBinding {
    static final MemberValuePairBinding[] NoPair = new MemberValuePairBinding[0];
    private static final Object NoValue = new Object();
    private static final Object[] EmptyArray = new Object[0];
    private ElementValuePair internalPair;
    protected Object value = null;
    protected BindingResolver bindingResolver;

    static void appendValue(Object value, StringBuffer buffer) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buffer.append('{');
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (i != 0) {
                    buffer.append(", ");
                }
                MemberValuePairBinding.appendValue(values[i], buffer);
                ++i;
            }
            buffer.append('}');
        } else if (value instanceof ITypeBinding) {
            buffer.append(((ITypeBinding)value).getName());
            buffer.append(".class");
        } else {
            buffer.append(value);
        }
    }

    static Object buildDOMValue(Object internalObject, BindingResolver resolver) {
        if (internalObject == null) {
            return null;
        }
        if (internalObject instanceof Constant) {
            Constant constant = (Constant)internalObject;
            switch (constant.typeID()) {
                case 5: {
                    return constant.booleanValue();
                }
                case 3: {
                    return constant.byteValue();
                }
                case 2: {
                    return Character.valueOf(constant.charValue());
                }
                case 8: {
                    return constant.doubleValue();
                }
                case 9: {
                    return Float.valueOf(constant.floatValue());
                }
                case 10: {
                    return constant.intValue();
                }
                case 7: {
                    return constant.longValue();
                }
                case 4: {
                    return constant.shortValue();
                }
            }
            return constant.stringValue();
        }
        if (internalObject instanceof TypeBinding) {
            return resolver.getTypeBinding((TypeBinding)internalObject);
        }
        if (internalObject instanceof AnnotationBinding) {
            return resolver.getAnnotationInstance((AnnotationBinding)internalObject);
        }
        if (internalObject instanceof FieldBinding) {
            return resolver.getVariableBinding((FieldBinding)internalObject);
        }
        if (internalObject instanceof Object[]) {
            Object[] elements = (Object[])internalObject;
            int length = elements.length;
            Object[] values = length == 0 ? EmptyArray : new Object[length];
            int i = 0;
            while (i < length) {
                values[i] = MemberValuePairBinding.buildDOMValue(elements[i], resolver);
                ++i;
            }
            return values;
        }
        return null;
    }

    MemberValuePairBinding(ElementValuePair pair, BindingResolver resolver) {
        this.internalPair = pair;
        this.bindingResolver = resolver;
    }

    @Override
    public String getKey() {
        return null;
    }

    public IMethodBinding getMethodBinding() {
        return this.bindingResolver.getMethodBinding(this.internalPair.getMethodBinding());
    }

    public String getName() {
        if (this.internalPair == null) {
            return null;
        }
        char[] membername = this.internalPair.getName();
        return membername == null ? null : new String(membername);
    }

    public Object getValue() {
        if (this.value == null) {
            this.init();
        }
        return this.value == NoValue ? null : this.value;
    }

    private void init() {
        IMethodBinding methodBinding;
        this.value = MemberValuePairBinding.buildDOMValue(this.internalPair.getValue(), this.bindingResolver);
        if (this.value == null) {
            this.value = NoValue;
        }
        if ((methodBinding = this.getMethodBinding()).getReturnType().isArray() && !this.value.getClass().isArray()) {
            this.value = new Object[]{this.value};
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(" = ");
        MemberValuePairBinding.appendValue(this.getValue(), buffer);
        return buffer.toString();
    }
}

