/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ITypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Name;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NameQualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParameterizedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrimitiveType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Type;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ArrayBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ReferenceBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import java.util.List;

class RecoveredTypeBinding
implements ITypeBinding {
    private VariableDeclaration variableDeclaration;
    private Type currentType;
    private BindingResolver resolver;
    private int dimensions;
    private RecoveredTypeBinding innerTypeBinding;
    private ITypeBinding[] typeArguments;
    private io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding binding;

    RecoveredTypeBinding(BindingResolver resolver, VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
        this.resolver = resolver;
        this.currentType = this.getType();
        this.dimensions = variableDeclaration.getExtraDimensions();
        if (this.currentType.isArrayType()) {
            this.dimensions += ((ArrayType)this.currentType).getDimensions();
        }
    }

    RecoveredTypeBinding(BindingResolver resolver, io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding typeBinding) {
        this.resolver = resolver;
        this.dimensions = typeBinding.dimensions();
        this.binding = typeBinding;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        StringBuffer buffer = new StringBuffer(this.getInternalName());
        buffer.append(brackets);
        return String.valueOf(buffer);
    }

    private String getInternalName() {
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getInternalName();
        }
        ReferenceBinding referenceBinding = this.getReferenceBinding();
        if (referenceBinding != null) {
            return new String(referenceBinding.compoundName[referenceBinding.compoundName.length - 1]);
        }
        return this.getTypeNameFrom(this.getType());
    }

    private ReferenceBinding getReferenceBinding() {
        if (this.binding != null) {
            if (this.binding.isArrayType()) {
                ArrayBinding arrayBinding = (ArrayBinding)this.binding;
                if (arrayBinding.leafComponentType instanceof ReferenceBinding) {
                    return (ReferenceBinding)arrayBinding.leafComponentType;
                }
            } else if (this.binding instanceof ReferenceBinding) {
                return (ReferenceBinding)this.binding;
            }
        } else if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getReferenceBinding();
        }
        return null;
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.binding != null) {
            this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
            return TypeBinding.NO_TYPE_BINDINGS;
        }
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getTypeArguments();
        }
        if (this.currentType.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)this.currentType;
            List typeArgumentsList = parameterizedType.typeArguments();
            int size = typeArgumentsList.size();
            ITypeBinding[] temp = new ITypeBinding[size];
            int i = 0;
            while (i < size) {
                ITypeBinding currentTypeBinding = ((Type)typeArgumentsList.get(i)).resolveBinding();
                if (currentTypeBinding == null) {
                    this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
                    return TypeBinding.NO_TYPE_BINDINGS;
                }
                temp[i] = currentTypeBinding;
                ++i;
            }
            this.typeArguments = temp;
            return temp;
        }
        this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isCapture() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Recovered#");
        if (this.innerTypeBinding != null) {
            buffer.append("innerTypeBinding").append(this.innerTypeBinding.getKey());
        } else if (this.currentType != null) {
            buffer.append("currentType").append(this.currentType.toString());
        } else if (this.binding != null) {
            buffer.append("typeBinding").append(this.binding.computeUniqueKey());
        } else if (this.variableDeclaration != null) {
            buffer.append("variableDeclaration").append(this.variableDeclaration.getClass()).append(this.variableDeclaration.getName().getIdentifier()).append(this.variableDeclaration.getExtraDimensions());
        }
        buffer.append(this.getDimensions());
        if (this.typeArguments != null) {
            buffer.append('<');
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(this.typeArguments[i].getKey());
                ++i;
            }
            buffer.append('>');
        }
        return String.valueOf(buffer);
    }

    private String getTypeNameFrom(Type type) {
        if (type == null) {
            return Util.EMPTY_STRING;
        }
        switch (type.getNodeType0()) {
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                type = arrayType.getElementType();
                return this.getTypeNameFrom(type);
            }
            case 74: {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                StringBuffer buffer = new StringBuffer(this.getTypeNameFrom(parameterizedType.getType()));
                ITypeBinding[] tArguments = this.getTypeArguments();
                int typeArgumentsLength = tArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    while (i < typeArgumentsLength) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(tArguments[i].getName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
            case 39: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                return primitiveType.getPrimitiveTypeCode().toString();
            }
            case 75: {
                QualifiedType qualifiedType = (QualifiedType)type;
                return qualifiedType.getName().getIdentifier();
            }
            case 88: {
                NameQualifiedType nameQualifiedType = (NameQualifiedType)type;
                return nameQualifiedType.getName().getIdentifier();
            }
            case 43: {
                SimpleType simpleType = (SimpleType)type;
                Name name = simpleType.getName();
                if (name.isQualifiedName()) {
                    QualifiedName qualifiedName = (QualifiedName)name;
                    return qualifiedName.getName().getIdentifier();
                }
                return ((SimpleName)name).getIdentifier();
            }
        }
        return Util.EMPTY_STRING;
    }

    private Type getType() {
        if (this.currentType != null) {
            return this.currentType;
        }
        if (this.variableDeclaration == null) {
            return null;
        }
        switch (this.variableDeclaration.getNodeType()) {
            case 44: {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.variableDeclaration;
                return singleVariableDeclaration.getType();
            }
        }
        ASTNode parent = this.variableDeclaration.getParent();
        switch (parent.getNodeType()) {
            case 58: {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)parent;
                return variableDeclarationExpression.getType();
            }
            case 60: {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)parent;
                return statement.getType();
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)parent;
                return fieldDeclaration.getType();
            }
        }
        return null;
    }
}

