/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Statement;
import java.util.ArrayList;
import java.util.List;

public class SynchronizedStatement
extends Statement {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(SynchronizedStatement.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(SynchronizedStatement.class, "body", Block.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Expression expression = null;
    private Block body = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        SynchronizedStatement.createPropertyList(SynchronizedStatement.class, propertyList);
        SynchronizedStatement.addProperty(EXPRESSION_PROPERTY, propertyList);
        SynchronizedStatement.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SynchronizedStatement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    SynchronizedStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SynchronizedStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 51;
    }

    @Override
    ASTNode clone0(AST target) {
        SynchronizedStatement result = new SynchronizedStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setBody((Block)this.getBody().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            SynchronizedStatement synchronizedStatement = this;
            synchronized (synchronizedStatement) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getBody() {
        if (this.body == null) {
            SynchronizedStatement synchronizedStatement = this;
            synchronized (synchronizedStatement) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Block block) {
        if (block == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, block, BODY_PROPERTY);
        this.body = block;
        this.postReplaceChild(oldChild, block, BODY_PROPERTY);
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

