/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.dom.rewrite;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.rewrite.ASTRewrite;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite.ListRewriteEvent;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite.RewriteEvent;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite.RewriteEventStore;
import org.eclipse.text.edits.TextEditGroup;

public final class ListRewrite {
    private ASTNode parent;
    private ChildListPropertyDescriptor childListProperty;
    private ASTRewrite rewriter;

    ListRewrite(ASTRewrite rewriter, ASTNode parent, ChildListPropertyDescriptor childProperty) {
        this.rewriter = rewriter;
        this.parent = parent;
        this.childListProperty = childProperty;
    }

    private RewriteEventStore getRewriteStore() {
        return this.rewriter.getRewriteEventStore();
    }

    private ListRewriteEvent getEvent() {
        return this.getRewriteStore().getListEvent(this.parent, this.childListProperty, true);
    }

    public void remove(ASTNode node, TextEditGroup editGroup) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        RewriteEvent event = this.getEvent().removeEntry(node);
        if (editGroup != null) {
            this.getRewriteStore().setEventEditGroup(event, editGroup);
        }
    }

    public void replace(ASTNode node, ASTNode replacement, TextEditGroup editGroup) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.validatePropertyType(node);
        RewriteEvent event = this.getEvent().replaceEntry(node, replacement);
        if (editGroup != null) {
            this.getRewriteStore().setEventEditGroup(event, editGroup);
        }
    }

    public void insertAfter(ASTNode node, ASTNode previousElement, TextEditGroup editGroup) {
        if (node == null || previousElement == null) {
            throw new IllegalArgumentException();
        }
        int index = this.getEvent().getIndex(previousElement, 3);
        if (index == -1) {
            throw new IllegalArgumentException("Node does not exist");
        }
        this.internalInsertAt(node, index + 1, true, editGroup);
    }

    public void insertBefore(ASTNode node, ASTNode nextElement, TextEditGroup editGroup) {
        if (node == null || nextElement == null) {
            throw new IllegalArgumentException();
        }
        int index = this.getEvent().getIndex(nextElement, 3);
        if (index == -1) {
            throw new IllegalArgumentException("Node does not exist");
        }
        this.internalInsertAt(node, index, false, editGroup);
    }

    public void insertLast(ASTNode node, TextEditGroup editGroup) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.internalInsertAt(node, -1, true, editGroup);
    }

    private void internalInsertAt(ASTNode node, int index, boolean boundToPrevious, TextEditGroup editGroup) {
        this.validatePropertyType(node);
        RewriteEvent event = this.getEvent().insert(node, index);
        if (boundToPrevious) {
            this.getRewriteStore().setInsertBoundToPrevious(node);
        }
        if (editGroup != null) {
            this.getRewriteStore().setEventEditGroup(event, editGroup);
        }
    }

    private void validatePropertyType(ASTNode node) {
        if (!RewriteEventStore.DEBUG) {
            return;
        }
        if (!this.childListProperty.getElementType().isAssignableFrom(node.getClass())) {
            String message = String.valueOf(node.getClass().getName()) + " is not a valid type for " + this.childListProperty.getNodeClass().getName() + " property '" + this.childListProperty.getId() + "'. Must be " + this.childListProperty.getElementType().getName();
            throw new IllegalArgumentException(message);
        }
    }
}

