/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.core.search;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.IJavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.SearchParticipant;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.AccessRuleSet;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.Scanner;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.ScannerHelper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.index.EntryResult;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.index.Index;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.HierarchyScope;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.IndexQueryRequestor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.JavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.indexing.IIndexConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.ConstructorPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.FieldPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.MethodPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.ModulePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.OrPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.PackageDeclarationPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.PackageReferencePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.SuperTypeReferencePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.TypeReferencePattern;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class SearchPattern {
    private int matchRule;
    public IJavaElement focus;
    public char[] indexQualifierQuery;
    public int kind;
    public boolean mustResolve = true;

    public SearchPattern(int matchRule) {
        this.matchRule = matchRule;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
        if ((matchRule & 0x80) != 0) {
            this.matchRule &= 0xFFFFFEFF;
            this.matchRule &= 0xFFFFFFFE;
        } else if ((matchRule & 0x100) != 0) {
            this.matchRule &= 0xFFFFFFFE;
        }
    }

    public void acceptMatch(String relativePath, String containerPath, char separator, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) {
        if (scope instanceof JavaSearchScope) {
            JavaSearchScope javaSearchScope = (JavaSearchScope)scope;
            AccessRuleSet access = javaSearchScope.getAccessRuleSet(relativePath, containerPath);
            if (access != JavaSearchScope.NOT_ENCLOSED) {
                StringBuilder documentPath = new StringBuilder(containerPath.length() + 1 + relativePath.length());
                documentPath.append(containerPath);
                documentPath.append(separator);
                documentPath.append(relativePath);
                if (!requestor.acceptIndexMatch(documentPath.toString(), pattern, participant, access)) {
                    throw new OperationCanceledException();
                }
            }
        } else {
            boolean encloses;
            StringBuilder buffer = new StringBuilder(containerPath.length() + 1 + relativePath.length());
            buffer.append(containerPath);
            buffer.append(separator);
            buffer.append(relativePath);
            String documentPath = buffer.toString();
            boolean bl = encloses = scope instanceof HierarchyScope ? ((HierarchyScope)scope).encloses(documentPath, monitor) : scope.encloses(documentPath);
            if (encloses && !requestor.acceptIndexMatch(documentPath, pattern, participant, null)) {
                throw new OperationCanceledException();
            }
        }
    }

    public SearchPattern currentPattern() {
        return this;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createFieldPattern(String patternString, int limitTo, int matchRule) {
        scanner = new Scanner(false, true, false, 0x330000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        fieldName = null;
        type = null;
        mode = 1;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl47
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block2 : switch (mode) {
                case 1: {
                    switch (token) {
                        case 1: {
                            if (declaringType == null) {
                                if (fieldName == null) {
                                    return null;
                                }
                                declaringType = fieldName;
                            } else {
                                tokenSource = scanner.getCurrentTokenString();
                                declaringType = String.valueOf(declaringType) + tokenSource + fieldName;
                            }
                            fieldName = null;
                            break block2;
                        }
                        case 1000: {
                            if (1000 == lastToken || 1 == lastToken) break block2;
                            mode = 2;
                            break block2;
                        }
                    }
                    if (fieldName == null) {
                        fieldName = scanner.getCurrentTokenString();
                        break;
                    }
                    fieldName = String.valueOf(fieldName) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    switch (token) {
                        case 1000: {
                            break block2;
                        }
                    }
                    type = type == null ? scanner.getCurrentTokenString() : String.valueOf(type) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v1) {
                return null;
            }
lbl47:
            // 2 sources

        } while (token != 64);
        if (fieldName == null) {
            return null;
        }
        fieldNameChars = fieldName.toCharArray();
        if (fieldNameChars.length == 1 && fieldNameChars[0] == '*') {
            fieldNameChars = null;
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        typeQualification /* !! */  = null;
        typeSimpleName = null;
        if (declaringType != null) {
            declaringTypePart = declaringType.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (type != null) {
            typePart = type.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', typePart);
            if (lastDotPosition >= 0) {
                typeQualification /* !! */  = CharOperation.subarray(typePart, 0, lastDotPosition);
                typeQualification /* !! */  = (char[])(typeQualification /* !! */ .length == 1 && typeQualification /* !! */ [0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, typeQualification /* !! */ ));
                typeSimpleName = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
            } else {
                typeSimpleName = typePart;
            }
            if (typeSimpleName.length == 1 && typeSimpleName[0] == '*') {
                typeSimpleName = null;
            }
        }
        return new FieldPattern(fieldNameChars, declaringTypeQualification, declaringTypeSimpleName, typeQualification /* !! */ , typeSimpleName, limitTo, matchRule);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createMethodOrConstructorPattern(String patternString, int limitTo, int matchRule, boolean isConstructor) {
        scanner = new Scanner(false, true, false, 0x330000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        selector = null;
        parameterType = null;
        parameterTypes = null;
        typeArguments = null;
        typeArgumentsString = null;
        parameterCount = -1;
        returnType = null;
        foundClosingParenthesis = false;
        mode = 1;
        argCount = 0;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl167
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block5 : switch (mode) {
                case 1: {
                    if (argCount == 0) {
                        switch (token) {
                            case 11: {
                                ++argCount;
                                if (selector == null || lastToken == 1) {
                                    typeArgumentsString = scanner.getCurrentTokenString();
                                    mode = 2;
                                    break block5;
                                }
                                declaringType = declaringType == null ? selector : String.valueOf(declaringType) + '.' + selector;
                                declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                                selector = null;
                                break block5;
                            }
                            case 1: {
                                if (!isConstructor && typeArgumentsString != null) {
                                    return null;
                                }
                                if (declaringType == null) {
                                    if (selector == null) {
                                        return null;
                                    }
                                    declaringType = selector;
                                } else if (selector != null) {
                                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString() + selector;
                                }
                                selector = null;
                                break block5;
                            }
                            case 23: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 1000: {
                                switch (lastToken) {
                                    case 1: 
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 1000: {
                                        break block5;
                                    }
                                }
                                mode = 4;
                                break block5;
                            }
                        }
                        if (selector == null) {
                            selector = scanner.getCurrentTokenString();
                            break;
                        }
                        selector = String.valueOf(selector) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (declaringType == null) {
                        return null;
                    }
                    switch (token) {
                        case 14: 
                        case 15: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 11: {
                            ++argCount;
                        }
                    }
                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    if (typeArgumentsString == null) {
                        return null;
                    }
                    typeArgumentsString = String.valueOf(typeArgumentsString) + scanner.getCurrentTokenString();
                    switch (token) {
                        case 14: 
                        case 15: 
                        case 16: {
                            if (--argCount != 0) break;
                            pseudoType = "Type" + typeArgumentsString;
                            typeArguments = Signature.getTypeArguments(Signature.createTypeSignature(pseudoType, false).toCharArray());
                            mode = 1;
                            break;
                        }
                        case 11: {
                            ++argCount;
                        }
                    }
                    break;
                }
                case 3: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 32: {
                                if (parameterType == null) {
                                    return null;
                                }
                                if (parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v1 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v1, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                parameterType = null;
                                break block5;
                            }
                            case 26: {
                                foundClosingParenthesis = true;
                                if (parameterType != null && parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v2 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v2, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                mode = isConstructor != false ? 2 : 4;
                                break block5;
                            }
                            case 11: {
                                ++argCount;
                                if (parameterType != null) break;
                                return null;
                            }
                        }
                        if (parameterType == null) {
                            parameterType = scanner.getCurrentTokenString();
                            break;
                        }
                        parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (parameterType == null) {
                        return null;
                    }
                    switch (token) {
                        case 14: 
                        case 15: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 11: {
                            ++argCount;
                        }
                    }
                    parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                    break;
                }
                case 4: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 23: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 11: {
                                ++argCount;
                                if (returnType != null) break;
                                return null;
                            }
                        }
                        if (returnType == null) {
                            returnType = scanner.getCurrentTokenString();
                            break;
                        }
                        returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (returnType == null) {
                        return null;
                    }
                    switch (token) {
                        case 14: 
                        case 15: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 11: {
                            ++argCount;
                        }
                    }
                    returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v3) {
                return null;
            }
lbl167:
            // 2 sources

        } while (token != 64);
        if (parameterCount > 0 && !foundClosingParenthesis) {
            return null;
        }
        if (argCount > 0) {
            return null;
        }
        selectorChars = null;
        if (isConstructor) {
            if (declaringType == null) {
                declaringType = selector;
            } else if (selector != null) {
                declaringType = String.valueOf(declaringType) + '.' + selector;
            }
        } else {
            if (selector == null) {
                return null;
            }
            selectorChars = selector.toCharArray();
            if (selectorChars.length == 1 && selectorChars[0] == '*') {
                selectorChars = null;
            }
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        returnTypeQualification /* !! */  = null;
        returnTypeSimpleName = null;
        parameterTypeQualifications = null;
        parameterTypeSimpleNames = null;
        declaringTypeSignature = null;
        returnTypeSignature = null;
        parameterTypeSignatures = null;
        if (declaringType != null) {
            declaringTypePart = null;
            try {
                declaringTypeSignature = Signature.createTypeSignature(declaringType, false);
                declaringTypePart = declaringTypeSignature.indexOf(60) < 0 ? declaringType.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(declaringTypeSignature.toCharArray()));
            }
            catch (IllegalArgumentException v4) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (parameterCount >= 0) {
            parameterTypeQualifications = new char[parameterCount][];
            parameterTypeSimpleNames = new char[parameterCount][];
            parameterTypeSignatures = new String[parameterCount];
            i = 0;
            while (i < parameterCount) {
                parameterTypePart = null;
                try {
                    if (parameterTypes != null) {
                        parameterTypeSignatures[i] = Signature.createTypeSignature(parameterTypes[i], false);
                        parameterTypePart = parameterTypeSignatures[i].indexOf(60) < 0 ? parameterTypes[i].toCharArray() : Signature.toCharArray(Signature.getTypeErasure(parameterTypeSignatures[i].toCharArray()));
                    }
                }
                catch (IllegalArgumentException v5) {
                    return null;
                }
                v6 = lastDotPosition = parameterTypePart == null ? -1 : CharOperation.lastIndexOf('.', parameterTypePart);
                if (parameterTypePart != null && lastDotPosition >= 0) {
                    parameterTypeQualifications[i] = CharOperation.subarray(parameterTypePart, 0, lastDotPosition);
                    parameterTypeQualifications[i] = (char[])(parameterTypeQualifications[i].length == 1 && parameterTypeQualifications[i][0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, parameterTypeQualifications[i]));
                    parameterTypeSimpleNames[i] = CharOperation.subarray(parameterTypePart, lastDotPosition + 1, parameterTypePart.length);
                } else {
                    parameterTypeQualifications[i] = null;
                    parameterTypeSimpleNames[i] = parameterTypePart;
                }
                if (parameterTypeSimpleNames[i].length == 1 && parameterTypeSimpleNames[i][0] == '*') {
                    parameterTypeSimpleNames[i] = null;
                }
                ++i;
            }
        }
        if (returnType != null) {
            returnTypePart = null;
            try {
                returnTypeSignature = Signature.createTypeSignature(returnType, false);
                returnTypePart = returnTypeSignature.indexOf(60) < 0 ? returnType.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(returnTypeSignature.toCharArray()));
            }
            catch (IllegalArgumentException v7) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', returnTypePart);
            if (lastDotPosition >= 0) {
                returnTypeQualification /* !! */  = CharOperation.subarray(returnTypePart, 0, lastDotPosition);
                returnTypeQualification /* !! */  = (char[])(returnTypeQualification /* !! */ .length == 1 && returnTypeQualification /* !! */ [0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, returnTypeQualification /* !! */ ));
                returnTypeSimpleName = CharOperation.subarray(returnTypePart, lastDotPosition + 1, returnTypePart.length);
            } else {
                returnTypeSimpleName = returnTypePart;
            }
            if (returnTypeSimpleName.length == 1 && returnTypeSimpleName[0] == '*') {
                returnTypeSimpleName = null;
            }
        }
        if (isConstructor) {
            return new ConstructorPattern(declaringTypeSimpleName, declaringTypeQualification, declaringTypeSignature, parameterTypeQualifications, parameterTypeSimpleNames, parameterTypeSignatures, typeArguments, limitTo, matchRule);
        }
        return new MethodPattern(selectorChars, declaringTypeQualification, declaringTypeSimpleName, declaringTypeSignature, returnTypeQualification /* !! */ , returnTypeSimpleName, returnTypeSignature, parameterTypeQualifications, parameterTypeSimpleNames, parameterTypeSignatures, typeArguments, limitTo, matchRule);
    }

    private static SearchPattern createModulePattern(String patternString, int limitTo, int matchRule) {
        return new ModulePattern(patternString.toCharArray(), limitTo, matchRule);
    }

    public static SearchPattern createOrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return new OrPattern(leftPattern, rightPattern);
    }

    private static SearchPattern createPackagePattern(String patternString, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new PackageDeclarationPattern(patternString.toCharArray(), matchRule);
            }
            case 2: {
                return new PackageReferencePattern(patternString.toCharArray(), matchRule);
            }
            case 3: {
                return new OrPattern(new PackageDeclarationPattern(patternString.toCharArray(), matchRule), new PackageReferencePattern(patternString.toCharArray(), matchRule));
            }
        }
        return null;
    }

    public static SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, int matchRule) {
        if (stringPattern == null || stringPattern.length() == 0) {
            return null;
        }
        if ((matchRule = SearchPattern.validateMatchRule(stringPattern, searchFor, limitTo, matchRule)) == -1) {
            return null;
        }
        limitTo &= 0xFFFFFFCF;
        switch (searchFor) {
            case 5: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'C');
            }
            case 10: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\n');
            }
            case 9: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\t');
            }
            case 6: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'I');
            }
            case 11: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u000b');
            }
            case 7: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'E');
            }
            case 8: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'A');
            }
            case 0: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u0000');
            }
            case 1: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false);
            }
            case 3: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, true);
            }
            case 4: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule);
            }
            case 2: {
                return SearchPattern.createPackagePattern(stringPattern, limitTo, matchRule);
            }
            case 12: {
                return SearchPattern.createModulePattern(stringPattern, limitTo, matchRule);
            }
        }
        return null;
    }

    private static SearchPattern createTypePattern(String patternString, int limitTo, int matchRule, char indexSuffix) {
        int token;
        String[] arr = patternString.split(String.valueOf('/'));
        String moduleName = null;
        if (arr.length == 2) {
            moduleName = arr[0];
            patternString = arr[1];
        }
        char[] patModName = moduleName != null ? moduleName.toCharArray() : null;
        Scanner scanner = new Scanner(false, true, false, 0x330000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        String type = null;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        int argCount = 0;
        while (token != 64) {
            if (argCount == 0) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 11: {
                        ++argCount;
                    }
                    default: {
                        if (type == null) {
                            type = scanner.getCurrentTokenString();
                            break;
                        }
                        type = String.valueOf(type) + scanner.getCurrentTokenString();
                        break;
                    }
                }
            } else {
                switch (token) {
                    case 14: 
                    case 15: 
                    case 16: {
                        --argCount;
                        break;
                    }
                    case 11: {
                        ++argCount;
                    }
                }
                if (type == null) {
                    return null;
                }
                type = String.valueOf(type) + scanner.getCurrentTokenString();
            }
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (type == null) {
            return null;
        }
        String typeSignature = null;
        char[] qualificationChars = null;
        char[] typeChars = null;
        char[] typePart = null;
        try {
            typeSignature = Signature.createTypeSignature(type, false);
            typePart = typeSignature.indexOf(60) < 0 ? type.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(typeSignature.toCharArray()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        int lastDotPosition = CharOperation.lastIndexOf('.', typePart);
        if (lastDotPosition >= 0) {
            qualificationChars = CharOperation.subarray(typePart, 0, lastDotPosition);
            if (qualificationChars.length == 1 && qualificationChars[0] == '*') {
                qualificationChars = null;
            }
            typeChars = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
        } else {
            typeChars = typePart;
        }
        if (typeChars.length == 1 && typeChars[0] == '*') {
            typeChars = null;
        }
        boolean modGraph = false;
        switch (limitTo) {
            case 6: {
                modGraph = true;
            }
            case 0: {
                QualifiedTypeDeclarationPattern typeDeclarationPattern = new QualifiedTypeDeclarationPattern(patModName, qualificationChars, typeChars, indexSuffix, matchRule);
                typeDeclarationPattern.moduleGraph = modGraph;
                return typeDeclarationPattern;
            }
            case 2: {
                return new TypeReferencePattern(qualificationChars, typeChars, typeSignature, indexSuffix, matchRule);
            }
            case 1: {
                return new SuperTypeReferencePattern(qualificationChars, typeChars, 1, indexSuffix, matchRule);
            }
            case 3: {
                return new OrPattern(new QualifiedTypeDeclarationPattern(patModName, qualificationChars, typeChars, indexSuffix, matchRule), new TypeReferencePattern(qualificationChars, typeChars, typeSignature, indexSuffix, matchRule));
            }
        }
        return new TypeReferencePattern(qualificationChars, typeChars, typeSignature, limitTo, indexSuffix, matchRule);
    }

    public void decodeIndexKey(char[] key) {
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        this.findIndexMatches(index, requestor, participant, scope, true, monitor);
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            String containerPath = index.containerPath;
            char separator = index.separator;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                SearchPattern decodedResult = pattern.getBlankPattern();
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    if (resolveDocumentName) {
                        String[] names = entry.getDocumentNames(index);
                        int j = 0;
                        int n = names.length;
                        while (j < n) {
                            this.acceptMatch(names[j], containerPath, separator, decodedResult, requestor, participant, scope, monitor);
                            ++j;
                        }
                    } else {
                        this.acceptMatch("", containerPath, separator, decodedResult, requestor, participant, scope, monitor);
                    }
                }
                ++i;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    public abstract SearchPattern getBlankPattern();

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean emptyPattern;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            int matchMode = this.matchRule & 0x787;
            boolean bl = emptyPattern = pattern.length == 0;
            if (emptyPattern && (this.matchRule & 1) != 0) {
                return true;
            }
            boolean sameLength = pattern.length == name.length;
            boolean canBePrefix = name.length >= pattern.length;
            boolean bl2 = matchFirstChar = !isCaseSensitive || emptyPattern || name.length > 0 && pattern[0] == name[0];
            if ((matchMode & 0x200) != 0) {
                if (CharOperation.substringMatch(pattern, name)) {
                    return true;
                }
                matchMode &= 0xFFFFFDFF;
            }
            if ((matchMode & 0x400) != 0) {
                if (CharOperation.subWordMatch(pattern, name)) {
                    return true;
                }
                matchMode &= 0xFFFFFBFF;
            }
            switch (matchMode) {
                case 0: {
                    if (!sameLength || !matchFirstChar) break;
                    return CharOperation.equals(pattern, name, isCaseSensitive);
                }
                case 1: {
                    if (!canBePrefix || !matchFirstChar) break;
                    return CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 128: {
                    if (matchFirstChar && CharOperation.camelCaseMatch(pattern, name, false)) {
                        return true;
                    }
                    if (isCaseSensitive || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, false)) break;
                    return true;
                }
                case 256: {
                    return matchFirstChar && CharOperation.camelCaseMatch(pattern, name, true);
                }
                case 4: {
                    return Pattern.matches(new String(pattern), new String(name));
                }
            }
        }
        return false;
    }

    public static int validateMatchRule(String stringPattern, int matchRule) {
        boolean validCamelCase;
        if ((matchRule & 4) != 0) {
            return -1;
        }
        if (stringPattern != null) {
            int starIndex = stringPattern.indexOf(42);
            int questionIndex = stringPattern.indexOf(63);
            matchRule = starIndex < 0 && questionIndex < 0 ? (matchRule &= 0xFFFFFFFD) : (matchRule |= 2);
        }
        if ((matchRule & 2) != 0) {
            matchRule &= 0xFFFFFF7F;
            matchRule &= 0xFFFFFEFF;
            return matchRule &= 0xFFFFFFFE;
        }
        if ((matchRule & 0x80) != 0) {
            matchRule &= 0xFFFFFEFF;
            matchRule &= 0xFFFFFFFE;
            validCamelCase = SearchPattern.validateCamelCasePattern(stringPattern);
            if (!validCamelCase) {
                matchRule &= 0xFFFFFF7F;
                matchRule |= 1;
            }
            return matchRule;
        }
        if ((matchRule & 0x100) != 0) {
            matchRule &= 0xFFFFFFFE;
            validCamelCase = SearchPattern.validateCamelCasePattern(stringPattern);
            if (!validCamelCase) {
                matchRule &= 0xFFFFFEFF;
            }
            return matchRule;
        }
        return matchRule;
    }

    private static int validateMatchRule(String stringPattern, int searchFor, int limitTo, int matchRule) {
        if (searchFor == 12 && limitTo == 0 && matchRule == 4) {
            return matchRule;
        }
        return SearchPattern.validateMatchRule(stringPattern, matchRule);
    }

    private static boolean validateCamelCasePattern(String stringPattern) {
        if (stringPattern == null) {
            return true;
        }
        int length = stringPattern.length();
        boolean validCamelCase = true;
        boolean lowerCamelCase = false;
        int uppercase = 0;
        int i = 0;
        while (i < length && validCamelCase) {
            char ch = stringPattern.charAt(i);
            boolean bl = validCamelCase = i == 0 ? ScannerHelper.isJavaIdentifierStart(ch) : ScannerHelper.isJavaIdentifierPart(ch);
            if (ScannerHelper.isUpperCase(ch)) {
                ++uppercase;
            }
            if (i == 0) {
                lowerCamelCase = uppercase == 0;
            }
            ++i;
        }
        if (validCamelCase) {
            validCamelCase = lowerCamelCase ? uppercase > 0 : uppercase > 1;
        }
        return validCamelCase;
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        return index.query(this.getIndexCategories(), this.getIndexKey(), this.getMatchRule());
    }

    public String toString() {
        return "SearchPattern";
    }

    public SearchPattern clone() throws CloneNotSupportedException {
        return (SearchPattern)super.clone();
    }
}

