/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.MagicLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.codegen.BranchLabel;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.codegen.CodeStream;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.BooleanConstant;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.BlockScope;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding;

public class FalseLiteral
extends MagicLiteral {
    static final char[] source = new char[]{'f', 'a', 'l', 's', 'e'};

    public FalseLiteral(int s, int e) {
        super(s, e);
    }

    @Override
    public void computeConstant() {
        this.constant = BooleanConstant.fromValue(false);
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired && falseLabel != null && trueLabel == null) {
            codeStream.goto_(falseLabel);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public TypeBinding literalType(BlockScope scope) {
        return TypeBinding.BOOLEAN;
    }

    @Override
    public char[] source() {
        return source;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

