/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CompilationProgress;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.IProblem;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch.FileSystem;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.AccessRule;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.AccessRuleSet;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.HashtableOfInt;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class Main
implements SuffixConstants {
    public ResourceBundle bundle;
    private List<String> addonExports = Collections.EMPTY_LIST;
    private List<String> addonReads = Collections.EMPTY_LIST;
    public Set<String> rootModules = Collections.EMPTY_SET;
    public Locale compilerLocale;
    public CompilationProgress progress;
    protected String releaseVersion;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] classNames;
    private boolean javaHomeChecked = false;
    private boolean primaryNullAnnotationsSeen = false;
    public Logger logger;
    public Map<String, String> options;
    public char[][] ignoreOptionalProblemsFromFolders;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean failOnWarning = false;
    public boolean produceRefInfo = false;
    public boolean showProgress = false;
    public ArrayList<String> pendingErrors;
    public boolean systemExitWhenFinished = true;
    public int timing = 0;
    public boolean verbose = false;
    private PrintWriter err;

    public static File[][] getLibrariesFiles(File[] files) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Util.archiveFormat(name) > -1;
            }
        };
        int filesLength = files.length;
        File[][] result = new File[filesLength][];
        int i = 0;
        while (i < filesLength) {
            File currentFile = files[i];
            if (currentFile.exists() && currentFile.isDirectory()) {
                result[i] = currentFile.listFiles(filter);
            }
            ++i;
        }
        return result;
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Map<String, String> customDefaultOptions, CompilationProgress compilationProgress) {
        this.initialize(outWriter, errWriter, systemExitWhenFinished, customDefaultOptions, compilationProgress);
        this.relocalize();
    }

    protected void addNewEntry(ArrayList<FileSystem.Classpath> paths, String currentClasspathName, ArrayList<String> currentRuleSpecs, String customEncoding, String destPath, boolean isSourceOnly, boolean rejectDestinationPathOnJars) {
        int rulesSpecsSize = currentRuleSpecs.size();
        AccessRuleSet accessRuleSet = null;
        if (rulesSpecsSize != 0) {
            AccessRule[] accessRules = new AccessRule[currentRuleSpecs.size()];
            boolean rulesOK = true;
            Iterator<String> i = currentRuleSpecs.iterator();
            int j = 0;
            while (i.hasNext()) {
                String ruleSpec = i.next();
                char key = ruleSpec.charAt(0);
                String pattern = ruleSpec.substring(1);
                if (pattern.length() > 0) {
                    switch (key) {
                        case '+': {
                            accessRules[j++] = new AccessRule(pattern.toCharArray(), 0);
                            break;
                        }
                        case '~': {
                            accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000118);
                            break;
                        }
                        case '-': {
                            accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000133);
                            break;
                        }
                        case '?': {
                            accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000133, true);
                            break;
                        }
                        default: {
                            rulesOK = false;
                            break;
                        }
                    }
                    continue;
                }
                rulesOK = false;
            }
            if (rulesOK) {
                accessRuleSet = new AccessRuleSet(accessRules, 0, currentClasspathName);
            } else {
                if (currentClasspathName.length() != 0) {
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", currentClasspathName));
                }
                return;
            }
        }
        if ("none".equals(destPath)) {
            destPath = "none";
        }
        if (rejectDestinationPathOnJars && destPath != null && Util.archiveFormat(currentClasspathName) > -1) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", currentClasspathName));
        }
        FileSystem.Classpath currentClasspath = FileSystem.getClasspath(currentClasspathName, customEncoding, isSourceOnly, accessRuleSet, destPath, this.options, this.releaseVersion);
        if (currentClasspath != null) {
            paths.add(currentClasspath);
        } else if (currentClasspathName.length() != 0) {
            this.addPendingErrors(this.bind("configure.incorrectClasspath", currentClasspathName));
        }
    }

    void addPendingErrors(String message) {
        if (this.pendingErrors == null) {
            this.pendingErrors = new ArrayList();
        }
        this.pendingErrors.add(message);
    }

    public String bind(String id, String binding) {
        return this.bind(id, new String[]{binding});
    }

    public String bind(String id, String[] arguments) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = this.bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + "io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch.messages";
        }
        return MessageFormat.format(message, arguments);
    }

    protected void initialize(PrintWriter outWriter, PrintWriter errWriter, boolean systemExit, Map<String, String> customDefaultOptions, CompilationProgress compilationProgress) {
        this.logger = new Logger(this, outWriter, errWriter);
        this.proceed = true;
        this.out = outWriter;
        this.err = errWriter;
        this.systemExitWhenFinished = systemExit;
        this.options = new CompilerOptions().getMap();
        this.ignoreOptionalProblemsFromFolders = null;
        this.progress = compilationProgress;
        if (customDefaultOptions != null) {
            this.didSpecifySource = customDefaultOptions.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source") != null;
            this.didSpecifyTarget = customDefaultOptions.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.targetPlatform") != null;
            for (Map.Entry<String, String> entry : customDefaultOptions.entrySet()) {
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    public void processPathEntries(int defaultSize, ArrayList<FileSystem.Classpath> paths, String currentPath, String customEncoding, boolean isSourceOnly, boolean rejectDestinationPathOnJars) {
        String currentClasspathName = null;
        String currentDestinationPath = null;
        ArrayList<String> currentRuleSpecs = new ArrayList<String>(defaultSize);
        StringTokenizer tokenizer = new StringTokenizer(currentPath, String.valueOf(File.pathSeparator) + "[]", true);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        int state = 0;
        String token = null;
        int cursor = 0;
        int tokensNb = tokens.size();
        int bracket = -1;
        while (cursor < tokensNb && state != 99) {
            if ((token = (String)tokens.get(cursor++)).equals(File.pathSeparator)) {
                switch (state) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        state = 3;
                        this.addNewEntry(paths, currentClasspathName, currentRuleSpecs, customEncoding, currentDestinationPath, isSourceOnly, rejectDestinationPathOnJars);
                        currentRuleSpecs.clear();
                        break;
                    }
                    case 6: {
                        state = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", currentPath));
                    }
                    case 11: {
                        cursor = bracket + 1;
                        state = 5;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
            } else if (token.equals("[")) {
                switch (state) {
                    case 0: {
                        currentClasspathName = "";
                    }
                    case 1: {
                        bracket = cursor - 1;
                    }
                    case 11: {
                        state = 10;
                        break;
                    }
                    case 2: {
                        state = 9;
                        break;
                    }
                    case 8: {
                        state = 5;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
            } else if (token.equals("]")) {
                switch (state) {
                    case 6: {
                        state = 2;
                        break;
                    }
                    case 7: {
                        state = 8;
                        break;
                    }
                    case 10: {
                        state = 11;
                        break;
                    }
                    default: {
                        state = 99;
                        break;
                    }
                }
            } else {
                switch (state) {
                    case 0: 
                    case 3: {
                        state = 1;
                        currentClasspathName = token;
                        break;
                    }
                    case 5: {
                        if (token.startsWith("-d ")) {
                            if (currentDestinationPath != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", currentPath));
                            }
                            currentDestinationPath = token.substring(3).trim();
                            state = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (currentDestinationPath != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", currentPath));
                        }
                        state = 6;
                        currentRuleSpecs.add(token);
                        break;
                    }
                    case 9: {
                        if (!token.startsWith("-d ")) {
                            state = 99;
                            break;
                        }
                        currentDestinationPath = token.substring(3).trim();
                        state = 7;
                        break;
                    }
                    case 11: {
                        int i = bracket;
                        while (i < cursor) {
                            currentClasspathName = String.valueOf(currentClasspathName) + (String)tokens.get(i);
                            ++i;
                        }
                        state = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        state = 99;
                    }
                }
            }
            if (state != 11 || cursor != tokensNb) continue;
            cursor = bracket + 1;
            state = 5;
        }
        switch (state) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(paths, currentClasspathName, currentRuleSpecs, customEncoding, currentDestinationPath, isSourceOnly, rejectDestinationPathOnJars);
                break;
            }
            default: {
                if (currentPath.length() == 0) break;
                this.addPendingErrors(this.bind("configure.incorrectClasspath", currentPath));
            }
        }
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + "io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch.messages".replace('.', '/') + ".properties for locale " + locale);
            throw e;
        }
    }

    public static class Logger {
        private PrintWriter err;
        private Main main;
        private PrintWriter out;
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();

        static {
            try {
                Class<IProblem> c = IProblem.class;
                Field[] fields = c.getFields();
                int i = 0;
                int max = fields.length;
                while (i < max) {
                    Field field = fields[i];
                    if (field.getType().equals(Integer.TYPE)) {
                        Integer value = (Integer)field.get(null);
                        int key2 = value & 0x1FFFFF;
                        if (key2 == 0) {
                            key2 = Integer.MAX_VALUE;
                        }
                        FIELD_TABLE.put(key2, field.getName());
                    }
                    ++i;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }

        public Logger(Main main, PrintWriter out, PrintWriter err) {
            this.out = out;
            this.err = err;
            this.main = main;
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap<Locale, ResourceBundle> Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle bundle = Cache.get(locale);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle("io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.batch.messages", locale);
                Cache.put(locale, bundle);
            }
            return bundle;
        }
    }
}

