/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.Compiler;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.IrritantSet;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class CompilerOptions {
    static final char[][] DEFAULT_NULLABLE_ANNOTATION_NAME = CharOperation.splitOn('.', "io.spring.javaformat.eclipse.jdt.jdk11.annotation.Nullable".toCharArray());
    static final char[][] DEFAULT_NONNULL_ANNOTATION_NAME = CharOperation.splitOn('.', "io.spring.javaformat.eclipse.jdt.jdk11.annotation.NonNull".toCharArray());
    static final char[][] DEFAULT_NONNULLBYDEFAULT_ANNOTATION_NAME = CharOperation.splitOn('.', "io.spring.javaformat.eclipse.jdt.jdk11.annotation.NonNullByDefault".toCharArray());
    private static final String[] NO_STRINGS = new String[0];
    protected IrritantSet errorThreshold;
    protected IrritantSet warningThreshold;
    protected IrritantSet infoThreshold;
    public int produceDebugAttributes;
    public boolean produceMethodParameters;
    public boolean generateGenericSignatureForLambdaExpressions;
    public long complianceLevel;
    public long originalComplianceLevel;
    public long sourceLevel;
    public long originalSourceLevel;
    public long targetJDK;
    public String defaultEncoding;
    public boolean verbose;
    public boolean produceReferenceInfo;
    public boolean preserveAllLocalVariables;
    public boolean parseLiteralExpressionsAsConstants;
    public int maxProblemsPerUnit;
    public char[][] taskTags;
    public char[][] taskPriorities;
    public boolean isTaskCaseSensitive;
    public boolean reportDeprecationInsideDeprecatedCode;
    public boolean reportDeprecationWhenOverridingDeprecatedMethod;
    public boolean reportUnusedParameterWhenImplementingAbstract;
    public boolean reportUnusedParameterWhenOverridingConcrete;
    public boolean reportUnusedParameterIncludeDocCommentReference;
    public boolean reportUnusedDeclaredThrownExceptionWhenOverriding;
    public boolean reportUnusedDeclaredThrownExceptionIncludeDocCommentReference;
    public boolean reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable;
    public boolean reportSpecialParameterHidingField;
    public boolean reportDeadCodeInTrivialIfStatement;
    public boolean docCommentSupport;
    public boolean reportInvalidJavadocTags;
    public int reportInvalidJavadocTagsVisibility;
    public boolean reportInvalidJavadocTagsDeprecatedRef;
    public boolean reportInvalidJavadocTagsNotVisibleRef;
    public String reportMissingJavadocTagDescription;
    public int reportMissingJavadocTagsVisibility;
    public boolean reportMissingJavadocTagsOverriding;
    public boolean reportMissingJavadocTagsMethodTypeParameters;
    public int reportMissingJavadocCommentsVisibility;
    public boolean reportMissingJavadocCommentsOverriding;
    public boolean inlineJsrBytecode;
    public boolean shareCommonFinallyBlocks;
    public boolean suppressWarnings;
    public boolean suppressOptionalErrors;
    public boolean treatOptionalErrorAsFatal;
    public boolean performMethodsFullRecovery;
    public boolean performStatementsRecovery;
    public boolean processAnnotations;
    public boolean storeAnnotations;
    public boolean reportMissingOverrideAnnotationForInterfaceMethodImplementation;
    public boolean generateClassFiles;
    public boolean ignoreMethodBodies;
    public boolean includeNullInfoFromAsserts;
    public boolean reportUnavoidableGenericTypeProblems;
    public boolean ignoreSourceFolderWarningOption;
    public boolean isAnnotationBasedNullAnalysisEnabled;
    public char[][] nullableAnnotationName;
    public char[][] nonNullAnnotationName;
    public char[][] nonNullByDefaultAnnotationName;
    public String[] nullableAnnotationSecondaryNames = NO_STRINGS;
    public String[] nonNullAnnotationSecondaryNames = NO_STRINGS;
    public String[] nonNullByDefaultAnnotationSecondaryNames = NO_STRINGS;
    public long intendedDefaultNonNullness;
    public boolean analyseResourceLeaks;
    public boolean reportMissingEnumCaseDespiteDefault;
    public boolean reportUnlikelyCollectionMethodArgumentTypeStrict;
    public static boolean tolerateIllegalAmbiguousVarargsInvocation;
    public boolean inheritNullAnnotations;
    public boolean enableSyntacticNullAnalysisForFields;
    public boolean pessimisticNullAnalysisForFreeTypeVariablesEnabled;
    public boolean complainOnUninternedIdentityComparison;
    public boolean emulateJavacBug8031744;
    public Boolean useNullTypeAnnotations;
    public boolean enablePreviewFeatures;
    public boolean enableJdtDebugCompileMode;
    public static final String[] warningTokens;

    static {
        warningTokens = new String[]{"all", "boxing", "cast", "dep-ann", "deprecation", "exports", "fallthrough", "finally", "hiding", "incomplete-switch", "javadoc", "module", "nls", "null", "rawtypes", "removal", "resource", "restriction", "serial", "static-access", "static-method", "super", "synthetic-access", "sync-override", "unchecked", "unlikely-arg-type", "unqualified-field-access", "unused", "preview"};
    }

    public CompilerOptions() {
        this(null);
    }

    public CompilerOptions(Map<String, String> settings) {
        String tolerateIllegalAmbiguousVarargs = System.getProperty("tolerateIllegalAmbiguousVarargsInvocation");
        tolerateIllegalAmbiguousVarargsInvocation = tolerateIllegalAmbiguousVarargs != null && tolerateIllegalAmbiguousVarargs.equalsIgnoreCase("true");
        this.emulateJavacBug8031744 = true;
        this.useNullTypeAnnotations = null;
        this.resetDefaults();
        if (settings != null) {
            this.set(settings);
        }
    }

    public static String getLatestVersion() {
        return "18";
    }

    public static String optionKeyFromIrritant(int irritant) {
        switch (irritant) {
            case 1: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.methodWithConstructorName";
            }
            case 2: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingPackageDefaultMethod";
            }
            case 4: 
            case 0x2000004: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecation";
            }
            case 0x40800000: 
            case 1115684864: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.terminalDeprecation";
            }
            case 8: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.hiddenCatchBlock";
            }
            case 16: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLocal";
            }
            case 32: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameter";
            }
            case 0x40040000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedExceptionParameter";
            }
            case 64: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noImplicitStringConversion";
            }
            case 128: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.syntheticAccessEmulation";
            }
            case 256: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonExternalizedStringLiteral";
            }
            case 512: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.assertIdentifier";
            }
            case 1024: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedImport";
            }
            case 2048: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.staticAccessReceiver";
            }
            case 4096: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskTags";
            }
            case 8192: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noEffectAssignment";
            }
            case 16384: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
            }
            case 32768: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedPrivateMember";
            }
            case 65536: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.localVariableHiding";
            }
            case 131072: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fieldHiding";
            }
            case 262144: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.possibleAccidentalBooleanAssignment";
            }
            case 524288: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.emptyStatement";
            }
            case 0x100000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocComments";
            }
            case 0x200000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTags";
            }
            case 0x400000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unqualifiedFieldAccess";
            }
            case 0x800000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownException";
            }
            case 0x1000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finallyBlockNotCompletingNormally";
            }
            case 0x2000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadoc";
            }
            case 0x4000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryTypeCheck";
            }
            case 0x8000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.undocumentedEmptyBlock";
            }
            case 0x10000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.indirectStaticAccess";
            }
            case 0x20000001: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryElse";
            }
            case 0x20000002: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.uncheckedTypeOperation";
            }
            case 0x20000004: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finalParameterBound";
            }
            case 0x20000008: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSerialVersion";
            }
            case 0x20000010: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enumIdentifier";
            }
            case 0x20000020: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.forbiddenReference";
            }
            case 0x20000040: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.varargsArgumentNeedCast";
            }
            case 0x20000080: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullReference";
            }
            case 0x20200000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentialNullReference";
            }
            case 0x20400000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullCheck";
            }
            case 0x20000100: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.autoboxing";
            }
            case 0x20000200: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotationSuperInterface";
            }
            case 0x20000400: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.typeParameterHiding";
            }
            case 0x20000800: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingOverrideAnnotation";
            }
            case 0x20001000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompleteEnumSwitch";
            }
            case 0x40008000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDefaultCase";
            }
            case 0x20002000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDeprecatedAnnotation";
            }
            case 0x20004000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.discouragedReference";
            }
            case 0x20008000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unhandledWarningToken";
            }
            case 0x20010000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.rawTypeReference";
            }
            case 0x20020000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLabel";
            }
            case 0x20040000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.parameterAssignment";
            }
            case 0x20080000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fallthroughCase";
            }
            case 0x20100000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingMethodWithoutSuperInvocation";
            }
            case 0x20800000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagDescription";
            }
            case 0x21000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeArgumentsForMethodInvocation";
            }
            case 0x40010000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeParameter";
            }
            case 0x22000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedWarningToken";
            }
            case 0x24000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSuperinterface";
            }
            case 0x28000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.comparingIdentical";
            }
            case 0x30000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSynchronizedOnInheritedMethod";
            }
            case 0x40000001: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingHashCodeMethod";
            }
            case 0x40000002: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deadCode";
            }
            case 0x40000008: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedObjectAllocation";
            }
            case 0x40000010: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBeStatic";
            }
            case 0x40000020: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBePotentiallyStatic";
            }
            case 0x40004000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.missingNonNullByDefaultAnnotation";
            }
            case 0x40000040: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSpecificationOfTypeArguments";
            }
            case 0x40000080: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unclosedCloseable";
            }
            case 0x40000100: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentiallyUnclosedCloseable";
            }
            case 0x40000200: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.explicitlyClosedAutoCloseable";
            }
            case 0x40000400: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullSpecViolation";
            }
            case 0x40000800: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullAnnotationInferenceConflict";
            }
            case 0x40001000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullUncheckedConversion";
            }
            case 0x40002000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullAnnotation";
            }
            case 0x40020000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullParameterAnnotationDropped";
            }
            case 0x40080000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables";
            }
            case 0x40100000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation";
            }
            case 0x50000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotatedTypeArgumentToUnannotated";
            }
            case 0x40200000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyCollectionMethodArgumentType";
            }
            case 0x40400000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyEqualsArgumentType";
            }
            case 0x41000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.APILeak";
            }
            case 0x42000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unstableAutoModuleName";
            }
            case 0x44000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportPreviewFeatures";
            }
            case 0x48000000: {
                return "io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressWarningsNotFullyAnalysed";
            }
        }
        return null;
    }

    public static String versionFromJdkLevel(long jdkLevel) {
        int major = (int)(jdkLevel >> 16);
        switch (major) {
            case 45: {
                if (jdkLevel != 2949123L) break;
                return "1.1";
            }
            case 46: {
                if (jdkLevel != 0x2E0000L) break;
                return "1.2";
            }
            case 47: {
                if (jdkLevel != 0x2F0000L) break;
                return "1.3";
            }
            case 48: {
                if (jdkLevel != 0x300000L) break;
                return "1.4";
            }
            case 49: {
                if (jdkLevel != 0x310000L) break;
                return "1.5";
            }
            case 50: {
                if (jdkLevel != 0x320000L) break;
                return "1.6";
            }
            case 51: {
                if (jdkLevel != 0x330000L) break;
                return "1.7";
            }
            case 52: {
                if (jdkLevel != 0x340000L) break;
                return "1.8";
            }
            case 53: {
                if (jdkLevel != 0x350000L) break;
                return "9";
            }
            case 54: {
                if (jdkLevel != 0x360000L) break;
                return "10";
            }
            default: {
                if (major > 54) {
                    return "" + (major - 44);
                }
                return Util.EMPTY_STRING;
            }
        }
        return Util.EMPTY_STRING;
    }

    public static long releaseToJDKLevel(String release) {
        int major;
        if (release != null && release.length() > 0 && (major = Integer.parseInt(release) + 44) <= 62) {
            long jdkLevel = ((long)major << 16) + 0L;
            return jdkLevel;
        }
        return 0L;
    }

    public static long versionToJdkLevel(String versionID) {
        return CompilerOptions.versionToJdkLevel(versionID, true);
    }

    public static long versionToJdkLevel(String versionID, boolean supportUnreleased) {
        String version = versionID;
        if (version != null && version.length() > 0) {
            int major;
            block21: {
                if (version.length() >= 3 && version.charAt(0) == '1' && version.charAt(1) == '.') {
                    switch (version.charAt(2)) {
                        case '1': {
                            return 2949123L;
                        }
                        case '2': {
                            return 0x2E0000L;
                        }
                        case '3': {
                            return 0x2F0000L;
                        }
                        case '4': {
                            return 0x300000L;
                        }
                        case '5': {
                            return 0x310000L;
                        }
                        case '6': {
                            return 0x320000L;
                        }
                        case '7': {
                            return 0x330000L;
                        }
                        case '8': {
                            return 0x340000L;
                        }
                    }
                    return 0L;
                }
                try {
                    int index = version.indexOf(46);
                    if (index != -1) {
                        version = version.substring(0, index);
                    } else {
                        index = version.indexOf(45);
                        if (index != -1) {
                            version = version.substring(0, index);
                        }
                    }
                    major = Integer.parseInt(version) + 44;
                    if (major <= 62) break block21;
                    if (supportUnreleased) {
                        major = 62;
                        break block21;
                    }
                    return 0L;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return ((long)major << 16) + 0L;
        }
        if ("jsr14".equals(versionID)) {
            return 0x300000L;
        }
        if ("cldc1.1".equals(versionID)) {
            return 2949124L;
        }
        return 0L;
    }

    public static IrritantSet warningTokenToIrritants(String warningToken) {
        if (warningToken == null || warningToken.length() == 0) {
            return null;
        }
        switch (warningToken.charAt(0)) {
            case 'a': {
                if (!"all".equals(warningToken)) break;
                return IrritantSet.ALL;
            }
            case 'b': {
                if (!"boxing".equals(warningToken)) break;
                return IrritantSet.BOXING;
            }
            case 'c': {
                if (!"cast".equals(warningToken)) break;
                return IrritantSet.CAST;
            }
            case 'd': {
                if ("deprecation".equals(warningToken)) {
                    return IrritantSet.DEPRECATION;
                }
                if (!"dep-ann".equals(warningToken)) break;
                return IrritantSet.DEP_ANN;
            }
            case 'e': {
                if (!"exports".equals(warningToken)) break;
                return IrritantSet.API_LEAK;
            }
            case 'f': {
                if ("fallthrough".equals(warningToken)) {
                    return IrritantSet.FALLTHROUGH;
                }
                if (!"finally".equals(warningToken)) break;
                return IrritantSet.FINALLY;
            }
            case 'h': {
                if (!"hiding".equals(warningToken)) break;
                return IrritantSet.HIDING;
            }
            case 'i': {
                if (!"incomplete-switch".equals(warningToken)) break;
                return IrritantSet.INCOMPLETE_SWITCH;
            }
            case 'j': {
                if (!"javadoc".equals(warningToken)) break;
                return IrritantSet.JAVADOC;
            }
            case 'm': {
                if (!"module".equals(warningToken)) break;
                return IrritantSet.MODULE;
            }
            case 'n': {
                if ("nls".equals(warningToken)) {
                    return IrritantSet.NLS;
                }
                if (!"null".equals(warningToken)) break;
                return IrritantSet.NULL;
            }
            case 'p': {
                if (!"preview".equals(warningToken)) break;
                return IrritantSet.PREVIEW;
            }
            case 'r': {
                if ("rawtypes".equals(warningToken)) {
                    return IrritantSet.RAW;
                }
                if ("resource".equals(warningToken)) {
                    return IrritantSet.RESOURCE;
                }
                if ("restriction".equals(warningToken)) {
                    return IrritantSet.RESTRICTION;
                }
                if (!"removal".equals(warningToken)) break;
                return IrritantSet.TERMINAL_DEPRECATION;
            }
            case 's': {
                if ("serial".equals(warningToken)) {
                    return IrritantSet.SERIAL;
                }
                if ("static-access".equals(warningToken)) {
                    return IrritantSet.STATIC_ACCESS;
                }
                if ("static-method".equals(warningToken)) {
                    return IrritantSet.STATIC_METHOD;
                }
                if ("synthetic-access".equals(warningToken)) {
                    return IrritantSet.SYNTHETIC_ACCESS;
                }
                if ("super".equals(warningToken)) {
                    return IrritantSet.SUPER;
                }
                if (!"sync-override".equals(warningToken)) break;
                return IrritantSet.SYNCHRONIZED;
            }
            case 'u': {
                if ("unused".equals(warningToken)) {
                    return IrritantSet.UNUSED;
                }
                if ("unchecked".equals(warningToken)) {
                    return IrritantSet.UNCHECKED;
                }
                if ("unqualified-field-access".equals(warningToken)) {
                    return IrritantSet.UNQUALIFIED_FIELD_ACCESS;
                }
                if (!"unlikely-arg-type".equals(warningToken)) break;
                return IrritantSet.UNLIKELY_ARGUMENT_TYPE;
            }
        }
        return null;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.localVariable", (this.produceDebugAttributes & 4) != 0 ? "generate" : "do not generate");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.lineNumber", (this.produceDebugAttributes & 2) != 0 ? "generate" : "do not generate");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.sourceFile", (this.produceDebugAttributes & 1) != 0 ? "generate" : "do not generate");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.methodParameters", this.produceMethodParameters ? "generate" : "do not generate");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.lambda.genericSignature", this.generateGenericSignatureForLambdaExpressions ? "generate" : "do not generate");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.unusedLocal", this.preserveAllLocalVariables ? "preserve" : "optimize out");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.doc.comment.support", this.docCommentSupport ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.methodWithConstructorName", this.getSeverityString(1));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingPackageDefaultMethod", this.getSeverityString(2));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecation", this.getSeverityString(4));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.terminalDeprecation", this.getSeverityString(0x40800000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecationInDeprecatedCode", this.reportDeprecationInsideDeprecatedCode ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", this.reportDeprecationWhenOverridingDeprecatedMethod ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.hiddenCatchBlock", this.getSeverityString(8));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLocal", this.getSeverityString(16));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameter", this.getSeverityString(32));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedExceptionParameter", this.getSeverityString(0x40040000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedImport", this.getSeverityString(1024));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.syntheticAccessEmulation", this.getSeverityString(128));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noEffectAssignment", this.getSeverityString(8192));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonExternalizedStringLiteral", this.getSeverityString(256));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noImplicitStringConversion", this.getSeverityString(64));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.staticAccessReceiver", this.getSeverityString(2048));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.indirectStaticAccess", this.getSeverityString(0x10000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", this.getSeverityString(16384));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedPrivateMember", this.getSeverityString(32768));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.localVariableHiding", this.getSeverityString(65536));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fieldHiding", this.getSeverityString(131072));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.typeParameterHiding", this.getSeverityString(0x20000400));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.possibleAccidentalBooleanAssignment", this.getSeverityString(262144));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.emptyStatement", this.getSeverityString(524288));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.assertIdentifier", this.getSeverityString(512));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enumIdentifier", this.getSeverityString(0x20000010));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.undocumentedEmptyBlock", this.getSeverityString(0x8000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryTypeCheck", this.getSeverityString(0x4000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryElse", this.getSeverityString(0x20000001));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.autoboxing", this.getSeverityString(0x20000100));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotationSuperInterface", this.getSeverityString(0x20000200));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompleteEnumSwitch", this.getSeverityString(0x20001000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingEnumCaseDespiteDefault", this.reportMissingEnumCaseDespiteDefault ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDefaultCase", this.getSeverityString(0x40008000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadoc", this.getSeverityString(0x2000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsVisibility", this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTags", this.reportInvalidJavadocTags ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportInvalidJavadocTagsDeprecatedRef ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsNotVisibleRef", this.reportInvalidJavadocTagsNotVisibleRef ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTags", this.getSeverityString(0x200000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsVisibility", this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsOverriding", this.reportMissingJavadocTagsOverriding ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsMethodTypeParameters", this.reportMissingJavadocTagsMethodTypeParameters ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocComments", this.getSeverityString(0x100000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagDescription", this.reportMissingJavadocTagDescription);
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocCommentsVisibility", this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocCommentsOverriding", this.reportMissingJavadocCommentsOverriding ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finallyBlockNotCompletingNormally", this.getSeverityString(0x1000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownException", this.getSeverityString(0x800000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", this.reportUnusedDeclaredThrownExceptionWhenOverriding ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", this.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", this.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unqualifiedFieldAccess", this.getSeverityString(0x400000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unavoidableGenericTypeProblems", this.reportUnavoidableGenericTypeProblems ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.uncheckedTypeOperation", this.getSeverityString(0x20000002));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.rawTypeReference", this.getSeverityString(0x20010000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finalParameterBound", this.getSeverityString(0x20000004));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSerialVersion", this.getSeverityString(0x20000008));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.forbiddenReference", this.getSeverityString(0x20000020));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.discouragedReference", this.getSeverityString(0x20004000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.varargsArgumentNeedCast", this.getSeverityString(0x20000040));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingOverrideAnnotation", this.getSeverityString(0x20000800));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", this.reportMissingOverrideAnnotationForInterfaceMethodImplementation ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDeprecatedAnnotation", this.getSeverityString(0x20002000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLabel", this.getSeverityString(0x20020000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", this.getSeverityString(0x21000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.release", "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source", CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.targetPlatform", CompilerOptions.versionFromJdkLevel(this.targetJDK));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fatalOptionalError", this.treatOptionalErrorAsFatal ? "enabled" : "disabled");
        if (this.defaultEncoding != null) {
            optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.encoding", this.defaultEncoding);
        }
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskTags", this.taskTags == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskTags, ',')));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskPriorities", this.taskPriorities == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskPriorities, ',')));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskCaseSensitive", this.isTaskCaseSensitive ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterWhenImplementingAbstract", this.reportUnusedParameterWhenImplementingAbstract ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterWhenOverridingConcrete", this.reportUnusedParameterWhenOverridingConcrete ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterIncludeDocCommentReference", this.reportUnusedParameterIncludeDocCommentReference ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.specialParameterHidingField", this.reportSpecialParameterHidingField ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.maxProblemPerUnit", String.valueOf(this.maxProblemsPerUnit));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.inlineJsrBytecode", this.inlineJsrBytecode ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.shareCommonFinallyBlocks", this.shareCommonFinallyBlocks ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullReference", this.getSeverityString(0x20000080));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentialNullReference", this.getSeverityString(0x20200000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullCheck", this.getSeverityString(0x20400000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressWarnings", this.suppressWarnings ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressOptionalErrors", this.suppressOptionalErrors ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unhandledWarningToken", this.getSeverityString(0x20008000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedWarningToken", this.getSeverityString(0x22000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.parameterAssignment", this.getSeverityString(0x20040000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fallthroughCase", this.getSeverityString(0x20080000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingMethodWithoutSuperInvocation", this.getSeverityString(0x20100000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.generateClassFiles", this.generateClassFiles ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.processAnnotations", this.processAnnotations ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.storeAnnotations", this.storeAnnotations ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.emulateJavacBug8031744", this.emulateJavacBug8031744 ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSuperinterface", this.getSeverityString(0x24000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.comparingIdentical", this.getSeverityString(0x28000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSynchronizedOnInheritedMethod", this.getSeverityString(0x30000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingHashCodeMethod", this.getSeverityString(0x40000001));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deadCode", this.getSeverityString(0x40000002));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deadCodeInTrivialIfStatement", this.reportDeadCodeInTrivialIfStatement ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.tasks", this.getSeverityString(0x40000004));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedObjectAllocation", this.getSeverityString(0x40000008));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.includeNullInfoFromAsserts", this.includeNullInfoFromAsserts ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBeStatic", this.getSeverityString(0x40000010));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBePotentiallyStatic", this.getSeverityString(0x40000020));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSpecificationOfTypeArguments", this.getSeverityString(0x40000040));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unclosedCloseable", this.getSeverityString(0x40000080));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentiallyUnclosedCloseable", this.getSeverityString(0x40000100));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.explicitlyClosedAutoCloseable", this.getSeverityString(0x40000200));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullanalysis", this.isAnnotationBasedNullAnalysisEnabled ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullSpecViolation", this.getSeverityString(0x40000400));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullAnnotationInferenceConflict", this.getSeverityString(0x40000800));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullUncheckedConversion", this.getSeverityString(0x40001000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullAnnotation", this.getSeverityString(0x40002000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullable", String.valueOf(CharOperation.concatWith(this.nullableAnnotationName, '.')));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnull", String.valueOf(CharOperation.concatWith(this.nonNullAnnotationName, '.')));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnullbydefault", String.valueOf(CharOperation.concatWith(this.nonNullByDefaultAnnotationName, '.')));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullable.secondary", this.nameListToString(this.nullableAnnotationSecondaryNames));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnull.secondary", this.nameListToString(this.nonNullAnnotationSecondaryNames));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnullbydefault.secondary", this.nameListToString(this.nonNullByDefaultAnnotationSecondaryNames));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.missingNonNullByDefaultAnnotation", this.getSeverityString(0x40004000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeParameter", this.getSeverityString(0x40010000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.syntacticNullAnalysisForFields", this.enableSyntacticNullAnalysisForFields ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.inheritNullAnnotations", this.inheritNullAnnotations ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullParameterAnnotationDropped", this.getSeverityString(0x40020000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.uninternedIdentityComparison", this.complainOnUninternedIdentityComparison ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", this.getSeverityString(0x40080000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", this.getSeverityString(0x40100000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotatedTypeArgumentToUnannotated", this.getSeverityString(0x50000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyCollectionMethodArgumentType", this.getSeverityString(0x40200000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyCollectionMethodArgumentTypeStrict", this.reportUnlikelyCollectionMethodArgumentTypeStrict ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyEqualsArgumentType", this.getSeverityString(0x40400000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.APILeak", this.getSeverityString(0x41000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unstableAutoModuleName", this.getSeverityString(0x42000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enablePreviewFeatures", this.enablePreviewFeatures ? "enabled" : "disabled");
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportPreviewFeatures", this.getSeverityString(0x44000000));
        optionsMap.put("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressWarningsNotFullyAnalysed", this.getSeverityString(0x48000000));
        return optionsMap;
    }

    public int getSeverity(int irritant) {
        if (this.errorThreshold.isSet(irritant)) {
            if ((irritant & 0xE2000000) == 0x22000000) {
                return 33;
            }
            return this.treatOptionalErrorAsFatal ? 161 : 33;
        }
        if (this.warningThreshold.isSet(irritant)) {
            return 32;
        }
        if (this.infoThreshold.isSet(irritant)) {
            return 1056;
        }
        return 256;
    }

    public String getSeverityString(int irritant) {
        if (this.errorThreshold.isSet(irritant)) {
            return "error";
        }
        if (this.warningThreshold.isSet(irritant)) {
            return "warning";
        }
        if (this.infoThreshold.isSet(irritant)) {
            return "info";
        }
        return "ignore";
    }

    public String getVisibilityString(int level) {
        switch (level & 7) {
            case 1: {
                return "public";
            }
            case 4: {
                return "protected";
            }
            case 2: {
                return "private";
            }
        }
        return "default";
    }

    public boolean isAnyEnabled(IrritantSet irritants) {
        return this.warningThreshold.isAnySet(irritants) || this.errorThreshold.isAnySet(irritants) || this.infoThreshold.isAnySet(irritants);
    }

    public int getIgnoredIrritant(IrritantSet irritants) {
        int[] bits = irritants.getBits();
        int i = 0;
        while (i < 3) {
            int bit = bits[i];
            int b = 0;
            while (b < 29) {
                int single = bit & 1 << b;
                if (!(single <= 0 || (single |= i << 29) == 0x40004000 || this.warningThreshold.isSet(single) || this.errorThreshold.isSet(single) || this.infoThreshold.isSet(single))) {
                    return single;
                }
                ++b;
            }
            ++i;
        }
        return 0;
    }

    protected void resetDefaults() {
        this.errorThreshold = new IrritantSet(IrritantSet.COMPILER_DEFAULT_ERRORS);
        this.warningThreshold = new IrritantSet(IrritantSet.COMPILER_DEFAULT_WARNINGS);
        this.infoThreshold = new IrritantSet(IrritantSet.COMPILER_DEFAULT_INFOS);
        this.produceDebugAttributes = 3;
        this.originalComplianceLevel = 0x300000L;
        this.complianceLevel = 0x300000L;
        this.originalSourceLevel = 0x2F0000L;
        this.sourceLevel = 0x2F0000L;
        this.targetJDK = 0x2E0000L;
        this.defaultEncoding = null;
        this.verbose = Compiler.DEBUG;
        this.produceReferenceInfo = false;
        this.preserveAllLocalVariables = false;
        this.produceMethodParameters = false;
        this.parseLiteralExpressionsAsConstants = true;
        this.maxProblemsPerUnit = 100;
        this.taskTags = null;
        this.taskPriorities = null;
        this.isTaskCaseSensitive = true;
        this.reportDeprecationInsideDeprecatedCode = false;
        this.reportDeprecationWhenOverridingDeprecatedMethod = false;
        this.reportUnusedParameterWhenImplementingAbstract = false;
        this.reportUnusedParameterWhenOverridingConcrete = false;
        this.reportUnusedParameterIncludeDocCommentReference = true;
        this.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
        this.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = true;
        this.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = true;
        this.reportSpecialParameterHidingField = false;
        this.reportUnavoidableGenericTypeProblems = true;
        this.reportInvalidJavadocTagsVisibility = 1;
        this.reportInvalidJavadocTags = false;
        this.reportInvalidJavadocTagsDeprecatedRef = false;
        this.reportInvalidJavadocTagsNotVisibleRef = false;
        this.reportMissingJavadocTagDescription = "return_tag";
        this.reportMissingJavadocTagsVisibility = 1;
        this.reportMissingJavadocTagsOverriding = false;
        this.reportMissingJavadocTagsMethodTypeParameters = false;
        this.reportMissingJavadocCommentsVisibility = 1;
        this.reportMissingJavadocCommentsOverriding = false;
        this.inlineJsrBytecode = false;
        this.shareCommonFinallyBlocks = false;
        this.docCommentSupport = false;
        this.suppressWarnings = true;
        this.suppressOptionalErrors = false;
        this.treatOptionalErrorAsFatal = false;
        this.performMethodsFullRecovery = true;
        this.performStatementsRecovery = true;
        this.storeAnnotations = false;
        this.generateClassFiles = true;
        this.processAnnotations = false;
        this.reportMissingOverrideAnnotationForInterfaceMethodImplementation = true;
        this.reportDeadCodeInTrivialIfStatement = false;
        this.ignoreMethodBodies = false;
        this.ignoreSourceFolderWarningOption = false;
        this.includeNullInfoFromAsserts = false;
        this.isAnnotationBasedNullAnalysisEnabled = false;
        this.nullableAnnotationName = DEFAULT_NULLABLE_ANNOTATION_NAME;
        this.nonNullAnnotationName = DEFAULT_NONNULL_ANNOTATION_NAME;
        this.nonNullByDefaultAnnotationName = DEFAULT_NONNULLBYDEFAULT_ANNOTATION_NAME;
        this.intendedDefaultNonNullness = 0L;
        this.enableSyntacticNullAnalysisForFields = false;
        this.inheritNullAnnotations = false;
        this.analyseResourceLeaks = true;
        this.reportMissingEnumCaseDespiteDefault = false;
        this.complainOnUninternedIdentityComparison = false;
        this.enablePreviewFeatures = false;
        this.enableJdtDebugCompileMode = false;
    }

    public void set(Map<String, String> optionsMap) {
        long level;
        String optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.localVariable");
        if (optionValue != null) {
            if ("generate".equals(optionValue)) {
                this.produceDebugAttributes |= 4;
            } else if ("do not generate".equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFB;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.lineNumber")) != null) {
            if ("generate".equals(optionValue)) {
                this.produceDebugAttributes |= 2;
            } else if ("do not generate".equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFD;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.debug.sourceFile")) != null) {
            if ("generate".equals(optionValue)) {
                this.produceDebugAttributes |= 1;
            } else if ("do not generate".equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFE;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.unusedLocal")) != null) {
            if ("preserve".equals(optionValue)) {
                this.preserveAllLocalVariables = true;
            } else if ("optimize out".equals(optionValue)) {
                this.preserveAllLocalVariables = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecationInDeprecatedCode")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance")) != null && (level = CompilerOptions.versionToJdkLevel(optionValue)) != 0L) {
            this.complianceLevel = this.originalComplianceLevel = level;
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source")) != null && (level = CompilerOptions.versionToJdkLevel(optionValue)) != 0L) {
            this.sourceLevel = this.originalSourceLevel = level;
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.targetPlatform")) != null) {
            level = CompilerOptions.versionToJdkLevel(optionValue);
            if (level != 0L) {
                if (this.enablePreviewFeatures) {
                    level |= 0xFFFFL;
                }
                this.targetJDK = level;
            }
            if (this.targetJDK >= 0x310000L) {
                this.inlineJsrBytecode = true;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.encoding")) != null) {
            this.defaultEncoding = null;
            String stringValue = optionValue;
            if (stringValue.length() > 0) {
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), stringValue);
                    this.defaultEncoding = stringValue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterWhenImplementingAbstract")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterWhenOverridingConcrete")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameterIncludeDocCommentReference")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnusedParameterIncludeDocCommentReference = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnusedParameterIncludeDocCommentReference = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.specialParameterHidingField")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportSpecialParameterHidingField = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportSpecialParameterHidingField = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unavoidableGenericTypeProblems")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportUnavoidableGenericTypeProblems = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportUnavoidableGenericTypeProblems = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deadCodeInTrivialIfStatement")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportDeadCodeInTrivialIfStatement = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportDeadCodeInTrivialIfStatement = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.maxProblemPerUnit")) != null) {
            String stringValue = optionValue;
            try {
                int val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxProblemsPerUnit = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskTags")) != null) {
            String stringValue = optionValue;
            this.taskTags = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskPriorities")) != null) {
            String stringValue = optionValue;
            this.taskPriorities = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.taskCaseSensitive")) != null) {
            if ("enabled".equals(optionValue)) {
                this.isTaskCaseSensitive = true;
            } else if ("disabled".equals(optionValue)) {
                this.isTaskCaseSensitive = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.inlineJsrBytecode")) != null && this.targetJDK < 0x310000L) {
            if ("enabled".equals(optionValue)) {
                this.inlineJsrBytecode = true;
            } else if ("disabled".equals(optionValue)) {
                this.inlineJsrBytecode = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.shareCommonFinallyBlocks")) != null) {
            if ("enabled".equals(optionValue)) {
                this.shareCommonFinallyBlocks = true;
            } else if ("disabled".equals(optionValue)) {
                this.shareCommonFinallyBlocks = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.methodParameters")) != null) {
            if ("generate".equals(optionValue)) {
                this.produceMethodParameters = true;
            } else if ("do not generate".equals(optionValue)) {
                this.produceMethodParameters = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.codegen.lambda.genericSignature")) != null) {
            if ("generate".equals(optionValue)) {
                this.generateGenericSignatureForLambdaExpressions = true;
            } else if ("do not generate".equals(optionValue)) {
                this.generateGenericSignatureForLambdaExpressions = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressWarnings")) != null) {
            if ("enabled".equals(optionValue)) {
                this.suppressWarnings = true;
            } else if ("disabled".equals(optionValue)) {
                this.suppressWarnings = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressOptionalErrors")) != null) {
            if ("enabled".equals(optionValue)) {
                this.suppressOptionalErrors = true;
            } else if ("disabled".equals(optionValue)) {
                this.suppressOptionalErrors = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fatalOptionalError")) != null) {
            if ("enabled".equals(optionValue)) {
                this.treatOptionalErrorAsFatal = true;
            } else if ("disabled".equals(optionValue)) {
                this.treatOptionalErrorAsFatal = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportMissingOverrideAnnotationForInterfaceMethodImplementation = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportMissingOverrideAnnotationForInterfaceMethodImplementation = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.includeNullInfoFromAsserts")) != null) {
            if ("enabled".equals(optionValue)) {
                this.includeNullInfoFromAsserts = true;
            } else if ("disabled".equals(optionValue)) {
                this.includeNullInfoFromAsserts = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.methodWithConstructorName")) != null) {
            this.updateSeverity(1, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingPackageDefaultMethod")) != null) {
            this.updateSeverity(2, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deprecation")) != null) {
            this.updateSeverity(4, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.terminalDeprecation")) != null) {
            this.updateSeverity(0x40800000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.hiddenCatchBlock")) != null) {
            this.updateSeverity(8, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLocal")) != null) {
            this.updateSeverity(16, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedParameter")) != null) {
            this.updateSeverity(32, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedExceptionParameter")) != null) {
            this.updateSeverity(0x40040000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedImport")) != null) {
            this.updateSeverity(1024, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedPrivateMember")) != null) {
            this.updateSeverity(32768, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedDeclaredThrownException")) != null) {
            this.updateSeverity(0x800000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noImplicitStringConversion")) != null) {
            this.updateSeverity(64, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.syntheticAccessEmulation")) != null) {
            this.updateSeverity(128, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.localVariableHiding")) != null) {
            this.updateSeverity(65536, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fieldHiding")) != null) {
            this.updateSeverity(131072, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.typeParameterHiding")) != null) {
            this.updateSeverity(0x20000400, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.possibleAccidentalBooleanAssignment")) != null) {
            this.updateSeverity(262144, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.emptyStatement")) != null) {
            this.updateSeverity(524288, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonExternalizedStringLiteral")) != null) {
            this.updateSeverity(256, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.assertIdentifier")) != null) {
            this.updateSeverity(512, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enumIdentifier")) != null) {
            this.updateSeverity(0x20000010, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.staticAccessReceiver")) != null) {
            this.updateSeverity(2048, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.indirectStaticAccess")) != null) {
            this.updateSeverity(0x10000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompatibleNonInheritedInterfaceMethod")) != null) {
            this.updateSeverity(16384, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.undocumentedEmptyBlock")) != null) {
            this.updateSeverity(0x8000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryTypeCheck")) != null) {
            this.updateSeverity(0x4000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unnecessaryElse")) != null) {
            this.updateSeverity(0x20000001, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finallyBlockNotCompletingNormally")) != null) {
            this.updateSeverity(0x1000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unqualifiedFieldAccess")) != null) {
            this.updateSeverity(0x400000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.noEffectAssignment")) != null) {
            this.updateSeverity(8192, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.uncheckedTypeOperation")) != null) {
            this.updateSeverity(0x20000002, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.rawTypeReference")) != null) {
            this.updateSeverity(0x20010000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.finalParameterBound")) != null) {
            this.updateSeverity(0x20000004, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSerialVersion")) != null) {
            this.updateSeverity(0x20000008, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.forbiddenReference")) != null) {
            this.updateSeverity(0x20000020, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.discouragedReference")) != null) {
            this.updateSeverity(0x20004000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.varargsArgumentNeedCast")) != null) {
            this.updateSeverity(0x20000040, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullReference")) != null) {
            this.updateSeverity(0x20000080, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentialNullReference")) != null) {
            this.updateSeverity(0x20200000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullCheck")) != null) {
            this.updateSeverity(0x20400000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.autoboxing")) != null) {
            this.updateSeverity(0x20000100, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotationSuperInterface")) != null) {
            this.updateSeverity(0x20000200, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingOverrideAnnotation")) != null) {
            this.updateSeverity(0x20000800, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDeprecatedAnnotation")) != null) {
            this.updateSeverity(0x20002000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.incompleteEnumSwitch")) != null) {
            this.updateSeverity(0x20001000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingEnumCaseDespiteDefault")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportMissingEnumCaseDespiteDefault = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportMissingEnumCaseDespiteDefault = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingDefaultCase")) != null) {
            this.updateSeverity(0x40008000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unhandledWarningToken")) != null) {
            this.updateSeverity(0x20008000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedWarningToken")) != null) {
            this.updateSeverity(0x22000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedLabel")) != null) {
            this.updateSeverity(0x20020000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.parameterAssignment")) != null) {
            this.updateSeverity(0x20040000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.fallthroughCase")) != null) {
            this.updateSeverity(0x20080000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.overridingMethodWithoutSuperInvocation")) != null) {
            this.updateSeverity(0x20100000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeArgumentsForMethodInvocation")) != null) {
            this.updateSeverity(0x21000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSuperinterface")) != null) {
            this.updateSeverity(0x24000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.comparingIdentical")) != null) {
            this.updateSeverity(0x28000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingSynchronizedOnInheritedMethod")) != null) {
            this.updateSeverity(0x30000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingHashCodeMethod")) != null) {
            this.updateSeverity(0x40000001, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.deadCode")) != null) {
            this.updateSeverity(0x40000002, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.tasks")) != null) {
            this.updateSeverity(0x40000004, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedObjectAllocation")) != null) {
            this.updateSeverity(0x40000008, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBeStatic")) != null) {
            this.updateSeverity(0x40000010, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportMethodCanBePotentiallyStatic")) != null) {
            this.updateSeverity(0x40000020, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantSpecificationOfTypeArguments")) != null) {
            this.updateSeverity(0x40000040, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unclosedCloseable")) != null) {
            this.updateSeverity(0x40000080, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.potentiallyUnclosedCloseable")) != null) {
            this.updateSeverity(0x40000100, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.explicitlyClosedAutoCloseable")) != null) {
            this.updateSeverity(0x40000200, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unusedTypeParameter")) != null) {
            this.updateSeverity(0x40010000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyCollectionMethodArgumentType")) != null) {
            this.updateSeverity(0x40200000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyCollectionMethodArgumentTypeStrict")) != null) {
            this.reportUnlikelyCollectionMethodArgumentTypeStrict = "enabled".equals(optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unlikelyEqualsArgumentType")) != null) {
            this.updateSeverity(0x40400000, optionValue);
        }
        this.analyseResourceLeaks = this.getSeverity(0x40000080) != 256 || this.getSeverity(0x40000100) != 256 || this.getSeverity(0x40000200) != 256;
        optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.APILeak");
        if (optionValue != null) {
            this.updateSeverity(0x41000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.unstableAutoModuleName")) != null) {
            this.updateSeverity(0x42000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullanalysis")) != null) {
            this.isAnnotationBasedNullAnalysisEnabled = "enabled".equals(optionValue);
        }
        if (this.isAnnotationBasedNullAnalysisEnabled) {
            this.storeAnnotations = true;
            optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullSpecViolation");
            if (optionValue != null) {
                if ("error".equals(optionValue)) {
                    this.errorThreshold.set(0x40000400);
                    this.warningThreshold.clear(0x40000400);
                } else if ("warning".equals(optionValue)) {
                    this.errorThreshold.clear(0x40000400);
                    this.warningThreshold.set(0x40000400);
                }
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullAnnotationInferenceConflict")) != null) {
                this.updateSeverity(0x40000800, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nullUncheckedConversion")) != null) {
                this.updateSeverity(0x40001000, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.redundantNullAnnotation")) != null) {
                this.updateSeverity(0x40002000, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullable")) != null) {
                this.nullableAnnotationName = CharOperation.splitAndTrimOn('.', optionValue.toCharArray());
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnull")) != null) {
                this.nonNullAnnotationName = CharOperation.splitAndTrimOn('.', optionValue.toCharArray());
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnullbydefault")) != null) {
                this.nonNullByDefaultAnnotationName = CharOperation.splitAndTrimOn('.', optionValue.toCharArray());
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nullable.secondary")) != null) {
                this.nullableAnnotationSecondaryNames = this.stringToNameList(optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnull.secondary")) != null) {
                this.nonNullAnnotationSecondaryNames = this.stringToNameList(optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.nonnullbydefault.secondary")) != null) {
                this.nonNullByDefaultAnnotationSecondaryNames = this.stringToNameList(optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.missingNonNullByDefaultAnnotation")) != null) {
                this.updateSeverity(0x40004000, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.syntacticNullAnalysisForFields")) != null) {
                this.enableSyntacticNullAnalysisForFields = "enabled".equals(optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.annotation.inheritNullAnnotations")) != null) {
                this.inheritNullAnnotations = "enabled".equals(optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullParameterAnnotationDropped")) != null) {
                this.updateSeverity(0x40020000, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.annotatedTypeArgumentToUnannotated")) != null) {
                this.updateSeverity(0x50000000, optionValue);
            }
            if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables")) != null) {
                this.updateSeverity(0x40080000, optionValue);
            }
            this.pessimisticNullAnalysisForFreeTypeVariablesEnabled = this.getSeverity(0x40080000) != 256;
            optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation");
            if (optionValue != null) {
                this.updateSeverity(0x40100000, optionValue);
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.doc.comment.support")) != null) {
            if ("enabled".equals(optionValue)) {
                this.docCommentSupport = true;
            } else if ("disabled".equals(optionValue)) {
                this.docCommentSupport = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadoc")) != null) {
            this.updateSeverity(0x2000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsVisibility")) != null) {
            if ("public".equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 1;
            } else if ("protected".equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 4;
            } else if ("default".equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 0;
            } else if ("private".equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTags")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportInvalidJavadocTags = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportInvalidJavadocTags = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsDeprecatedRef")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportInvalidJavadocTagsDeprecatedRef = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportInvalidJavadocTagsDeprecatedRef = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.invalidJavadocTagsNotVisibleRef")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportInvalidJavadocTagsNotVisibleRef = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportInvalidJavadocTagsNotVisibleRef = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTags")) != null) {
            this.updateSeverity(0x200000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsVisibility")) != null) {
            if ("public".equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 1;
            } else if ("protected".equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 4;
            } else if ("default".equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 0;
            } else if ("private".equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsOverriding")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagsMethodTypeParameters")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportMissingJavadocTagsMethodTypeParameters = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportMissingJavadocTagsMethodTypeParameters = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocComments")) != null) {
            this.updateSeverity(0x100000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocTagDescription")) != null) {
            this.reportMissingJavadocTagDescription = optionValue;
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocCommentsVisibility")) != null) {
            if ("public".equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 1;
            } else if ("protected".equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 4;
            } else if ("default".equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 0;
            } else if ("private".equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.missingJavadocCommentsOverriding")) != null) {
            if ("enabled".equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = true;
            } else if ("disabled".equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.generateClassFiles")) != null) {
            if ("enabled".equals(optionValue)) {
                this.generateClassFiles = true;
            } else if ("disabled".equals(optionValue)) {
                this.generateClassFiles = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.processAnnotations")) != null) {
            if ("enabled".equals(optionValue)) {
                this.processAnnotations = true;
                this.storeAnnotations = true;
            } else if ("disabled".equals(optionValue)) {
                this.processAnnotations = false;
                if (!this.isAnnotationBasedNullAnalysisEnabled) {
                    this.storeAnnotations = false;
                }
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.storeAnnotations")) != null) {
            if ("enabled".equals(optionValue)) {
                this.storeAnnotations = true;
            } else if ("disabled".equals(optionValue) && !this.isAnnotationBasedNullAnalysisEnabled && !this.processAnnotations) {
                this.storeAnnotations = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.emulateJavacBug8031744")) != null) {
            if ("enabled".equals(optionValue)) {
                this.emulateJavacBug8031744 = true;
            } else if ("disabled".equals(optionValue)) {
                this.emulateJavacBug8031744 = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.uninternedIdentityComparison")) != null) {
            if ("enabled".equals(optionValue)) {
                this.complainOnUninternedIdentityComparison = true;
            } else if ("disabled".equals(optionValue)) {
                this.complainOnUninternedIdentityComparison = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.enablePreviewFeatures")) != null) {
            if ("enabled".equals(optionValue)) {
                this.enablePreviewFeatures = true;
                if (this.targetJDK != 0L) {
                    this.targetJDK |= 0xFFFFL;
                }
            } else if ("disabled".equals(optionValue)) {
                this.enablePreviewFeatures = false;
            }
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.reportPreviewFeatures")) != null) {
            this.updateSeverity(0x44000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.problem.suppressWarningsNotFullyAnalysed")) != null) {
            this.updateSeverity(0x48000000, optionValue);
        }
        if ((optionValue = optionsMap.get("io.spring.javaformat.eclipse.jdt.jdk11.internal.debug.compile.mode")) != null) {
            if ("enabled".equals(optionValue)) {
                this.enableJdtDebugCompileMode = true;
            } else if ("disabled".equals(optionValue)) {
                this.enableJdtDebugCompileMode = false;
            }
        }
    }

    private String[] stringToNameList(String optionValue) {
        String[] result = optionValue.split(",");
        if (result == null) {
            return NO_STRINGS;
        }
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    String nameListToString(String[] names) {
        if (names == null) {
            return "";
        }
        return String.join((CharSequence)String.valueOf(','), names);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("CompilerOptions:");
        buf.append("\n\t- local variables debug attributes: ").append((this.produceDebugAttributes & 4) != 0 ? "ON" : " OFF");
        buf.append("\n\t- line number debug attributes: ").append((this.produceDebugAttributes & 2) != 0 ? "ON" : " OFF");
        buf.append("\n\t- source debug attributes: ").append((this.produceDebugAttributes & 1) != 0 ? "ON" : " OFF");
        buf.append("\n\t- MethodParameters attributes: ").append(this.produceMethodParameters ? "generate" : "do not generate");
        buf.append("\n\t- Generic signature for lambda expressions: ").append(this.generateGenericSignatureForLambdaExpressions ? "generate" : "do not generate");
        buf.append("\n\t- preserve all local variables: ").append(this.preserveAllLocalVariables ? "ON" : " OFF");
        buf.append("\n\t- method with constructor name: ").append(this.getSeverityString(1));
        buf.append("\n\t- overridden package default method: ").append(this.getSeverityString(2));
        buf.append("\n\t- deprecation: ").append(this.getSeverityString(4));
        buf.append("\n\t- removal: ").append(this.getSeverityString(0x40800000));
        buf.append("\n\t- masked catch block: ").append(this.getSeverityString(8));
        buf.append("\n\t- unused local variable: ").append(this.getSeverityString(16));
        buf.append("\n\t- unused parameter: ").append(this.getSeverityString(32));
        buf.append("\n\t- unused exception parameter: ").append(this.getSeverityString(0x40040000));
        buf.append("\n\t- unused import: ").append(this.getSeverityString(1024));
        buf.append("\n\t- synthetic access emulation: ").append(this.getSeverityString(128));
        buf.append("\n\t- assignment with no effect: ").append(this.getSeverityString(8192));
        buf.append("\n\t- non externalized string: ").append(this.getSeverityString(256));
        buf.append("\n\t- static access receiver: ").append(this.getSeverityString(2048));
        buf.append("\n\t- indirect static access: ").append(this.getSeverityString(0x10000000));
        buf.append("\n\t- incompatible non inherited interface method: ").append(this.getSeverityString(16384));
        buf.append("\n\t- unused private member: ").append(this.getSeverityString(32768));
        buf.append("\n\t- local variable hiding another variable: ").append(this.getSeverityString(65536));
        buf.append("\n\t- field hiding another variable: ").append(this.getSeverityString(131072));
        buf.append("\n\t- type hiding another type: ").append(this.getSeverityString(0x20000400));
        buf.append("\n\t- possible accidental boolean assignment: ").append(this.getSeverityString(262144));
        buf.append("\n\t- superfluous semicolon: ").append(this.getSeverityString(524288));
        buf.append("\n\t- uncommented empty block: ").append(this.getSeverityString(0x8000000));
        buf.append("\n\t- unnecessary type check: ").append(this.getSeverityString(0x4000000));
        buf.append("\n\t- javadoc comment support: ").append(this.docCommentSupport ? "ON" : " OFF");
        buf.append("\n\t\t+ invalid javadoc: ").append(this.getSeverityString(0x2000000));
        buf.append("\n\t\t+ report invalid javadoc tags: ").append(this.reportInvalidJavadocTags ? "enabled" : "disabled");
        buf.append("\n\t\t\t* deprecated references: ").append(this.reportInvalidJavadocTagsDeprecatedRef ? "enabled" : "disabled");
        buf.append("\n\t\t\t* not visible references: ").append(this.reportInvalidJavadocTagsNotVisibleRef ? "enabled" : "disabled");
        buf.append("\n\t\t+ visibility level to report invalid javadoc tags: ").append(this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        buf.append("\n\t\t+ missing javadoc tags: ").append(this.getSeverityString(0x200000));
        buf.append("\n\t\t+ visibility level to report missing javadoc tags: ").append(this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        buf.append("\n\t\t+ report missing javadoc tags for method type parameters: ").append(this.reportMissingJavadocTagsMethodTypeParameters ? "enabled" : "disabled");
        buf.append("\n\t\t+ report missing javadoc tags in overriding methods: ").append(this.reportMissingJavadocTagsOverriding ? "enabled" : "disabled");
        buf.append("\n\t\t+ missing javadoc comments: ").append(this.getSeverityString(0x100000));
        buf.append("\n\t\t+ report missing tag description option: ").append(this.reportMissingJavadocTagDescription);
        buf.append("\n\t\t+ visibility level to report missing javadoc comments: ").append(this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        buf.append("\n\t\t+ report missing javadoc comments in overriding methods: ").append(this.reportMissingJavadocCommentsOverriding ? "enabled" : "disabled");
        buf.append("\n\t- finally block not completing normally: ").append(this.getSeverityString(0x1000000));
        buf.append("\n\t- report unused declared thrown exception: ").append(this.getSeverityString(0x800000));
        buf.append("\n\t- report unused declared thrown exception when overriding: ").append(this.reportUnusedDeclaredThrownExceptionWhenOverriding ? "enabled" : "disabled");
        buf.append("\n\t- report unused declared thrown exception include doc comment reference: ").append(this.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference ? "enabled" : "disabled");
        buf.append("\n\t- report unused declared thrown exception exempt exception and throwable: ").append(this.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable ? "enabled" : "disabled");
        buf.append("\n\t- unnecessary else: ").append(this.getSeverityString(0x20000001));
        buf.append("\n\t- JDK compliance level: " + CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        buf.append("\n\t- JDK source level: " + CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        buf.append("\n\t- JDK target level: " + CompilerOptions.versionFromJdkLevel(this.targetJDK));
        buf.append("\n\t- verbose : ").append(this.verbose ? "ON" : "OFF");
        buf.append("\n\t- produce reference info : ").append(this.produceReferenceInfo ? "ON" : "OFF");
        buf.append("\n\t- parse literal expressions as constants : ").append(this.parseLiteralExpressionsAsConstants ? "ON" : "OFF");
        buf.append("\n\t- encoding : ").append(this.defaultEncoding == null ? "<default>" : this.defaultEncoding);
        buf.append("\n\t- task tags: ").append(this.taskTags == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskTags, ',')));
        buf.append("\n\t- task priorities : ").append(this.taskPriorities == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskPriorities, ',')));
        buf.append("\n\t- report deprecation inside deprecated code : ").append(this.reportDeprecationInsideDeprecatedCode ? "enabled" : "disabled");
        buf.append("\n\t- report deprecation when overriding deprecated method : ").append(this.reportDeprecationWhenOverridingDeprecatedMethod ? "enabled" : "disabled");
        buf.append("\n\t- report unused parameter when implementing abstract method : ").append(this.reportUnusedParameterWhenImplementingAbstract ? "enabled" : "disabled");
        buf.append("\n\t- report unused parameter when overriding concrete method : ").append(this.reportUnusedParameterWhenOverridingConcrete ? "enabled" : "disabled");
        buf.append("\n\t- report unused parameter include doc comment reference : ").append(this.reportUnusedParameterIncludeDocCommentReference ? "enabled" : "disabled");
        buf.append("\n\t- report constructor/setter parameter hiding existing field : ").append(this.reportSpecialParameterHidingField ? "enabled" : "disabled");
        buf.append("\n\t- inline JSR bytecode : ").append(this.inlineJsrBytecode ? "enabled" : "disabled");
        buf.append("\n\t- share common finally blocks : ").append(this.shareCommonFinallyBlocks ? "enabled" : "disabled");
        buf.append("\n\t- report unavoidable generic type problems : ").append(this.reportUnavoidableGenericTypeProblems ? "enabled" : "disabled");
        buf.append("\n\t- unsafe type operation: ").append(this.getSeverityString(0x20000002));
        buf.append("\n\t- unsafe raw type: ").append(this.getSeverityString(0x20010000));
        buf.append("\n\t- final bound for type parameter: ").append(this.getSeverityString(0x20000004));
        buf.append("\n\t- missing serialVersionUID: ").append(this.getSeverityString(0x20000008));
        buf.append("\n\t- varargs argument need cast: ").append(this.getSeverityString(0x20000040));
        buf.append("\n\t- forbidden reference to type with access restriction: ").append(this.getSeverityString(0x20000020));
        buf.append("\n\t- discouraged reference to type with access restriction: ").append(this.getSeverityString(0x20004000));
        buf.append("\n\t- null reference: ").append(this.getSeverityString(0x20000080));
        buf.append("\n\t- potential null reference: ").append(this.getSeverityString(0x20200000));
        buf.append("\n\t- redundant null check: ").append(this.getSeverityString(0x20400000));
        buf.append("\n\t- autoboxing: ").append(this.getSeverityString(0x20000100));
        buf.append("\n\t- annotation super interface: ").append(this.getSeverityString(0x20000200));
        buf.append("\n\t- missing @Override annotation: ").append(this.getSeverityString(0x20000800));
        buf.append("\n\t- missing @Override annotation for interface method implementation: ").append(this.reportMissingOverrideAnnotationForInterfaceMethodImplementation ? "enabled" : "disabled");
        buf.append("\n\t- missing @Deprecated annotation: ").append(this.getSeverityString(0x20002000));
        buf.append("\n\t- incomplete enum switch: ").append(this.getSeverityString(0x20001000));
        buf.append("\n\t- raise null related warnings for variables tainted in assert statements: ").append(this.includeNullInfoFromAsserts ? "enabled" : "disabled");
        buf.append("\n\t- suppress warnings: ").append(this.suppressWarnings ? "enabled" : "disabled");
        buf.append("\n\t- suppress optional errors: ").append(this.suppressOptionalErrors ? "enabled" : "disabled");
        buf.append("\n\t- unhandled warning token: ").append(this.getSeverityString(0x20008000));
        buf.append("\n\t- unused warning token: ").append(this.getSeverityString(0x22000000));
        buf.append("\n\t- unused label: ").append(this.getSeverityString(0x20020000));
        buf.append("\n\t- treat optional error as fatal: ").append(this.treatOptionalErrorAsFatal ? "enabled" : "disabled");
        buf.append("\n\t- parameter assignment: ").append(this.getSeverityString(0x20040000));
        buf.append("\n\t- generate class files: ").append(this.generateClassFiles ? "enabled" : "disabled");
        buf.append("\n\t- process annotations: ").append(this.processAnnotations ? "enabled" : "disabled");
        buf.append("\n\t- unused type arguments for method/constructor invocation: ").append(this.getSeverityString(0x21000000));
        buf.append("\n\t- redundant superinterface: ").append(this.getSeverityString(0x24000000));
        buf.append("\n\t- comparing identical expr: ").append(this.getSeverityString(0x28000000));
        buf.append("\n\t- missing synchronized on inherited method: ").append(this.getSeverityString(0x30000000));
        buf.append("\n\t- should implement hashCode() method: ").append(this.getSeverityString(0x40000001));
        buf.append("\n\t- dead code: ").append(this.getSeverityString(0x40000002));
        buf.append("\n\t- dead code in trivial if statement: ").append(this.reportDeadCodeInTrivialIfStatement ? "enabled" : "disabled");
        buf.append("\n\t- tasks severity: ").append(this.getSeverityString(0x40000004));
        buf.append("\n\t- unused object allocation: ").append(this.getSeverityString(0x40000008));
        buf.append("\n\t- method can be static: ").append(this.getSeverityString(0x40000010));
        buf.append("\n\t- method can be potentially static: ").append(this.getSeverityString(0x40000020));
        buf.append("\n\t- redundant specification of type arguments: ").append(this.getSeverityString(0x40000040));
        buf.append("\n\t- resource is not closed: ").append(this.getSeverityString(0x40000080));
        buf.append("\n\t- resource may not be closed: ").append(this.getSeverityString(0x40000100));
        buf.append("\n\t- resource should be handled by try-with-resources: ").append(this.getSeverityString(0x40000200));
        buf.append("\n\t- Unused Type Parameter: ").append(this.getSeverityString(0x40010000));
        buf.append("\n\t- pessimistic null analysis for free type variables: ").append(this.getSeverityString(0x40080000));
        buf.append("\n\t- report unsafe nonnull return from legacy method: ").append(this.getSeverityString(0x40100000));
        buf.append("\n\t- unlikely argument type for collection methods: ").append(this.getSeverityString(0x40200000));
        buf.append("\n\t- unlikely argument type for collection methods, strict check against expected type: ").append(this.reportUnlikelyCollectionMethodArgumentTypeStrict ? "enabled" : "disabled");
        buf.append("\n\t- unlikely argument types for equals(): ").append(this.getSeverityString(0x40400000));
        buf.append("\n\t- API leak: ").append(this.getSeverityString(0x41000000));
        buf.append("\n\t- unstable auto module name: ").append(this.getSeverityString(0x42000000));
        buf.append("\n\t- SuppressWarnings not fully analysed: ").append(this.getSeverityString(0x48000000));
        return buf.toString();
    }

    protected void updateSeverity(int irritant, Object severityString) {
        if ("error".equals(severityString)) {
            this.errorThreshold.set(irritant);
            this.warningThreshold.clear(irritant);
            this.infoThreshold.clear(irritant);
        } else if ("warning".equals(severityString)) {
            this.errorThreshold.clear(irritant);
            this.warningThreshold.set(irritant);
            this.infoThreshold.clear(irritant);
        } else if ("info".equals(severityString)) {
            this.errorThreshold.clear(irritant);
            this.warningThreshold.clear(irritant);
            this.infoThreshold.set(irritant);
        } else if ("ignore".equals(severityString)) {
            this.errorThreshold.clear(irritant);
            this.warningThreshold.clear(irritant);
            this.infoThreshold.clear(irritant);
        }
    }

    public boolean usesNullTypeAnnotations() {
        if (this.useNullTypeAnnotations != null) {
            return this.useNullTypeAnnotations;
        }
        return this.isAnnotationBasedNullAnalysisEnabled && this.sourceLevel >= 0x340000L;
    }
}

