/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.AnnotationBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.LookupEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.UnresolvedReferenceBinding;

public class AnnotationHolder {
    AnnotationBinding[] annotations;

    static AnnotationHolder storeAnnotations(AnnotationBinding[] annotations, AnnotationBinding[][] parameterAnnotations, Object defaultValue, LookupEnvironment optionalEnv) {
        if (parameterAnnotations != null) {
            boolean isEmpty = true;
            int i = parameterAnnotations.length;
            while (isEmpty && --i >= 0) {
                if (parameterAnnotations[i] == null || parameterAnnotations[i].length <= 0) continue;
                isEmpty = false;
            }
            if (isEmpty) {
                parameterAnnotations = null;
            }
        }
        if (defaultValue != null) {
            return new AnnotationMethodHolder(annotations, parameterAnnotations, defaultValue, optionalEnv);
        }
        if (parameterAnnotations != null) {
            return new MethodHolder(annotations, parameterAnnotations);
        }
        return new AnnotationHolder().setAnnotations(annotations);
    }

    AnnotationBinding[] getAnnotations() {
        return this.annotations;
    }

    Object getDefaultValue() {
        return null;
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        return null;
    }

    AnnotationHolder setAnnotations(AnnotationBinding[] annotations) {
        this.annotations = annotations;
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        return this;
    }

    static class AnnotationMethodHolder
    extends MethodHolder {
        Object defaultValue;
        LookupEnvironment env;

        AnnotationMethodHolder(AnnotationBinding[] annotations, AnnotationBinding[][] parameterAnnotations, Object defaultValue, LookupEnvironment optionalEnv) {
            super(annotations, parameterAnnotations);
            this.defaultValue = defaultValue;
            this.env = optionalEnv;
        }

        @Override
        Object getDefaultValue() {
            if (this.defaultValue instanceof UnresolvedReferenceBinding) {
                if (this.env == null) {
                    throw new IllegalStateException();
                }
                this.defaultValue = ((UnresolvedReferenceBinding)this.defaultValue).resolve(this.env, false);
            }
            return this.defaultValue;
        }
    }

    static class MethodHolder
    extends AnnotationHolder {
        AnnotationBinding[][] parameterAnnotations;

        MethodHolder(AnnotationBinding[] annotations, AnnotationBinding[][] parameterAnnotations) {
            this.setAnnotations(annotations);
            this.parameterAnnotations = parameterAnnotations;
        }

        @Override
        public AnnotationBinding[][] getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        @Override
        AnnotationHolder setAnnotations(AnnotationBinding[] annotations) {
            this.annotations = annotations == null || annotations.length == 0 ? Binding.NO_ANNOTATIONS : annotations;
            return this;
        }
    }
}

