/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.CharArrayHashMap;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.CharArrayMap;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.CharArrayMapper;
import java.util.Collection;

public class CharDelegateMap<P>
implements CharArrayMapper<P> {
    CharArrayMap<P> smallDelegate;
    CharArrayHashMap<P> bigDelegate;

    private CharArrayMapper<P> getDelegate() {
        return this.smallDelegate == null ? this.bigDelegate : this.smallDelegate;
    }

    public CharDelegateMap(int estimatedSize) {
        if (estimatedSize > 5) {
            this.bigDelegate = new CharArrayHashMap(estimatedSize);
        } else {
            this.smallDelegate = new CharArrayMap(estimatedSize);
        }
    }

    @Override
    public P get(char[] key) {
        if (this.smallDelegate != null) {
            return this.smallDelegate.get(key);
        }
        return this.bigDelegate.get(key);
    }

    @Override
    public P put(char[] key, P value) {
        if (this.smallDelegate != null) {
            P v = this.smallDelegate.put(key, value);
            if (this.smallDelegate.size() > 5) {
                this.toBigMap();
            }
            return v;
        }
        return this.bigDelegate.put(key, value);
    }

    private void toBigMap() {
        this.bigDelegate = new CharArrayHashMap(this.smallDelegate.size());
        this.smallDelegate.transferTo(this.bigDelegate);
        this.smallDelegate = null;
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }

    @Override
    public Collection<char[]> keys() {
        return this.getDelegate().keys();
    }
}

