/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IBuffer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IOrdinaryClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IParent;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ISourceRange;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaConventions;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.SourceRange;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.JRTUtil;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClassFileInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JarPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Openable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public abstract class AbstractClassFile
extends Openable
implements IClassFile,
SuffixConstants {
    protected String name;

    protected AbstractClassFile(PackageFragment parent, String nameWithoutExtension) {
        super(parent);
        this.name = nameWithoutExtension;
    }

    @Override
    protected Object createElementInfo() {
        return new ClassFileInfo();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AbstractClassFile)) {
            return false;
        }
        AbstractClassFile other = (AbstractClassFile)o;
        return this.name.equals(other.name) && this.getParent().equals(other.getParent());
    }

    protected IJavaElement findElement(IJavaElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }

    protected byte[] getClassFileContent(JarPackageFragmentRoot root, String className) throws CoreException, IOException {
        byte[] contents = null;
        String rootPath = root.getPath().toOSString();
        if (io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util.isJrt(rootPath)) {
            contents = JRTUtil.getClassfileContent(new File(rootPath), className, root.getElementName());
        } else {
            ZipFile zip = root.getJar();
            try {
                ZipEntry ze = zip.getEntry(className);
                if (ze != null) {
                    contents = io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        }
        if (contents == null && Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        return contents;
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        IStatus status = this.validateClassFile();
        if (status.isOK()) {
            return super.getBuffer();
        }
        switch (status.getCode()) {
            case 967: 
            case 1006: {
                return null;
            }
        }
        throw new JavaModelException(status);
    }

    @Override
    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)this.getParent().getParent());
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAtConsideringSibling(int position) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)((Object)this.getParent());
        PackageFragmentRoot root = (PackageFragmentRoot)fragment.getAncestor(3);
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        int index = this.name.indexOf(36);
        int prefixLength = index < 0 ? this.name.length() : index;
        IType type = null;
        int start = -1;
        int end = Integer.MAX_VALUE;
        IJavaElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IOrdinaryClassFile) {
                int childPrefixLength;
                IOrdinaryClassFile classFile = (IOrdinaryClassFile)children[i];
                String childName = classFile.getElementName();
                int childIndex = childName.indexOf(36);
                int n = childPrefixLength = childIndex < 0 ? childName.indexOf(46) : childIndex;
                if (prefixLength == childPrefixLength && this.name.regionMatches(0, childName, 0, prefixLength)) {
                    classFile.getBuffer();
                    SourceRange range = mapper.getSourceRange(classFile.getType());
                    if (range != SourceMapper.UNKNOWN_RANGE) {
                        int newStart = range.getOffset();
                        int newEnd = newStart + range.getLength() - 1;
                        if (newStart > start && newEnd < end && newStart <= position && newEnd >= position) {
                            type = classFile.getType();
                            start = newStart;
                            end = newEnd;
                        }
                    }
                }
            }
            ++i;
        }
        if (type != null) {
            return this.findElement(type, position, mapper);
        }
        return null;
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.name) + ".class";
    }

    @Override
    public int getElementType() {
        return 6;
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        return ((IContainer)((Openable)this.getParent()).resource(root)).getFile((IPath)new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.name.hashCode(), this.getParent().hashCode());
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        JavaProject project = this.getJavaProject();
        return JavaConventions.validateClassFileName(this.getElementName(), project.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source", true), project.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", true));
    }

    @Override
    protected IStatus validateExistence(IResource underlyingResource) {
        IStatus status = this.validateClassFile();
        if (!status.isOK()) {
            return status;
        }
        if (underlyingResource != null) {
            PackageFragmentRoot root;
            if (!underlyingResource.isAccessible()) {
                return this.newDoesNotExistStatus();
            }
            if (underlyingResource instanceof IFolder && (root = this.getPackageFragmentRoot()).isArchive()) {
                return root.newDoesNotExistStatus();
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }
}

