/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IProblemRequestor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElementDelta;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class BecomeWorkingCopyOperation
extends JavaModelOperation {
    IProblemRequestor problemRequestor;

    public BecomeWorkingCopyOperation(CompilationUnit workingCopy, IProblemRequestor problemRequestor) {
        super(new IJavaElement[]{workingCopy});
        this.problemRequestor = problemRequestor;
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        CompilationUnit workingCopy = this.getWorkingCopy();
        JavaModelManager.getJavaModelManager().getPerWorkingCopyInfo(workingCopy, true, true, this.problemRequestor);
        workingCopy.openWhenClosed(workingCopy.createElementInfo(), true, (IProgressMonitor)this.progressMonitor);
        if (!workingCopy.isPrimary()) {
            JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
            delta.added(workingCopy);
            this.addDelta(delta);
        } else {
            IResource resource = workingCopy.getResource();
            if (resource != null) {
                if (resource.isAccessible()) {
                    JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                    delta.changed(workingCopy, 65536);
                    this.addDelta(delta);
                } else {
                    JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                    delta.added(workingCopy, 65536);
                    this.addDelta(delta);
                }
            }
        }
        this.resultElements = new IJavaElement[]{workingCopy};
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

