/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.Flags;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IField;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryField;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryMember;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavadocContents;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ResolvedBinaryField;
import org.eclipse.core.runtime.IProgressMonitor;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryField)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        IBinaryAnnotation[] binaryAnnotations = info.getAnnotations();
        return this.getAnnotations(binaryAnnotations, info.getTagBits());
    }

    @Override
    public int getFlags() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    public int getElementType() {
        return 8;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '^';
    }

    @Override
    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    public String getTypeSignature() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature != null) {
            return new String(ClassFile.translatedName(genericSignature));
        }
        return new String(ClassFile.translatedName(info.getTypeName()));
    }

    @Override
    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedBinaryField resolvedHandle = new ResolvedBinaryField(this.getParent(), this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        JavadocContents javadocContents = ((BinaryType)this.getDeclaringType()).getJavadocContents(monitor);
        if (javadocContents == null) {
            return null;
        }
        return javadocContents.getFieldDoc(this);
    }

    @Override
    public boolean isRecordComponent() throws JavaModelException {
        return false;
    }
}

