/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ISourceRange;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.NamedMember;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.util.ArrayList;

public abstract class BinaryMember
extends NamedMember {
    protected BinaryMember(JavaElement parent, String name) {
        super(parent, name);
    }

    protected IAnnotation[] getAnnotations(IBinaryAnnotation[] binaryAnnotations, long tagBits) {
        IAnnotation[] standardAnnotations = this.getStandardAnnotations(tagBits);
        if (binaryAnnotations == null) {
            return standardAnnotations;
        }
        int length = binaryAnnotations.length;
        int standardLength = standardAnnotations.length;
        int fullLength = length + standardLength;
        if (fullLength == 0) {
            return Annotation.NO_ANNOTATIONS;
        }
        IAnnotation[] annotations = new IAnnotation[fullLength];
        int i = 0;
        while (i < length) {
            annotations[i] = Util.getAnnotation(this, binaryAnnotations[i], null);
            ++i;
        }
        System.arraycopy(standardAnnotations, 0, annotations, length, standardLength);
        return annotations;
    }

    private IAnnotation getAnnotation(char[][] annotationName) {
        return new Annotation(this, new String(CharOperation.concatWith(annotationName, '.')));
    }

    protected IAnnotation[] getStandardAnnotations(long tagBits) {
        if ((tagBits & 0x77FFFFF840000000L) == 0L) {
            return Annotation.NO_ANNOTATIONS;
        }
        ArrayList<IAnnotation> annotations = new ArrayList<IAnnotation>();
        if ((tagBits & 0x300000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_RETENTION));
        }
        if ((tagBits & 0x400000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_DEPRECATED));
        }
        if ((tagBits & 0x800000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED));
        }
        if ((tagBits & 0x1000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_INHERITED));
        }
        if ((tagBits & 0x10000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE));
        }
        if ((tagBits & 0x8000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_SAFEVARARGS));
        }
        return annotations.toArray(new IAnnotation[annotations.size()]);
    }

    public String getKey() {
        try {
            return this.getKey(false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public abstract String getKey(boolean var1) throws JavaModelException;

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            this.getClassFile().getBuffer();
            return mapper.getNameRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            this.getClassFile().getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public boolean isBinary() {
        return true;
    }
}

