/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IBuffer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Openable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.OverflowingLRUCache;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.LRUCache;
import java.util.ArrayList;
import java.util.List;

public class BufferCache<K>
extends OverflowingLRUCache<K, IBuffer> {
    private ThreadLocal<List<IBuffer>> buffersToClose = new ThreadLocal();

    public BufferCache(int size) {
        super(size);
    }

    public BufferCache(int size, int overflow) {
        super(size, overflow);
    }

    @Override
    protected boolean close(LRUCache.LRUCacheEntry<K, IBuffer> entry) {
        IBuffer buffer = (IBuffer)entry.value;
        if (!((Openable)buffer.getOwner()).canBufferBeRemovedFromCache(buffer)) {
            return false;
        }
        List<IBuffer> buffers = this.buffersToClose.get();
        if (buffers == null) {
            buffers = new ArrayList<IBuffer>();
            this.buffersToClose.set(buffers);
        }
        buffers.add(buffer);
        return true;
    }

    void closeBuffers() {
        List<IBuffer> buffers = this.buffersToClose.get();
        if (buffers == null) {
            return;
        }
        this.buffersToClose.remove();
        int i = 0;
        int length = buffers.size();
        while (i < length) {
            buffers.get(i).close();
            ++i;
        }
    }

    @Override
    protected LRUCache<K, IBuffer> newInstance(int size, int newOverflow) {
        return new BufferCache<K>(size, newOverflow);
    }
}

