/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IBuffer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IBufferFactory;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IOpenable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Buffer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BufferCache;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.NullBuffer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Openable;
import java.text.NumberFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class BufferManager {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected static boolean VERBOSE;
    private BufferCache<IOpenable> openBuffers = new BufferCache(60);
    protected IBufferFactory defaultBufferFactory = new IBufferFactory(){

        @Override
        public IBuffer createBuffer(IOpenable owner) {
            return BufferManager.createBuffer(owner);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Adding buffer for " + owner);
        }
        BufferCache<IOpenable> bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            this.openBuffers.put(buffer.getOwner(), buffer);
        }
        this.openBuffers.closeBuffers();
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }

    public static IBuffer createBuffer(IOpenable owner) {
        JavaElement element = (JavaElement)((Object)owner);
        IResource resource = element.resource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public static IBuffer createNullBuffer(IOpenable owner) {
        JavaElement element = (JavaElement)((Object)owner);
        IResource resource = element.resource();
        return new NullBuffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuffer getBuffer(IOpenable owner) {
        BufferCache<IOpenable> bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            return (IBuffer)this.openBuffers.get(owner);
        }
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this.defaultBufferFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<IBuffer> getOpenBuffers() {
        Enumeration<IBuffer> result;
        BufferCache<IOpenable> bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            this.openBuffers.shrink();
            result = this.openBuffers.elements();
        }
        this.openBuffers.closeBuffers();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Removing buffer for " + owner);
        }
        BufferCache<IOpenable> bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            this.openBuffers.remove(buffer.getOwner());
        }
        this.openBuffers.closeBuffers();
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }
}

