/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathChange;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathValidation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.DeltaProcessingState;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ExternalFolderChange;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElementDelta;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(ClasspathChange change, boolean refreshExternalFolder) throws JavaModelException {
        JavaProject project = change.project;
        project.resetCaches();
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(project).validate();
            }
            project.getProject().clearCachedDynamicReferences();
            new ExternalFolderChange(project, change.oldResolvedClasspath).updateExternalFoldersIfNecessary(refreshExternalFolder, null);
        } else {
            DeltaProcessingState state = JavaModelManager.getDeltaState();
            JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
            int result = change.generateDelta(delta, true);
            if ((result & 1) != 0) {
                this.addDelta(delta);
                state.rootsAreStale = true;
                change.requestIndexing();
                state.addClasspathValidation(project);
            }
            if ((result & 2) != 0) {
                project.getProject().clearCachedDynamicReferences();
                state.addProjectReferenceChange(project);
            }
            if ((result & 4) != 0) {
                state.addExternalFolderChange(project, change.oldResolvedClasspath);
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

