/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IBuffer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ToolFactory;
import io.spring.javaformat.eclipse.jdt.jdk11.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.AbstractClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BufferManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.DefaultWorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ModularClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Disassembler;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public AbstractClassFile classFile;

    public ClassFileWorkingCopy(AbstractClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), ClassFileWorkingCopy.sourceFileName(classFile), owner);
        this.classFile = classFile;
    }

    private static String sourceFileName(AbstractClassFile classFile) {
        if (classFile instanceof ModularClassFile) {
            return "module-info.java";
        }
        return ((BinaryType)((ClassFile)classFile).getType()).getSourceFileName(null);
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    @Override
    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException javaModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IPath getPath() {
        return this.classFile.getPath();
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = BufferManager.createBuffer(this);
        IBuffer classFileBuffer = this.classFile.getBuffer();
        if (classFileBuffer != null) {
            buffer.setContents(classFileBuffer.getCharacters());
        } else {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
            Disassembler disassembler = new Disassembler();
            String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
            buffer.setContents(contents);
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }
}

