/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.Flags;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaConventions;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Name;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.StructuralPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.rewrite.ASTRewrite;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CreateElementInCUOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Messages;
import java.util.Iterator;

public class CreateImportOperation
extends CreateElementInCUOperation {
    protected String importName;
    protected int flags;

    public CreateImportOperation(String importName, ICompilationUnit parentElement, int flags) {
        super(parentElement);
        this.importName = importName;
        this.flags = flags;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return CompilationUnit.IMPORTS_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        Iterator imports = this.cuAST.imports().iterator();
        boolean onDemand = this.importName.endsWith(".*");
        String importActualName = this.importName;
        if (onDemand) {
            importActualName = this.importName.substring(0, this.importName.length() - 2);
        }
        while (imports.hasNext()) {
            ImportDeclaration importDeclaration = (ImportDeclaration)imports.next();
            if (!importActualName.equals(importDeclaration.getName().getFullyQualifiedName()) || onDemand != importDeclaration.isOnDemand() || Flags.isStatic(this.flags) != importDeclaration.isStatic()) continue;
            this.creationOccurred = false;
            return null;
        }
        AST ast = this.cuAST.getAST();
        ImportDeclaration importDeclaration = ast.newImportDeclaration();
        importDeclaration.setStatic(Flags.isStatic(this.flags));
        char[][] charFragments = CharOperation.splitOn('.', importActualName.toCharArray(), 0, importActualName.length());
        int length = charFragments.length;
        String[] strFragments = new String[length];
        int i = 0;
        while (i < length) {
            strFragments[i] = String.valueOf(charFragments[i]);
            ++i;
        }
        Name name = ast.newName(strFragments);
        importDeclaration.setName(name);
        if (onDemand) {
            importDeclaration.setOnDemand(true);
        }
        return importDeclaration;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getImport(this.importName);
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createImportsProgress;
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createAfter(imports[imports.length - 1]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
            IJavaElement[] children = cu.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].getElementType() == 11) {
                    this.createAfter(children[i]);
                    return;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validateImportDeclaration(this.importName, project.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source", true), project.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.importName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

