/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IElementChangedListener;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathChange;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathValidation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.DeltaProcessor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ExternalFolderChange;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModel;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int[] preResourceChangeEventMasks = new int[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal<DeltaProcessor> deltaProcessors = new ThreadLocal();
    public Map<IPath, DeltaProcessor.RootInfo> roots = new LinkedHashMap<IPath, DeltaProcessor.RootInfo>();
    public Map<IPath, List<DeltaProcessor.RootInfo>> otherRoots = new HashMap<IPath, List<DeltaProcessor.RootInfo>>();
    public Map<IPath, DeltaProcessor.RootInfo> oldRoots = new LinkedHashMap<IPath, DeltaProcessor.RootInfo>();
    public Map<IPath, List<DeltaProcessor.RootInfo>> oldOtherRoots = new HashMap<IPath, List<DeltaProcessor.RootInfo>>();
    public Map<IPath, IPath> sourceAttachments = new HashMap<IPath, IPath>();
    public Map<IJavaProject, IJavaProject[]> projectDependencies = new HashMap<IJavaProject, IJavaProject[]>();
    public boolean rootsAreStale = true;
    private Set<Thread> initializingThreads = Collections.synchronizedSet(new HashSet());
    public Hashtable<IPath, Long> externalTimeStamps;
    private Map<IProject, ClasspathChange> classpathChanges = new LinkedHashMap<IProject, ClasspathChange>();
    private Map<JavaProject, ClasspathValidation> classpathValidations = new LinkedHashMap<JavaProject, ClasspathValidation>();
    private Set<IJavaProject> projectReferenceChanges = new LinkedHashSet<IJavaProject>();
    private Map<JavaProject, ExternalFolderChange> externalFolderChanges = new LinkedHashMap<JavaProject, ExternalFolderChange>();
    private Set<String> javaProjectNamesCache;
    private Set<IJavaElement> externalElementsToRefresh;
    private final Object mutex = new Object();

    public synchronized void addForRefresh(IJavaElement externalElement) {
        if (this.externalElementsToRefresh == null) {
            this.externalElementsToRefresh = new LinkedHashSet<IJavaElement>();
        }
        this.externalElementsToRefresh.add(externalElement);
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, JavaModelManager.getJavaModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClasspathChange addClasspathChange(IProject project, IClasspathEntry[] oldRawClasspath, IPath oldOutputLocation, IClasspathEntry[] oldResolvedClasspath) {
        Object object = this.mutex;
        synchronized (object) {
            ClasspathChange change = this.classpathChanges.get(project);
            if (change == null) {
                change = new ClasspathChange((JavaProject)JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject((IResource)project), oldRawClasspath, oldOutputLocation, oldResolvedClasspath);
                this.classpathChanges.put(project, change);
            } else {
                if (change.oldRawClasspath == null) {
                    change.oldRawClasspath = oldRawClasspath;
                }
                if (change.oldOutputLocation == null) {
                    change.oldOutputLocation = oldOutputLocation;
                }
                if (change.oldResolvedClasspath == null) {
                    change.oldResolvedClasspath = oldResolvedClasspath;
                }
            }
            return change;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClasspathChange getClasspathChange(IProject project) {
        Object object = this.mutex;
        synchronized (object) {
            return this.classpathChanges.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IProject, ClasspathChange> removeAllClasspathChanges() {
        Object object = this.mutex;
        synchronized (object) {
            Map<IProject, ClasspathChange> result = this.classpathChanges;
            this.classpathChanges = new LinkedHashMap<IProject, ClasspathChange>(result.size());
            return result;
        }
    }

    public synchronized ClasspathValidation addClasspathValidation(JavaProject project) {
        ClasspathValidation validation = this.classpathValidations.get(project);
        if (validation == null) {
            validation = new ClasspathValidation(project);
            this.classpathValidations.put(project, validation);
        }
        return validation;
    }

    public synchronized void addExternalFolderChange(JavaProject project, IClasspathEntry[] oldResolvedClasspath) {
        ExternalFolderChange change = this.externalFolderChanges.get(project);
        if (change == null) {
            change = new ExternalFolderChange(project, oldResolvedClasspath);
            this.externalFolderChanges.put(project, change);
        }
    }

    public synchronized void addProjectReferenceChange(IJavaProject project) {
        this.projectReferenceChanges.add(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeRoots(boolean initAfterLoad) {
        RootInfos rootInfos = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                JavaModelManager.getJavaModelManager().forceBatchInitializations(initAfterLoad);
                rootInfos = this.getRootInfos(false);
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (this.rootsAreStale && rootInfos != null) {
                this.roots = rootInfos.roots;
                this.otherRoots = rootInfos.otherRoots;
                this.sourceAttachments = rootInfos.sourceAttachments;
                this.projectDependencies = rootInfos.projectDependencies;
                this.rootsAreStale = false;
            }
        }
    }

    private RootInfos getRootInfos(boolean usePreviousSession) {
        IJavaProject[] projects;
        RootInfos ri = new RootInfos();
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        try {
            projects = model.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            block19: {
                IClasspathEntry[] classpath;
                JavaProject project = (JavaProject)projects[i];
                try {
                    if (usePreviousSession) {
                        JavaModelManager.PerProjectInfo perProjectInfo = project.getPerProjectInfo();
                        project.resolveClasspath(perProjectInfo, true, false);
                        classpath = perProjectInfo.resolvedClasspath;
                    } else {
                        classpath = project.getResolvedClasspath();
                    }
                }
                catch (JavaModelException javaModelException) {
                    break block19;
                }
                int j = 0;
                int classpathLength = classpath.length;
                while (j < classpathLength) {
                    IClasspathEntry entry = classpath[j];
                    if (entry.getEntryKind() == 2) {
                        IJavaProject key = model.getJavaProject(entry.getPath().segment(0));
                        IJavaProject[] dependents = ri.projectDependencies.get(key);
                        if (dependents == null) {
                            dependents = new IJavaProject[]{project};
                        } else {
                            int dependentsLength = dependents.length;
                            IJavaProject[] iJavaProjectArray = dependents;
                            dependents = new IJavaProject[dependentsLength + 1];
                            System.arraycopy(iJavaProjectArray, 0, dependents, 0, dependentsLength);
                            dependents[dependentsLength] = project;
                        }
                        ri.projectDependencies.put(key, dependents);
                    } else {
                        IPath path = entry.getPath();
                        if (ri.roots.get(path) == null) {
                            ri.roots.put(path, new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry));
                        } else {
                            List<DeltaProcessor.RootInfo> rootList = ri.otherRoots.get(path);
                            if (rootList == null) {
                                rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                ri.otherRoots.put(path, rootList);
                            }
                            rootList.add(new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry));
                        }
                        if (entry.getEntryKind() == 1) {
                            int index;
                            String propertyString = null;
                            try {
                                propertyString = Util.getSourceAttachmentProperty(path);
                            }
                            catch (JavaModelException e) {
                                e.printStackTrace();
                            }
                            Object sourceAttachmentPath = propertyString != null ? ((index = propertyString.lastIndexOf(42)) < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index))) : entry.getSourceAttachmentPath();
                            if (sourceAttachmentPath != null) {
                                ri.sourceAttachments.put((IPath)sourceAttachmentPath, path);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ri;
    }

    public synchronized ClasspathValidation[] removeClasspathValidations() {
        int length = this.classpathValidations.size();
        if (length == 0) {
            return null;
        }
        ClasspathValidation[] validations = new ClasspathValidation[length];
        this.classpathValidations.values().toArray(validations);
        this.classpathValidations.clear();
        return validations;
    }

    public synchronized ExternalFolderChange[] removeExternalFolderChanges() {
        int length = this.externalFolderChanges.size();
        if (length == 0) {
            return null;
        }
        ExternalFolderChange[] updates = new ExternalFolderChange[length];
        this.externalFolderChanges.values().toArray(updates);
        this.externalFolderChanges.clear();
        return updates;
    }

    public synchronized Set<IJavaProject> removeProjectReferenceChanges() {
        Set<IJavaProject> result = this.projectReferenceChanges;
        this.projectReferenceChanges = new HashSet<IJavaProject>();
        return result;
    }

    public synchronized Set<IJavaElement> removeExternalElementsToRefresh() {
        Set<IJavaElement> result = this.externalElementsToRefresh;
        this.externalElementsToRefresh = null;
        return result;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            final IResourceChangeListener listener = this.preResourceChangeListeners[i];
            if ((this.preResourceChangeEventMasks[i] & event.getType()) != 0) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre Java resource change notification");
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
            ++i;
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (event.getType() == 1) {
                this.deltaProcessors.set(null);
            } else {
                this.getDeltaProcessor().overridenEventType = -1;
            }
        }
    }

    public Hashtable<IPath, Long> getExternalLibTimeStamps() {
        if (this.externalTimeStamps == null) {
            Hashtable<IPath, Long> timeStamps;
            block17: {
                timeStamps = new Hashtable<IPath, Long>();
                File timestampsFile = this.getTimeStampsFile();
                FilterInputStream in = null;
                try {
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                        int size = ((DataInputStream)in).readInt();
                        while (size-- > 0) {
                            String key = ((DataInputStream)in).readUTF();
                            long timestamp = ((DataInputStream)in).readLong();
                            timeStamps.put(Path.fromPortableString((String)key), timestamp);
                        }
                    }
                    catch (IOException e) {
                        if (timestampsFile.exists()) {
                            Util.log(e, "Unable to read external time stamps");
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.externalTimeStamps = timeStamps;
        }
        return this.externalTimeStamps;
    }

    public IJavaProject findJavaProject(String name) {
        if (this.getOldJavaProjecNames().contains(name)) {
            return JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(name);
        }
        return null;
    }

    public synchronized Set<String> getOldJavaProjecNames() {
        if (this.javaProjectNamesCache == null) {
            IJavaProject[] projects;
            try {
                projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            }
            catch (JavaModelException javaModelException) {
                return this.javaProjectNamesCache;
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.javaProjectNamesCache = result;
            return this.javaProjectNamesCache;
        }
        return this.javaProjectNamesCache;
    }

    public synchronized void resetOldJavaProjectNames() {
        this.javaProjectNamesCache = null;
    }

    private File getTimeStampsFile() {
        return JavaCore.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    public void saveExternalLibTimeStamps() throws CoreException {
        Object key;
        if (this.externalTimeStamps == null) {
            return;
        }
        HashSet<Object> toRemove = new HashSet<Object>();
        if (this.roots != null) {
            Enumeration<IPath> keys = this.externalTimeStamps.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (this.roots.get(key) != null) continue;
                toRemove.add(key);
            }
        }
        File timestamps = this.getTimeStampsFile();
        try {
            key = null;
            Object var4_6 = null;
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(timestamps)));){
                out.writeInt(this.externalTimeStamps.size() - toRemove.size());
                for (Map.Entry<IPath, Long> entry : this.externalTimeStamps.entrySet()) {
                    IPath key2 = entry.getKey();
                    if (toRemove.contains(key2)) continue;
                    out.writeUTF(key2.toPortableString());
                    Long timestamp = entry.getValue();
                    out.writeLong(timestamp);
                }
            }
            catch (Throwable throwable) {
                if (key == null) {
                    key = throwable;
                } else if (key != throwable) {
                    ((Throwable)key).addSuppressed(throwable);
                }
                throw key;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "io.spring.javaformat.eclipse.jdt.jdk11.core", 4, "Problems while saving timestamps", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        Map<IPath, List<DeltaProcessor.RootInfo>> otherUpdatedRoots;
        Map<IPath, DeltaProcessor.RootInfo> updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        int containerSegmentCount = containerPath.segmentCount();
        boolean containerIsProject = containerSegmentCount == 1;
        for (Map.Entry<IPath, DeltaProcessor.RootInfo> entry : updatedRoots.entrySet()) {
            List<DeltaProcessor.RootInfo> rootList;
            IResourceDelta rootDelta;
            IPath path = entry.getKey();
            if (!containerPath.isPrefixOf(path) || containerPath.equals((Object)path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(containerSegmentCount))) == null) continue;
            DeltaProcessor.RootInfo rootInfo2 = entry.getValue();
            if (!containerIsProject || !rootInfo2.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
            if ((rootList = otherUpdatedRoots.get(path)) == null) continue;
            for (DeltaProcessor.RootInfo rootInfo2 : rootList) {
                if (containerIsProject && rootInfo2.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
        }
    }

    private static final class RootInfos {
        final Map<IPath, DeltaProcessor.RootInfo> roots = new LinkedHashMap<IPath, DeltaProcessor.RootInfo>();
        final Map<IPath, List<DeltaProcessor.RootInfo>> otherRoots = new HashMap<IPath, List<DeltaProcessor.RootInfo>>();
        final Map<IPath, IPath> sourceAttachments = new HashMap<IPath, IPath>();
        final Map<IJavaProject, IJavaProject[]> projectDependencies = new HashMap<IJavaProject, IJavaProject[]>();
    }
}

