/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IOpenable;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.Openable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.OverflowingLRUCache;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.LRUCache;

public class ElementCache<K extends IJavaElement & IOpenable>
extends OverflowingLRUCache<K, JavaElementInfo> {
    IJavaElement spaceLimitParent = null;

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    @Override
    protected boolean close(LRUCache.LRUCacheEntry<K, JavaElementInfo> entry) {
        Openable element;
        block4: {
            if (!(entry.key instanceof Openable)) {
                return false;
            }
            element = (Openable)entry.key;
            try {
                if (element.canBeRemovedFromCache()) break block4;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        element.close();
        return true;
    }

    protected void ensureSpaceLimit(JavaElementInfo info, IJavaElement parent) {
        int childrenSize = info.getChildren().length;
        int spaceNeeded = 1 + (int)((1.0 + this.loadFactor) * (double)(childrenSize + this.overflow));
        if (this.spaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected ElementCache<K> newInstance(int size, int newOverflow) {
        return new ElementCache<K>(size, newOverflow);
    }

    protected void resetSpaceLimit(int defaultLimit, IJavaElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }
}

