/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ExternalFoldersManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalFolderChange {
    private JavaProject project;
    private IClasspathEntry[] oldResolvedClasspath;

    public ExternalFolderChange(JavaProject project, IClasspathEntry[] oldResolvedClasspath) {
        this.project = project;
        this.oldResolvedClasspath = oldResolvedClasspath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws JavaModelException {
        Set<IPath> oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedClasspath);
        IClasspathEntry[] newResolvedClasspath = this.project.getResolvedClasspath();
        Set<IPath> newFolders = ExternalFoldersManager.getExternalFolders(newResolvedClasspath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = JavaModelManager.getExternalManager();
        for (IPath folderPath : newFolders) {
            if (oldFolders != null && oldFolders.remove(folderPath) && !foldersManager.removePendingFolder(folderPath)) continue;
            try {
                foldersManager.createLinkFolder(folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

