/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ISourceRange;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ImportContainer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ImportDeclarationElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceRefElement;
import org.eclipse.core.runtime.Assert;

public class ImportDeclaration
extends SourceRefElement
implements IImportDeclaration {
    protected String name;
    protected boolean isOnDemand;

    protected ImportDeclaration(ImportContainer parent, String name, boolean isOnDemand) {
        super(parent);
        this.name = name;
        this.isOnDemand = isOnDemand;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportDeclaration)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String getElementName() {
        if (this.isOnDemand) {
            return String.valueOf(this.name) + ".*";
        }
        return this.name;
    }

    public String getNameWithoutStar() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 13;
    }

    @Override
    public int getFlags() throws JavaModelException {
        ImportDeclarationElementInfo info = (ImportDeclarationElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        this.getParent().getHandleMemento(buff);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        ImportDeclarationElementInfo info = (ImportDeclarationElementInfo)this.getElementInfo();
        return info.getNameRange();
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu = (CompilationUnit)this.getParent().getParent();
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getImport(this.getElementName());
    }

    public boolean isOnDemand() {
        return this.isOnDemand;
    }

    @Override
    public String readableName() {
        return null;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("import ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

