/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJarEntryResource;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.JRTUtil;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JarEntryResource;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModel;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelStatus;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class JarEntryFile
extends JarEntryResource {
    private static final IJarEntryResource[] NO_CHILDREN = new IJarEntryResource[0];

    public JarEntryFile(String simpleName) {
        super(simpleName);
    }

    public InputStream getContents() throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (Util.isJrt(root.getPath().toOSString())) {
            try {
                IPath rootPath = root.getPath();
                Object target = JavaModel.getTarget(rootPath, false);
                if (target != null && target instanceof File) {
                    return JRTUtil.getContentFromJrt((File)target, this.getEntryName(), root.getElementName());
                }
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return null;
        }
        ZipFile zipFile = null;
        try {
            String entryName;
            ZipEntry zipEntry;
            zipFile = this.getZipFile();
            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + zipFile.getName());
            }
            if ((zipEntry = zipFile.getEntry(entryName = this.getEntryName())) == null) {
                throw new JavaModelException(new JavaModelStatus(979, entryName));
            }
            byte[] contents = Util.getZipEntryByteContent(zipEntry, zipFile);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
        finally {
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
        }
    }

    public String toString() {
        return "JarEntryFile[" + this.getEntryName() + "]";
    }
}

