/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.ILocalVariable;
import io.spring.javaformat.eclipse.jdt.jdk11.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.Argument;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryLambdaExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryLambdaMethod;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryMember;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.LambdaExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.LambdaMethod;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.LocalVariable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceMethodInfo;

public class LambdaFactory {
    public static LambdaExpression createLambdaExpression(JavaElement parent, io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.LambdaExpression lambdaExpression) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, lambdaExpression);
        }
        return new LambdaExpression(parent, lambdaExpression);
    }

    public static LambdaExpression createLambdaExpression(JavaElement parent, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
        }
        return new LambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.LambdaExpression lambdaExpression) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = lambdaExpression.descriptor.parameters.length;
        String[] parameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            parameterTypes[i] = LambdaFactory.getTypeSignature(manager, lambdaExpression.descriptor.parameters[i]);
            ++i;
        }
        String[] parameterNames = new String[length];
        int i2 = 0;
        while (i2 < length) {
            parameterNames[i2] = manager.intern(new String(lambdaExpression.arguments[i2].name));
            ++i2;
        }
        String returnType = LambdaFactory.getTypeSignature(manager, lambdaExpression.descriptor.returnType);
        String selector = manager.intern(new String(lambdaExpression.descriptor.selector));
        String key = new String(lambdaExpression.descriptor.computeUniqueKey());
        LambdaMethod lambdaMethod = LambdaFactory.createLambdaMethod(parent, selector, key, lambdaExpression.sourceStart, lambdaExpression.sourceEnd, lambdaExpression.arrowPosition, parameterTypes, parameterNames, returnType);
        length = lambdaExpression.arguments.length;
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i3 = 0;
        while (i3 < length) {
            Argument argument = lambdaExpression.arguments[i3];
            String signature = manager.intern(new String(lambdaExpression.descriptor.parameters[i3].signature()));
            parameters[i3] = new LocalVariable(lambdaMethod, new String(argument.name), argument.declarationSourceStart, argument.declarationSourceEnd, argument.sourceStart, argument.sourceEnd, signature, null, argument.modifiers, true);
            ++i3;
        }
        lambdaMethod.elementInfo.arguments = parameters;
        return lambdaMethod;
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, String selector, String key, int sourceStart, int sourceEnd, int arrowPosition, String[] parameterTypes, String[] parameterNames, String returnType) {
        SourceMethodInfo info = null;
        boolean isBinary = parent instanceof BinaryLambdaExpression;
        info = new SourceMethodInfo();
        info.setSourceRangeStart(sourceStart);
        info.setSourceRangeEnd(sourceEnd);
        info.setFlags(0);
        info.setNameSourceStart(sourceStart);
        info.setNameSourceEnd(arrowPosition);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = parameterNames.length;
        char[][] argumentNames = new char[length][];
        int i = 0;
        while (i < length) {
            argumentNames[i] = manager.intern(parameterNames[i].toCharArray());
            ++i;
        }
        info.setArgumentNames(argumentNames);
        info.setReturnType(manager.intern(Signature.toCharArray(returnType.toCharArray())));
        info.setExceptionTypeNames(CharOperation.NO_CHAR_CHAR);
        info.arguments = null;
        return isBinary ? new BinaryLambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info) : new LambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info);
    }

    private static String getTypeSignature(JavaModelManager manager, TypeBinding type) {
        char[] signature = type.genericTypeSignature();
        signature = CharOperation.replaceOnCopy(signature, '/', '.');
        return manager.intern(new String(signature));
    }

    private static boolean isBinaryMember(JavaElement element) {
        return element instanceof BinaryMember;
    }
}

