/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElementInfo;
import java.util.Arrays;

public class OpenableElementInfo
extends JavaElementInfo {
    protected volatile IJavaElement[] children = JavaElement.NO_ELEMENTS;
    protected IModuleDescription module;
    protected boolean isStructureKnown = false;
    protected Object[] nonJavaResources;

    public void addChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            this.children = new IJavaElement[]{child};
        } else {
            int i = 0;
            while (i < length) {
                if (oldChildren[i].equals(child)) {
                    return;
                }
                ++i;
            }
            IJavaElement[] newChildren = new IJavaElement[length + 1];
            System.arraycopy(oldChildren, 0, newChildren, 0, length);
            newChildren[length] = child;
            this.children = newChildren;
        }
    }

    @Override
    public IJavaElement[] getChildren() {
        return this.children;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    public void removeChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                if (length == 1) {
                    this.children = JavaElement.NO_ELEMENTS;
                    break;
                }
                IJavaElement[] newChildren = new IJavaElement[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i);
                if (i < length - 1) {
                    System.arraycopy(oldChildren, i + 1, newChildren, i, length - 1 - i);
                }
                this.children = newChildren;
                break;
            }
            ++i;
        }
    }

    public void setChildren(IJavaElement[] children) {
        this.children = children.length > 0 ? children : JavaElement.NO_ELEMENTS;
    }

    public void setModule(IModuleDescription module) {
        this.module = module;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("isStructureKnown=");
        sb.append(this.isStructureKnown);
        sb.append(", ");
        if (this.module != null) {
            sb.append("module=");
            sb.append(this.module);
            sb.append(", ");
        }
        if (this.children != null) {
            sb.append("children=");
            sb.append(Arrays.toString(this.children));
            sb.append(", ");
        }
        if (this.nonJavaResources != null) {
            sb.append("nonJavaResources=");
            sb.append(Arrays.toString(this.nonJavaResources));
        }
        sb.append("]");
        return sb.toString();
    }

    public IModuleDescription getModule() {
        return this.module;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }
}

