/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.LRUCacheEnumerator;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.LRUCache;
import java.util.Enumeration;

public abstract class OverflowingLRUCache<K, V>
extends LRUCache<K, V> {
    protected int overflow = 0;
    protected boolean timestampsOn = true;
    protected double loadFactor = 0.333;

    public OverflowingLRUCache(int size) {
        this(size, 0);
    }

    public OverflowingLRUCache(int size, int overflow) {
        super(size);
        this.overflow = overflow;
    }

    @Override
    public OverflowingLRUCache<K, V> clone() {
        OverflowingLRUCache newCache = (OverflowingLRUCache)this.newInstance(this.spaceLimit, this.overflow);
        LRUCache.LRUCacheEntry qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    protected abstract boolean close(LRUCache.LRUCacheEntry<K, V> var1);

    public Enumeration<V> elements() {
        if (this.entryQueue == null) {
            return new LRUCacheEnumerator(null);
        }
        LRUCacheEnumerator.LRUEnumeratorElement head = new LRUCacheEnumerator.LRUEnumeratorElement(this.entryQueue.value);
        LRUCache.LRUCacheEntry currentEntry = this.entryQueue.next;
        LRUCacheEnumerator.LRUEnumeratorElement currentElement = head;
        while (currentEntry != null) {
            currentElement.next = new LRUCacheEnumerator.LRUEnumeratorElement(currentEntry.value);
            currentElement = currentElement.next;
            currentEntry = currentEntry.next;
        }
        return new LRUCacheEnumerator(head);
    }

    @Override
    public double fillingRatio() {
        return (double)(this.currentSpace + this.overflow) * 100.0 / (double)this.spaceLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean makeSpace(int space) {
        int limit = this.spaceLimit;
        if (this.overflow == 0 && this.currentSpace + space <= limit) {
            return true;
        }
        int spaceNeeded = (int)((1.0 - this.loadFactor) * (double)limit);
        spaceNeeded = spaceNeeded > space ? spaceNeeded : space;
        LRUCache.LRUCacheEntry entry = this.entryQueueTail;
        try {
            this.timestampsOn = false;
            while (this.currentSpace + spaceNeeded > limit && entry != null) {
                this.privateRemoveEntry(entry, false, false);
                entry = entry.previous;
            }
        }
        finally {
            this.timestampsOn = true;
        }
        if (this.currentSpace + space <= limit) {
            this.overflow = 0;
            return true;
        }
        this.overflow = this.currentSpace + space - limit;
        return false;
    }

    protected abstract LRUCache<K, V> newInstance(int var1, int var2);

    @Override
    protected void privateRemoveEntry(LRUCache.LRUCacheEntry<K, V> entry, boolean shuffle) {
        this.privateRemoveEntry(entry, shuffle, true);
    }

    protected void privateRemoveEntry(LRUCache.LRUCacheEntry<K, V> entry, boolean shuffle, boolean external) {
        if (!shuffle) {
            if (external) {
                this.entryTable.remove(entry.key);
                this.currentSpace -= entry.space;
            } else {
                if (!this.close(entry)) {
                    return;
                }
                if (this.entryTable.get(entry.key) == null) {
                    return;
                }
                this.entryTable.remove(entry.key);
                this.currentSpace -= entry.space;
            }
        }
        LRUCache.LRUCacheEntry previous = entry.previous;
        LRUCache.LRUCacheEntry next = entry.next;
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.overflow > 0) {
            this.shrink();
        }
        int newSpace = this.spaceFor(value);
        LRUCache.LRUCacheEntry entry = (LRUCache.LRUCacheEntry)this.entryTable.get(key);
        if (entry != null) {
            int oldSpace = entry.space;
            int newTotal = this.currentSpace - oldSpace + newSpace;
            if (newTotal <= this.spaceLimit) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                this.overflow = 0;
                return value;
            }
            this.privateRemoveEntry(entry, false, false);
        }
        this.makeSpace(newSpace);
        this.privateAdd(key, value, newSpace);
        return value;
    }

    public V remove(K key) {
        return this.removeKey(key);
    }

    @Override
    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    public boolean shrink() {
        if (this.overflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.toStringFillingRation("OverflowingLRUCache ")) + this.toStringContents();
    }

    @Override
    protected void updateTimestamp(LRUCache.LRUCacheEntry<K, V> entry) {
        if (this.timestampsOn) {
            entry.timestamp = this.timestampCounter++;
            if (this.entryQueue != entry) {
                this.privateRemoveEntry(entry, true);
                this.privateAddEntry(entry, true);
            }
        }
    }
}

