/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJarEntryResource;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ExternalFoldersManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.NonJavaResource;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.OpenableElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PackageFragmentRootInfo
extends OpenableElementInfo {
    protected SourceMapper sourceMapper = null;
    protected int rootKind = 1;
    private boolean ignoreOptionalProblems;
    private boolean initialized;

    public PackageFragmentRootInfo() {
        this.nonJavaResources = null;
        this.initialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static Object[] computeFolderNonJavaResources(IPackageFragmentRoot root, IContainer folder, char[][] inclusionPatterns, char[][] exclusionPatterns) throws JavaModelException {
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            block11: {
                IResource[] members = folder.members();
                int length = members.length;
                if (length <= 0) break block11;
                IJavaProject otherJavaProject = JavaCore.create(folder.getProject());
                String sourceLevel = otherJavaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.source", true);
                String complianceLevel = otherJavaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", true);
                JavaProject javaProject = (JavaProject)root.getJavaProject();
                IClasspathEntry[] classpath = javaProject.getResolvedClasspath();
                int i = 0;
                while (i < length) {
                    block12: {
                        IResource member = members[i];
                        switch (member.getType()) {
                            case 1: {
                                String fileName = member.getName();
                                if ((!Util.isValidCompilationUnitName(fileName, sourceLevel, complianceLevel) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) && !Util.isValidClassFileName(fileName, sourceLevel, complianceLevel) && !PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath)) break;
                                break block12;
                            }
                            case 2: {
                                if (Util.isValidFolderNameForPackage(member.getName(), sourceLevel, complianceLevel) && (!Util.isExcluded(member, inclusionPatterns, exclusionPatterns) || PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath))) break block12;
                            }
                        }
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = member;
                    }
                    ++i;
                }
            }
            if (!ExternalFoldersManager.isInternalPathForExternalFolder(folder.getFullPath())) {
                if (nonJavaResources.length == nonJavaResourcesCounter) return nonJavaResources;
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                return nonJavaResources;
            }
            Object[] jarEntryResources = new IJarEntryResource[nonJavaResourcesCounter];
            int i = 0;
            while (true) {
                if (i >= nonJavaResourcesCounter) {
                    return jarEntryResources;
                }
                jarEntryResources[i] = new NonJavaResource(root, (IResource)nonJavaResources[i]);
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public int getRootKind() {
        return this.rootKind;
    }

    protected SourceMapper getSourceMapper() {
        return this.sourceMapper;
    }

    boolean ignoreOptionalProblems(PackageFragmentRoot packageFragmentRoot) throws JavaModelException {
        if (!this.initialized) {
            this.ignoreOptionalProblems = ((ClasspathEntry)packageFragmentRoot.getRawClasspathEntry()).ignoreOptionalProblems();
            this.initialized = true;
        }
        return this.ignoreOptionalProblems;
    }

    private static boolean isClasspathEntry(IPath path, IClasspathEntry[] resolvedClasspath) {
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setRootKind(int newRootKind) {
        this.rootKind = newRootKind;
    }

    protected void setSourceMapper(SourceMapper mapper) {
        this.sourceMapper = mapper;
    }
}

