/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IRegion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Region
implements IRegion {
    private Node root = new Node();

    @Override
    public void add(IJavaElement element) {
        if (this.contains(element)) {
            return;
        }
        Node node = this.createNodeFor(element);
        node.clearChildren();
    }

    private Node createNodeFor(IJavaElement element) {
        if (element == null) {
            return this.root;
        }
        Node parentNode = this.createNodeFor(this.getParent(element));
        return parentNode.createChildFor(element);
    }

    @Override
    public boolean contains(IJavaElement element) {
        Node existingNode = this.findMostSpecificNodeFor(element);
        if (existingNode == this.root) {
            return false;
        }
        return existingNode.isEmpty();
    }

    private Node findMostSpecificNodeFor(IJavaElement element) {
        if (element == null) {
            return this.root;
        }
        Node parentNode = this.findMostSpecificNodeFor(this.getParent(element));
        Node child = parentNode.findChildFor(element);
        if (child == null) {
            return parentNode;
        }
        return child;
    }

    @Override
    public IJavaElement[] getElements() {
        int leaves = this.countLeafNodes();
        IJavaElement[] result = new IJavaElement[leaves];
        int insertions = this.root.gatherLeaves(result, 0);
        assert (insertions == leaves);
        return result;
    }

    private int countLeafNodes() {
        if (this.root.isEmpty()) {
            return 0;
        }
        return this.root.countLeafNodes();
    }

    protected IJavaElement getParent(IJavaElement element) {
        return element.getParent();
    }

    private static final class Node {
        private Map<IJavaElement, Node> children = Collections.emptyMap();

        public void clearChildren() {
            this.children = Collections.emptyMap();
        }

        public Node createChildFor(IJavaElement element) {
            Node child;
            if (this.children.isEmpty()) {
                this.children = new HashMap<IJavaElement, Node>();
            }
            if ((child = this.children.get(element)) == null) {
                child = new Node();
                this.children.put(element, child);
            }
            return child;
        }

        public Node findChildFor(IJavaElement element) {
            return this.children.get(element);
        }

        public int countLeafNodes() {
            if (this.isEmpty()) {
                return 1;
            }
            int result = 0;
            for (Node next : this.children.values()) {
                result += next.countLeafNodes();
            }
            return result;
        }

        boolean isEmpty() {
            return this.children.isEmpty();
        }

        public int gatherLeaves(IJavaElement[] result, int i) {
            for (Map.Entry<IJavaElement, Node> next : this.children.entrySet()) {
                Node nextNode = next.getValue();
                if (nextNode.isEmpty()) {
                    result[i++] = next.getKey();
                    continue;
                }
                i = nextNode.gatherLeaves(result, i);
            }
            return i;
        }
    }
}

