/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathContainer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.UserLibrary;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;

public class UserLibraryClasspathContainer
implements IClasspathContainer {
    private String name;

    public UserLibraryClasspathContainer(String name) {
        this.name = name;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        UserLibrary library = this.getUserLibrary();
        if (library != null) {
            return library.getEntries();
        }
        return new IClasspathEntry[0];
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public int getKind() {
        UserLibrary library = this.getUserLibrary();
        if (library != null && library.isSystemLibrary()) {
            return 2;
        }
        return 1;
    }

    private UserLibrary getUserLibrary() {
        UserLibrary userLibrary = JavaModelManager.getUserLibraryManager().getUserLibrary(this.name);
        if (userLibrary == null && (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE)) {
            this.verbose_no_user_library_found(this.name);
        }
        return userLibrary;
    }

    private void verbose_no_user_library_found(String userLibraryName) {
        Util.verbose("UserLibrary INIT - FAILED (no user library found)\n\tuserLibraryName: " + userLibraryName);
    }
}

