/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.builder;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.builder.ClasspathDirectory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ClasspathMultiDirectory
extends ClasspathDirectory {
    IContainer sourceFolder;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    boolean hasIndependentOutputFolder;
    public boolean ignoreOptionalProblems;

    ClasspathMultiDirectory(IContainer sourceFolder, IContainer binaryFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems, IPath externalAnnotationPath) {
        super(binaryFolder, true, null, externalAnnotationPath, false);
        this.sourceFolder = sourceFolder;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.hasIndependentOutputFolder = false;
        this.ignoreOptionalProblems = ignoreOptionalProblems;
        if (this.inclusionPatterns != null && this.inclusionPatterns.length == 0) {
            this.inclusionPatterns = null;
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length == 0) {
            this.exclusionPatterns = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.ignoreOptionalProblems == md.ignoreOptionalProblems && this.sourceFolder.equals((Object)md.sourceFolder) && this.binaryFolder.equals((Object)md.binaryFolder) && CharOperation.equals(this.inclusionPatterns, md.inclusionPatterns) && CharOperation.equals(this.exclusionPatterns, md.exclusionPatterns);
    }

    @Override
    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                String name;
                IResource m;
                int l;
                int i;
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                boolean foundClass = false;
                if (members.length > 0) {
                    i = 0;
                    l = members.length;
                    while (i < l) {
                        boolean isClass;
                        m = members[i];
                        name = m.getName();
                        boolean bl = isClass = m.getType() == 1 && Util.isClassFileName(name);
                        if (m.getType() == 2 || isClass) {
                            dirList[index++] = name;
                            foundClass |= isClass;
                        }
                        ++i;
                    }
                }
                if (!foundClass && (container = this.sourceFolder.findMember(qualifiedPackageName)) instanceof IContainer && (members = ((IContainer)container).members()).length > 0) {
                    dirList = new String[members.length];
                    index = 0;
                    i = 0;
                    l = members.length;
                    while (i < l) {
                        m = members[i];
                        name = m.getName();
                        if (m.getType() == 2 || m.getType() == 1 && Util.isJavaFileName(name)) {
                            dirList[index++] = name;
                        }
                        ++i;
                    }
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString() + " with " + super.toString();
    }

    @Override
    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule module() {
        return this.module;
    }
}

