/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotatableType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotationTypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotationTypeMemberDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnonymousClassDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayCreation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayInitializer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AssertStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Assignment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BlockComment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BodyDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BooleanLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BreakStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CaseDefaultExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CastExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CatchClause;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CharacterLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ClassInstanceCreation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ConditionalExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ConstructorInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ContinueStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CreationReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Dimension;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.DoStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EmptyStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnhancedForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumConstantDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExportsDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExpressionMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExpressionStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.GuardedPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IfStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.InfixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Initializer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.InstanceofExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IntersectionType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.JavaDocRegion;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Javadoc;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LabeledStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LambdaExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LineComment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MarkerAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MemberRef;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MemberValuePair;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodRef;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodRefParameter;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Modifier;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleModifier;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModulePackageAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleQualifiedName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Name;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NameQualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NormalAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NullLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NullPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NumberLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.OpensDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParameterizedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParenthesizedExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PatternInstanceofExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PostfixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrefixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrimitiveType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ProvidesDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.RecordDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.RequiresDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ReturnStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SingleMemberAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Statement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.StringLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperConstructorInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperFieldAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperMethodInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchCase;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SynchronizedStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TagElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TagProperty;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TextBlock;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TextElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ThisExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ThrowStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TryStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Type;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.UnionType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.UsesDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.WhileStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.WildcardType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.YieldStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.ScannerHelper;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.util.DOMASTUtil;
import java.util.Iterator;
import java.util.List;

public class NaiveASTFlattener
extends ASTVisitor {
    protected StringBuffer buffer = new StringBuffer();
    private int indent = 0;

    private Name getName(ClassInstanceCreation node) {
        return node.getName();
    }

    public String getResult() {
        return this.buffer.toString();
    }

    private static Type getReturnType(MethodDeclaration node) {
        return node.getReturnType();
    }

    private static Name getSuperclass(TypeDeclaration node) {
        return node.getSuperclass();
    }

    private static TypeDeclaration getTypeDeclaration(TypeDeclarationStatement node) {
        return node.getTypeDeclaration();
    }

    private static List thrownExceptions(MethodDeclaration node) {
        return node.thrownExceptions();
    }

    void printIndent() {
        int i = 0;
        while (i < this.indent) {
            this.buffer.append("  ");
            ++i;
        }
    }

    void printModifiers(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            this.buffer.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            this.buffer.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            this.buffer.append("private ");
        }
        if (Modifier.isStatic(modifiers)) {
            this.buffer.append("static ");
        }
        if (Modifier.isAbstract(modifiers)) {
            this.buffer.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            this.buffer.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            this.buffer.append("synchronized ");
        }
        if (Modifier.isVolatile(modifiers)) {
            this.buffer.append("volatile ");
        }
        if (Modifier.isNative(modifiers)) {
            this.buffer.append("native ");
        }
        if (Modifier.isStrictfp(modifiers)) {
            this.buffer.append("strictfp ");
        }
        if (Modifier.isTransient(modifiers)) {
            this.buffer.append("transient ");
        }
        if (Modifier.isSealed(modifiers)) {
            this.buffer.append("sealed ");
        }
        if (Modifier.isNonSealed(modifiers)) {
            this.buffer.append("non-sealed ");
        }
    }

    void printModifiers(List ext) {
        for (ASTNode p : ext) {
            p.accept(this);
            this.buffer.append(" ");
        }
    }

    private void printTypes(List<Type> types, String prefix) {
        if (types.size() > 0) {
            this.buffer.append(" " + prefix + " ");
            Type type = types.get(0);
            type.accept(this);
            int i = 1;
            int l = types.size();
            while (i < l) {
                this.buffer.append(",");
                type = types.get(0);
                type.accept(this);
                ++i;
            }
        }
    }

    private void visitReferenceTypeArguments(List typeArguments) {
        this.buffer.append("::");
        if (!typeArguments.isEmpty()) {
            this.buffer.append('<');
            Iterator it = typeArguments.iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(',');
            }
            this.buffer.append('>');
        }
    }

    private void visitTypeAnnotations(AnnotatableType node) {
        if (node.getAST().apiLevel() >= 8) {
            this.visitAnnotationsList(node.annotations());
        }
    }

    private void visitAnnotationsList(List annotations) {
        for (Annotation annotation : annotations) {
            annotation.accept(this);
            this.buffer.append(' ');
        }
    }

    private List superInterfaces(TypeDeclaration node) {
        return node.superInterfaces();
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(node.modifiers());
        this.buffer.append("@interface ");
        node.getName().accept(this);
        this.buffer.append(" {");
        for (BodyDeclaration d : node.bodyDeclarations()) {
            d.accept(this);
        }
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(node.modifiers());
        node.getType().accept(this);
        this.buffer.append(" ");
        node.getName().accept(this);
        this.buffer.append("()");
        if (node.getDefault() != null) {
            this.buffer.append(" default ");
            node.getDefault().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.buffer.append("{\n");
        ++this.indent;
        for (BodyDeclaration b : node.bodyDeclarations()) {
            b.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        node.getArray().accept(this);
        this.buffer.append("[");
        node.getIndex().accept(this);
        this.buffer.append("]");
        return false;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        this.buffer.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept(this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.buffer.append("[");
            Expression e = (Expression)it.next();
            e.accept(this);
            this.buffer.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.buffer.append("{");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ArrayType node) {
        if (node.getAST().apiLevel() < 8) {
            this.visitComponentType(node);
            this.buffer.append("[]");
        } else {
            node.getElementType().accept(this);
            List dimensions = node.dimensions();
            int size = dimensions.size();
            int i = 0;
            while (i < size) {
                Dimension aDimension = (Dimension)dimensions.get(i);
                aDimension.accept(this);
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean visit(AssertStatement node) {
        this.printIndent();
        this.buffer.append("assert ");
        node.getExpression().accept(this);
        if (node.getMessage() != null) {
            this.buffer.append(" : ");
            node.getMessage().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept(this);
        this.buffer.append(node.getOperator().toString());
        node.getRightHandSide().accept(this);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.buffer.append("{\n");
        ++this.indent;
        for (Statement s : node.statements()) {
            s.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(BlockComment node) {
        this.printIndent();
        this.buffer.append("/* */");
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.buffer.append("true");
        } else {
            this.buffer.append("false");
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.printIndent();
        this.buffer.append("break");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(CaseDefaultExpression node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            this.buffer.append("default");
        }
        return false;
    }

    @Override
    public boolean visit(CastExpression node) {
        this.buffer.append("(");
        node.getType().accept(this);
        this.buffer.append(")");
        node.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.buffer.append("catch (");
        node.getException().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(CharacterLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("new ");
        if (node.getAST().apiLevel() == 2) {
            this.getName(node).accept(this);
        }
        if (node.getAST().apiLevel() >= 3) {
            if (!node.typeArguments().isEmpty()) {
                this.buffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            node.getType().accept(this);
        }
        this.buffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        if (node.getAST().apiLevel() >= 9 && node.getModule() != null) {
            node.getModule().accept(this);
        }
        if (node.getPackage() != null) {
            node.getPackage().accept(this);
        }
        for (ASTNode d : node.imports()) {
            d.accept(this);
        }
        for (ASTNode d : node.types()) {
            d.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept(this);
        this.buffer.append(" ? ");
        node.getThenExpression().accept(this);
        this.buffer.append(" : ");
        node.getElseExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        Iterator it;
        this.printIndent();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("this(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.printIndent();
        this.buffer.append("continue");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        node.getType().accept(this);
        this.visitReferenceTypeArguments(node.typeArguments());
        this.buffer.append("new");
        return false;
    }

    @Override
    public boolean visit(Dimension node) {
        List annotations = node.annotations();
        if (annotations.size() > 0) {
            this.buffer.append(' ');
        }
        this.visitAnnotationsList(annotations);
        this.buffer.append("[]");
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.printIndent();
        this.buffer.append("do ");
        node.getBody().accept(this);
        this.buffer.append(" while (");
        node.getExpression().accept(this);
        this.buffer.append(");\n");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.printIndent();
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.printIndent();
        this.buffer.append("for (");
        node.getParameter().accept(this);
        this.buffer.append(" : ");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(node.modifiers());
        node.getName().accept(this);
        if (!node.arguments().isEmpty()) {
            this.buffer.append("(");
            Iterator it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
        }
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(node.modifiers());
        this.buffer.append("enum ");
        node.getName().accept(this);
        this.buffer.append(" ");
        if (!node.superInterfaceTypes().isEmpty()) {
            this.buffer.append("implements ");
            it = node.superInterfaceTypes().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        this.buffer.append("{");
        it = node.enumConstants().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (EnumConstantDeclaration)it.next();
            d.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (!node.bodyDeclarations().isEmpty()) {
            this.buffer.append("; ");
            for (BodyDeclaration d : node.bodyDeclarations()) {
                d.accept(this);
            }
        }
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(ExportsDirective node) {
        return this.visit(node, "exports");
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        node.getExpression().accept(this);
        this.visitReferenceTypeArguments(node.typeArguments());
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        this.printIndent();
        node.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        node.getExpression().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        Expression e;
        this.printIndent();
        this.buffer.append("for (");
        Iterator it = node.initializers().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
        }
        this.buffer.append("; ");
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(GuardedPattern node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            node.getPattern().accept(this);
            this.buffer.append(" && ");
            node.getExpression().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.printIndent();
        this.buffer.append("if (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getThenStatement().accept(this);
        if (node.getElseStatement() != null) {
            this.buffer.append(" else ");
            node.getElseStatement().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.printIndent();
        this.buffer.append("import ");
        if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
            this.buffer.append("static ");
        }
        node.getName().accept(this);
        if (node.isOnDemand()) {
            this.buffer.append(".*");
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(' ');
        this.buffer.append(node.getOperator().toString());
        this.buffer.append(' ');
        node.getRightOperand().accept(this);
        List extendedOperands = node.extendedOperands();
        if (extendedOperands.size() != 0) {
            this.buffer.append(' ');
            Iterator it = extendedOperands.iterator();
            while (it.hasNext()) {
                this.buffer.append(node.getOperator().toString()).append(' ');
                Expression e = (Expression)it.next();
                e.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(" instanceof ");
        node.getRightOperand().accept(this);
        return false;
    }

    @Override
    public boolean visit(PatternInstanceofExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(" instanceof ");
        node.getRightOperand().accept(this);
        return false;
    }

    @Override
    public boolean visit(IntersectionType node) {
        Iterator it = node.types().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(" & ");
        }
        return false;
    }

    @Override
    public boolean visit(Javadoc node) {
        this.printIndent();
        this.buffer.append("/** ");
        for (ASTNode e : node.tags()) {
            e.accept(this);
        }
        this.buffer.append("\n */\n");
        return false;
    }

    @Override
    public boolean visit(JavaDocRegion node) {
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.printIndent();
        node.getLabel().accept(this);
        this.buffer.append(": ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        boolean hasParentheses = node.hasParentheses();
        if (hasParentheses) {
            this.buffer.append('(');
        }
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            VariableDeclaration v = (VariableDeclaration)it.next();
            v.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        if (hasParentheses) {
            this.buffer.append(')');
        }
        this.buffer.append(" -> ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(LineComment node) {
        this.buffer.append("//\n");
        return false;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.buffer.append("@");
        node.getTypeName().accept(this);
        return false;
    }

    @Override
    public boolean visit(MemberRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
        }
        this.buffer.append("#");
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(MemberValuePair node) {
        node.getName().accept(this);
        this.buffer.append("=");
        node.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
            if (!node.typeParameters().isEmpty()) {
                this.buffer.append("<");
                it = node.typeParameters().iterator();
                while (it.hasNext()) {
                    TypeParameter t = (TypeParameter)it.next();
                    t.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
        }
        if (!node.isConstructor()) {
            if (node.getAST().apiLevel() == 2) {
                NaiveASTFlattener.getReturnType(node).accept(this);
            } else if (node.getReturnType2() != null) {
                node.getReturnType2().accept(this);
            } else {
                this.buffer.append("void");
            }
            this.buffer.append(" ");
        }
        node.getName().accept(this);
        if (!DOMASTUtil.isRecordDeclarationSupported(node.getAST()) || !node.isCompactConstructor()) {
            Type receiverType;
            this.buffer.append("(");
            if (node.getAST().apiLevel() >= 8 && (receiverType = node.getReceiverType()) != null) {
                receiverType.accept(this);
                this.buffer.append(' ');
                SimpleName qualifier = node.getReceiverQualifier();
                if (qualifier != null) {
                    qualifier.accept(this);
                    this.buffer.append('.');
                }
                this.buffer.append("this");
                if (node.parameters().size() > 0) {
                    this.buffer.append(',');
                }
            }
            it = node.parameters().iterator();
            while (it.hasNext()) {
                SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
                v.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
        }
        int size = node.getExtraDimensions();
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            int i = 0;
            while (i < size) {
                this.visit((Dimension)dimensions.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                this.buffer.append("[]");
                ++i;
            }
        }
        if (node.getAST().apiLevel() < 8) {
            if (!NaiveASTFlattener.thrownExceptions(node).isEmpty()) {
                this.buffer.append(" throws ");
                Iterator it2 = NaiveASTFlattener.thrownExceptions(node).iterator();
                while (it2.hasNext()) {
                    Name n = (Name)it2.next();
                    n.accept(this);
                    if (!it2.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        } else if (!node.thrownExceptionTypes().isEmpty()) {
            this.buffer.append(" throws ");
            Iterator it3 = node.thrownExceptionTypes().iterator();
            while (it3.hasNext()) {
                Type n = (Type)it3.next();
                n.accept(this);
                if (!it3.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        if (node.getBody() == null) {
            this.buffer.append(";\n");
        } else {
            node.getBody().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        node.getName().accept(this);
        this.buffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(MethodRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
        }
        this.buffer.append("#");
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            MethodRefParameter e = (MethodRefParameter)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(MethodRefParameter node) {
        node.getType().accept(this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.buffer.append("...");
        }
        if (node.getName() != null) {
            this.buffer.append(" ");
            node.getName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Modifier node) {
        this.buffer.append(node.getKeyword().toString());
        return false;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printModifiers(node.annotations());
        if (node.isOpen()) {
            this.buffer.append("open ");
        }
        this.buffer.append("module");
        this.buffer.append(" ");
        node.getName().accept(this);
        this.buffer.append(" {\n");
        ++this.indent;
        for (ModuleDirective stmt : node.moduleStatements()) {
            stmt.accept(this);
        }
        --this.indent;
        this.buffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ModuleModifier node) {
        this.buffer.append(node.getKeyword().toString());
        return false;
    }

    private boolean visit(ModulePackageAccess node, String keyword) {
        this.printIndent();
        this.buffer.append(keyword);
        this.buffer.append(" ");
        node.getName().accept(this);
        this.printTypes(node.modules(), "to");
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        node.getQualifier().accept(this);
        this.buffer.append('.');
        this.visitTypeAnnotations(node);
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.buffer.append("@");
        node.getTypeName().accept(this);
        this.buffer.append("(");
        Iterator it = node.values().iterator();
        while (it.hasNext()) {
            MemberValuePair p = (MemberValuePair)it.next();
            p.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.buffer.append("null");
        return false;
    }

    @Override
    public boolean visit(NullPattern node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            this.buffer.append("null");
        }
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.buffer.append(node.getToken());
        return false;
    }

    @Override
    public boolean visit(OpensDirective node) {
        return this.visit(node, "opens");
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept(this);
            }
            for (Annotation p : node.annotations()) {
                p.accept(this);
                this.buffer.append(" ");
            }
        }
        this.printIndent();
        this.buffer.append("package ");
        node.getName().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        node.getType().accept(this);
        this.buffer.append("<");
        Iterator it = node.typeArguments().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(">");
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.buffer.append("(");
        node.getExpression().accept(this);
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        node.getOperand().accept(this);
        this.buffer.append(node.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.buffer.append(node.getOperator().toString());
        node.getOperand().accept(this);
        return false;
    }

    @Override
    public boolean visit(PrimitiveType node) {
        this.visitTypeAnnotations(node);
        this.buffer.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.printIndent();
        this.buffer.append("provides");
        this.buffer.append(" ");
        node.getName().accept(this);
        this.printTypes(node.implementations(), "with");
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ModuleQualifiedName node) {
        node.getModuleQualifier().accept(this);
        this.buffer.append("/");
        Name cNode = node.getName();
        if (cNode != null) {
            cNode.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        node.getQualifier().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        node.getQualifier().accept(this);
        this.buffer.append(".");
        this.visitTypeAnnotations(node);
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        ASTNode t;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(node.modifiers());
        this.buffer.append("record ");
        node.getName().accept(this);
        this.buffer.append(" ");
        if (!node.typeParameters().isEmpty()) {
            this.buffer.append("<");
            it = node.typeParameters().iterator();
            while (it.hasNext()) {
                t = (TypeParameter)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append(" ");
        this.buffer.append("(");
        it = node.recordComponents().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (!node.superInterfaceTypes().isEmpty()) {
            this.buffer.append(" implements ");
            it = node.superInterfaceTypes().iterator();
            while (it.hasNext()) {
                t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        this.buffer.append("{");
        if (!node.bodyDeclarations().isEmpty()) {
            this.buffer.append("\n");
            for (BodyDeclaration d : node.bodyDeclarations()) {
                d.accept(this);
            }
        }
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(RequiresDirective node) {
        this.printIndent();
        this.buffer.append("requires");
        this.buffer.append(" ");
        this.printModifiers(node.modifiers());
        node.getName().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.printIndent();
        this.buffer.append("return");
        if (node.getExpression() != null) {
            this.buffer.append(" ");
            node.getExpression().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.buffer.append(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(SimpleType node) {
        this.visitTypeAnnotations(node);
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.buffer.append("@");
        node.getTypeName().accept(this);
        this.buffer.append("(");
        node.getValue().accept(this);
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            if (node.getAST().apiLevel() >= 8) {
                List annotations = node.varargsAnnotations();
                if (annotations.size() > 0) {
                    this.buffer.append(' ');
                }
                this.visitAnnotationsList(annotations);
            }
            this.buffer.append("...");
        }
        this.buffer.append(" ");
        node.getName().accept(this);
        int size = node.getExtraDimensions();
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            int i = 0;
            while (i < size) {
                this.visit((Dimension)dimensions.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                this.buffer.append("[]");
                ++i;
            }
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        Iterator it;
        this.printIndent();
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("super(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        Iterator it;
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        node.getName().accept(this);
        this.buffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append('.');
        }
        this.buffer.append("super");
        this.visitReferenceTypeArguments(node.typeArguments());
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (node.getAST().apiLevel() >= 14) {
            if (node.isDefault() && !this.isCaseDefaultExpression(node)) {
                this.buffer.append("default");
                this.buffer.append(node.isSwitchLabeledRule() ? " ->" : ":");
            } else {
                this.buffer.append("case ");
                Iterator it = node.expressions().iterator();
                while (it.hasNext()) {
                    Expression t = (Expression)it.next();
                    t.accept(this);
                    this.buffer.append(it.hasNext() ? ", " : (node.isSwitchLabeledRule() ? " ->" : ":"));
                }
            }
        } else if (node.isDefault() && !this.isCaseDefaultExpression(node)) {
            this.buffer.append("default :\n");
        } else {
            this.buffer.append("case ");
            this.getSwitchExpression(node).accept(this);
            this.buffer.append(":\n");
        }
        ++this.indent;
        return false;
    }

    private boolean isCaseDefaultExpression(SwitchCase node) {
        return node.expressions() != null && node.expressions().size() == 1 && node.expressions().get(0) instanceof CaseDefaultExpression;
    }

    private Expression getSwitchExpression(SwitchCase node) {
        return node.getExpression();
    }

    private void visitSwitchNode(ASTNode node) {
        this.buffer.append("switch (");
        if (node instanceof SwitchExpression) {
            ((SwitchExpression)node).getExpression().accept(this);
        } else if (node instanceof SwitchStatement) {
            ((SwitchStatement)node).getExpression().accept(this);
        }
        this.buffer.append(") ");
        this.buffer.append("{\n");
        ++this.indent;
        if (node instanceof SwitchExpression) {
            for (Statement s : ((SwitchExpression)node).statements()) {
                s.accept(this);
                --this.indent;
            }
        } else if (node instanceof SwitchStatement) {
            for (Statement s : ((SwitchStatement)node).statements()) {
                s.accept(this);
                --this.indent;
            }
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
    }

    @Override
    public boolean visit(SwitchExpression node) {
        this.visitSwitchNode(node);
        return false;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.visitSwitchNode(node);
        return false;
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.buffer.append("synchronized (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(TagElement node) {
        if (node.isNested()) {
            this.buffer.append("{");
        } else {
            this.buffer.append("\n * ");
        }
        boolean previousRequiresWhiteSpace = false;
        if (node.getTagName() != null) {
            this.buffer.append(node.getTagName());
            previousRequiresWhiteSpace = true;
        }
        boolean previousRequiresNewLine = false;
        for (ASTNode e : node.fragments()) {
            String text;
            boolean currentIncludesWhiteSpace = false;
            if (e instanceof TextElement && (text = ((TextElement)e).getText()).length() > 0 && ScannerHelper.isWhitespace(text.charAt(0))) {
                currentIncludesWhiteSpace = true;
            }
            if (previousRequiresNewLine && currentIncludesWhiteSpace) {
                this.buffer.append("\n * ");
            }
            previousRequiresNewLine = currentIncludesWhiteSpace;
            if (previousRequiresWhiteSpace && !currentIncludesWhiteSpace) {
                this.buffer.append(" ");
            }
            e.accept(this);
            boolean bl = previousRequiresWhiteSpace = !currentIncludesWhiteSpace && !(e instanceof TagElement);
        }
        if (DOMASTUtil.isJavaDocCodeSnippetSupported(node.getAST().apiLevel())) {
            for (TagProperty tagProperty : node.tagProperties()) {
                tagProperty.accept(this);
            }
        }
        if (node.isNested()) {
            this.buffer.append("}");
        }
        return false;
    }

    @Override
    public boolean visit(TagProperty node) {
        this.buffer.append("\n{");
        this.buffer.append(node.getName());
        this.buffer.append(" = ");
        this.buffer.append(node.getStringValue());
        node.getNodeValue().accept(this);
        this.buffer.append("}");
        return false;
    }

    @Override
    public boolean visit(TextBlock node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(TextElement node) {
        this.buffer.append(node.getText());
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.printIndent();
        this.buffer.append("throw ");
        node.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        List resources;
        this.printIndent();
        this.buffer.append("try ");
        if (node.getAST().apiLevel() >= 4 && !(resources = node.resources()).isEmpty()) {
            this.buffer.append('(');
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                Expression variable = (Expression)it.next();
                variable.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(';');
            }
            this.buffer.append(')');
        }
        node.getBody().accept(this);
        this.buffer.append(" ");
        for (CatchClause cc : node.catchClauses()) {
            cc.accept(this);
        }
        if (node.getFinally() != null) {
            this.buffer.append(" finally ");
            node.getFinally().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        ASTNode t;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.buffer.append(node.isInterface() ? "interface " : "class ");
        node.getName().accept(this);
        if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
            this.buffer.append("<");
            it = node.typeParameters().iterator();
            while (it.hasNext()) {
                t = (TypeParameter)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append(" ");
        if (node.getAST().apiLevel() == 2) {
            if (NaiveASTFlattener.getSuperclass(node) != null) {
                this.buffer.append("extends ");
                NaiveASTFlattener.getSuperclass(node).accept(this);
                this.buffer.append(" ");
            }
            if (!this.superInterfaces(node).isEmpty()) {
                this.buffer.append(node.isInterface() ? "extends " : "implements ");
                it = this.superInterfaces(node).iterator();
                while (it.hasNext()) {
                    Name n = (Name)it.next();
                    n.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        if (node.getAST().apiLevel() >= 3) {
            if (node.getSuperclassType() != null) {
                this.buffer.append("extends ");
                node.getSuperclassType().accept(this);
                this.buffer.append(" ");
            }
            if (!node.superInterfaceTypes().isEmpty()) {
                this.buffer.append(node.isInterface() ? "extends " : "implements ");
                it = node.superInterfaceTypes().iterator();
                while (it.hasNext()) {
                    t = (Type)it.next();
                    t.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        if (DOMASTUtil.isFeatureSupportedinAST(node.getAST(), 512) && !node.permittedTypes().isEmpty()) {
            this.buffer.append("permits ");
            it = node.permittedTypes().iterator();
            while (it.hasNext()) {
                t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        this.buffer.append("{\n");
        ++this.indent;
        for (BodyDeclaration d : node.bodyDeclarations()) {
            d.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            NaiveASTFlattener.getTypeDeclaration(node).accept(this);
        }
        if (node.getAST().apiLevel() >= 3) {
            node.getDeclaration().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteral node) {
        node.getType().accept(this);
        this.buffer.append(".class");
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        node.getType().accept(this);
        this.visitReferenceTypeArguments(node.typeArguments());
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(TypeParameter node) {
        if (node.getAST().apiLevel() >= 8) {
            this.printModifiers(node.modifiers());
        }
        node.getName().accept(this);
        if (!node.typeBounds().isEmpty()) {
            this.buffer.append(" extends ");
            Iterator it = node.typeBounds().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(" & ");
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypePattern node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            node.getPatternVariable().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(UnionType node) {
        Iterator it = node.types().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append('|');
        }
        return false;
    }

    @Override
    public boolean visit(UsesDirective node) {
        this.printIndent();
        this.buffer.append("uses");
        this.buffer.append(" ");
        node.getName().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept(this);
        int size = node.getExtraDimensions();
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            int i = 0;
            while (i < size) {
                this.visit((Dimension)dimensions.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                this.buffer.append("[]");
                ++i;
            }
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.printIndent();
        this.buffer.append("while (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(WildcardType node) {
        this.visitTypeAnnotations(node);
        this.buffer.append("?");
        Type bound = node.getBound();
        if (bound != null) {
            if (node.isUpperBound()) {
                this.buffer.append(" extends ");
            } else {
                this.buffer.append(" super ");
            }
            bound.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(YieldStatement node) {
        if (node.getAST().apiLevel() >= 14 && node.isImplicit() && node.getExpression() == null) {
            return false;
        }
        this.printIndent();
        this.buffer.append("yield");
        if (node.getExpression() != null) {
            this.buffer.append(" ");
            node.getExpression().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    private void visitComponentType(ArrayType node) {
        node.getComponentType().accept(this);
    }
}

