/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotationTypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotationTypeMemberDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnonymousClassDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayCreation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayInitializer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ArrayType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AssertStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Assignment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BlockComment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BooleanLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.BreakStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CaseDefaultExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CastExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CatchClause;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CharacterLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ClassInstanceCreation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ConditionalExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ConstructorInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ContinueStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.CreationReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Dimension;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.DoStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EmptyStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnhancedForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumConstantDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExportsDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExpressionMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExpressionStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.GuardedPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IfStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.InfixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Initializer;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.InstanceofExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IntersectionType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Javadoc;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LabeledStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LambdaExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LineComment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MarkerAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MemberRef;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MemberValuePair;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodRef;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodRefParameter;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Modifier;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleModifier;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NameQualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NormalAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NullLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NullPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.NumberLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParameterizedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParenthesizedExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PatternInstanceofExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PostfixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrefixExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrimitiveType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ProvidesDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.QualifiedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.RecordDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.RequiresDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ReturnStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SimpleType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SingleMemberAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.StringLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.StructuralPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperConstructorInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperFieldAccess;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperMethodInvocation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SuperMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchCase;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SynchronizedStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TagElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TextBlock;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TextElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ThisExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ThrowStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TryStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Type;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeLiteral;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeMethodReference;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.UnionType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.UsesDirective;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.WhileStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.WildcardType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.YieldStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite.RewriteEventStore;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.util.DOMASTUtil;
import java.util.Iterator;
import java.util.List;

public class ASTRewriteFlattener
extends ASTVisitor {
    private static final ChildPropertyDescriptor INTERNAL_ARRAY_COMPONENT_TYPE_PROPERTY = ArrayType.COMPONENT_TYPE_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_FIELD_MODIFIERS_PROPERTY = FieldDeclaration.MODIFIERS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_INITIALIZER_MODIFIERS_PROPERTY = Initializer.MODIFIERS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_METHOD_MODIFIERS_PROPERTY = MethodDeclaration.MODIFIERS_PROPERTY;
    private static final ChildPropertyDescriptor INTERNAL_METHOD_RETURN_TYPE_PROPERTY = MethodDeclaration.RETURN_TYPE_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_METHOD_EXTRA_DIMENSIONS_PROPERTY = MethodDeclaration.EXTRA_DIMENSIONS_PROPERTY;
    private static final ChildListPropertyDescriptor INTERNAL_METHOD_THROWN_EXCEPTIONS_PROPERTY = MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_TYPE_MODIFIERS_PROPERTY = TypeDeclaration.MODIFIERS_PROPERTY;
    private static final ChildPropertyDescriptor INTERNAL_TYPE_SUPERCLASS_PROPERTY = TypeDeclaration.SUPERCLASS_PROPERTY;
    private static final ChildListPropertyDescriptor INTERNAL_TYPE_SUPER_INTERFACES_PROPERTY = TypeDeclaration.SUPER_INTERFACES_PROPERTY;
    private static final ChildPropertyDescriptor INTERNAL_CIC_NAME_PROPERTY = ClassInstanceCreation.NAME_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_FRAGMENT_EXTRA_DIMENSIONS_PROPERTY = VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY;
    private static final ChildPropertyDescriptor INTERNAL_TDS_TYPE_DECLARATION_PROPERTY = TypeDeclarationStatement.TYPE_DECLARATION_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_VARIABLE_MODIFIERS_PROPERTY = SingleVariableDeclaration.MODIFIERS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_VARIABLE_EXTRA_DIMENSIONS_PROPERTY = SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_VDE_MODIFIERS_PROPERTY = VariableDeclarationExpression.MODIFIERS_PROPERTY;
    private static final SimplePropertyDescriptor INTERNAL_VDS_MODIFIERS_PROPERTY = VariableDeclarationStatement.MODIFIERS_PROPERTY;
    private static final ChildListPropertyDescriptor INTERNAL_TRY_STATEMENT_RESOURCES_PROPERTY = TryStatement.RESOURCES_PROPERTY;
    private static final ChildPropertyDescriptor INTERNAL_SWITCH_EXPRESSION_PROPERTY = SwitchCase.EXPRESSION_PROPERTY;
    protected StringBuffer result;
    private RewriteEventStore store;

    public static String asString(ASTNode node, RewriteEventStore store) {
        ASTRewriteFlattener flattener = new ASTRewriteFlattener(store);
        node.accept(flattener);
        return flattener.getResult();
    }

    public ASTRewriteFlattener(RewriteEventStore store) {
        this.store = store;
        this.result = new StringBuffer();
    }

    public String getResult() {
        return this.result.toString();
    }

    public static void printModifiers(int modifiers, StringBuffer buf) {
        if (Modifier.isPublic(modifiers)) {
            buf.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            buf.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            buf.append("private ");
        }
        if (Modifier.isStatic(modifiers)) {
            buf.append("static ");
        }
        if (Modifier.isAbstract(modifiers)) {
            buf.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            buf.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            buf.append("synchronized ");
        }
        if (Modifier.isVolatile(modifiers)) {
            buf.append("volatile ");
        }
        if (Modifier.isNative(modifiers)) {
            buf.append("native ");
        }
        if (Modifier.isStrictfp(modifiers)) {
            buf.append("strictfp ");
        }
        if (Modifier.isTransient(modifiers)) {
            buf.append("transient ");
        }
        if (Modifier.isSealed(modifiers)) {
            buf.append("sealed ");
        }
        if (Modifier.isNonSealed(modifiers)) {
            buf.append("non-sealed ");
        }
    }

    protected List getChildList(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (List)this.getAttribute(parent, childProperty);
    }

    protected ASTNode getChildNode(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (ASTNode)this.getAttribute(parent, childProperty);
    }

    protected int getIntAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Integer)this.getAttribute(parent, childProperty);
    }

    protected boolean getBooleanAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Boolean)this.getAttribute(parent, childProperty);
    }

    protected Object getAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return this.store.getNewValue(parent, childProperty);
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator) {
        List list = this.getChildList(parent, childProperty);
        int i = 0;
        while (i < list.size()) {
            if (separator != null && i > 0) {
                this.result.append(separator);
            }
            ((ASTNode)list.get(i)).accept(this);
            ++i;
        }
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator, String lead, String post) {
        List list = this.getChildList(parent, childProperty);
        if (!list.isEmpty()) {
            this.result.append(lead);
            int i = 0;
            while (i < list.size()) {
                if (separator != null && i > 0) {
                    this.result.append(separator);
                }
                ((ASTNode)list.get(i)).accept(this);
                ++i;
            }
            this.result.append(post);
        }
    }

    private void visitExtraDimensions(ASTNode node, SimplePropertyDescriptor dimensions, ChildListPropertyDescriptor dimensionsInfo) {
        if (node.getAST().apiLevel() < 8) {
            int extraDimensions = this.getIntAttribute(node, dimensions);
            int i = 0;
            while (i < extraDimensions) {
                this.result.append("[]");
                ++i;
            }
        } else {
            this.visitList(node, dimensionsInfo, String.valueOf(' '), String.valueOf(' '), Util.EMPTY_STRING);
        }
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.result.append('{');
        this.visitList(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        this.getChildNode(node, ArrayAccess.ARRAY_PROPERTY).accept(this);
        this.result.append('[');
        this.getChildNode(node, ArrayAccess.INDEX_PROPERTY).accept(this);
        this.result.append(']');
        return false;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        int dimensions;
        Type elementType;
        boolean astLevelGTE8;
        this.result.append("new ");
        ArrayType arrayType = (ArrayType)this.getChildNode(node, ArrayCreation.TYPE_PROPERTY);
        boolean bl = astLevelGTE8 = node.getAST().apiLevel() >= 8;
        if (astLevelGTE8) {
            elementType = (Type)this.getChildNode(arrayType, ArrayType.ELEMENT_TYPE_PROPERTY);
            dimensions = this.getChildList(arrayType, ArrayType.DIMENSIONS_PROPERTY).size();
        } else {
            elementType = (Type)this.getChildNode(arrayType, INTERNAL_ARRAY_COMPONENT_TYPE_PROPERTY);
            dimensions = 1;
            while (elementType.isArrayType()) {
                ++dimensions;
                elementType = (Type)this.getChildNode(elementType, INTERNAL_ARRAY_COMPONENT_TYPE_PROPERTY);
            }
        }
        elementType.accept(this);
        List list = this.getChildList(node, ArrayCreation.DIMENSIONS_PROPERTY);
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.internalVisitDimensionAnnotations(arrayType, i, astLevelGTE8);
            this.result.append('[');
            ((ASTNode)list.get(i)).accept(this);
            this.result.append(']');
            ++i;
        }
        i = list.size();
        while (i < dimensions) {
            this.internalVisitDimensionAnnotations(arrayType, i, astLevelGTE8);
            this.result.append("[]");
            ++i;
        }
        ASTNode initializer = this.getChildNode(node, ArrayCreation.INITIALIZER_PROPERTY);
        if (initializer != null) {
            this.getChildNode(node, ArrayCreation.INITIALIZER_PROPERTY).accept(this);
        }
        return false;
    }

    private void internalVisitDimensionAnnotations(ArrayType arrayType, int index, boolean astLevelGTE8) {
        if (astLevelGTE8) {
            Dimension dimension = (Dimension)arrayType.dimensions().get(index);
            this.visitList(dimension, Dimension.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.result.append('{');
        this.visitList(node, ArrayInitializer.EXPRESSIONS_PROPERTY, String.valueOf(','));
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(ArrayType node) {
        if (node.getAST().apiLevel() < 8) {
            this.getChildNode(node, INTERNAL_ARRAY_COMPONENT_TYPE_PROPERTY).accept(this);
            this.result.append("[]");
        } else {
            this.getChildNode(node, ArrayType.ELEMENT_TYPE_PROPERTY).accept(this);
            this.visitList(node, ArrayType.DIMENSIONS_PROPERTY, Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING);
        }
        return false;
    }

    @Override
    public boolean visit(AssertStatement node) {
        this.result.append("assert ");
        this.getChildNode(node, AssertStatement.EXPRESSION_PROPERTY).accept(this);
        ASTNode message = this.getChildNode(node, AssertStatement.MESSAGE_PROPERTY);
        if (message != null) {
            this.result.append(':');
            message.accept(this);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        this.getChildNode(node, Assignment.LEFT_HAND_SIDE_PROPERTY).accept(this);
        this.result.append(this.getAttribute(node, Assignment.OPERATOR_PROPERTY).toString());
        this.getChildNode(node, Assignment.RIGHT_HAND_SIDE_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.result.append('{');
        this.visitList(node, Block.STATEMENTS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.result.append("true");
        } else {
            this.result.append("false");
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.result.append("break");
        ASTNode label = this.getChildNode(node, BreakStatement.LABEL_PROPERTY);
        if (label != null) {
            this.result.append(' ');
            label.accept(this);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(CaseDefaultExpression node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            this.result.append("default");
        }
        return false;
    }

    @Override
    public boolean visit(CastExpression node) {
        this.result.append('(');
        this.getChildNode(node, CastExpression.TYPE_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, CastExpression.EXPRESSION_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.result.append("catch (");
        this.getChildNode(node, CatchClause.EXCEPTION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, CatchClause.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(CharacterLiteral node) {
        this.result.append(this.getAttribute(node, CharacterLiteral.ESCAPED_VALUE_PROPERTY));
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        ASTNode expression = this.getChildNode(node, ClassInstanceCreation.EXPRESSION_PROPERTY);
        if (expression != null) {
            expression.accept(this);
            this.result.append('.');
        }
        this.result.append("new ");
        if (node.getAST().apiLevel() == 2) {
            this.getChildNode(node, INTERNAL_CIC_NAME_PROPERTY).accept(this);
        } else {
            this.visitList(node, ClassInstanceCreation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
            this.getChildNode(node, ClassInstanceCreation.TYPE_PROPERTY).accept(this);
        }
        this.result.append('(');
        this.visitList(node, ClassInstanceCreation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        ASTNode decl = this.getChildNode(node, ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
        if (decl != null) {
            decl.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        ASTNode pack;
        ASTNode module;
        if (node.getAST().apiLevel() >= 9 && (module = this.getChildNode(node, CompilationUnit.MODULE_PROPERTY)) != null) {
            module.accept(this);
        }
        if ((pack = this.getChildNode(node, CompilationUnit.PACKAGE_PROPERTY)) != null) {
            pack.accept(this);
        }
        this.visitList(node, CompilationUnit.IMPORTS_PROPERTY, null);
        this.visitList(node, CompilationUnit.TYPES_PROPERTY, null);
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        this.getChildNode(node, ConditionalExpression.EXPRESSION_PROPERTY).accept(this);
        this.result.append('?');
        this.getChildNode(node, ConditionalExpression.THEN_EXPRESSION_PROPERTY).accept(this);
        this.result.append(':');
        this.getChildNode(node, ConditionalExpression.ELSE_EXPRESSION_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        if (node.getAST().apiLevel() >= 3) {
            this.visitList(node, ConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append("this(");
        this.visitList(node, ConstructorInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(");");
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.result.append("continue");
        ASTNode label = this.getChildNode(node, ContinueStatement.LABEL_PROPERTY);
        if (label != null) {
            this.result.append(' ');
            label.accept(this);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.getChildNode(node, CreationReference.TYPE_PROPERTY).accept(this);
        this.result.append("::");
        this.visitList(node, CreationReference.TYPE_ARGUMENTS_PROPERTY, Util.EMPTY_STRING, String.valueOf('<'), String.valueOf('>'));
        this.result.append("new");
        return false;
    }

    @Override
    public boolean visit(Dimension node) {
        this.visitList(node, Dimension.ANNOTATIONS_PROPERTY, String.valueOf(' '), String.valueOf(' '), String.valueOf(' '));
        this.result.append("[]");
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.result.append("do ");
        this.getChildNode(node, DoStatement.BODY_PROPERTY).accept(this);
        this.result.append(" while (");
        this.getChildNode(node, DoStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(");");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(ExportsDirective node) {
        this.result.append("exports ");
        this.getChildNode(node, ExportsDirective.NAME_PROPERTY).accept(this);
        List modules = node.modules();
        if (modules.size() > 0) {
            this.result.append(" to ");
            this.visitList(node, ExportsDirective.MODULES_PROPERTY, Util.COMMA_SEPARATOR, Util.EMPTY_STRING, Util.EMPTY_STRING);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        this.getChildNode(node, ExpressionStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        this.getChildNode(node, FieldAccess.EXPRESSION_PROPERTY).accept(this);
        this.result.append('.');
        this.getChildNode(node, FieldAccess.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, FieldDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_FIELD_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, FieldDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, FieldDeclaration.TYPE_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, FieldDeclaration.FRAGMENTS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.result.append("for (");
        this.visitList(node, ForStatement.INITIALIZERS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        ASTNode expression = this.getChildNode(node, ForStatement.EXPRESSION_PROPERTY);
        if (expression != null) {
            expression.accept(this);
        }
        this.result.append(';');
        this.visitList(node, ForStatement.UPDATERS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        this.getChildNode(node, ForStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(GuardedPattern node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            node.getPattern().accept(this);
            this.result.append(" && ");
            node.getExpression().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.result.append("if (");
        this.getChildNode(node, IfStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, IfStatement.THEN_STATEMENT_PROPERTY).accept(this);
        ASTNode elseStatement = this.getChildNode(node, IfStatement.ELSE_STATEMENT_PROPERTY);
        if (elseStatement != null) {
            this.result.append(" else ");
            elseStatement.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.result.append("import ");
        if (node.getAST().apiLevel() >= 3 && this.getBooleanAttribute(node, ImportDeclaration.STATIC_PROPERTY)) {
            this.result.append("static ");
        }
        this.getChildNode(node, ImportDeclaration.NAME_PROPERTY).accept(this);
        if (this.getBooleanAttribute(node, ImportDeclaration.ON_DEMAND_PROPERTY)) {
            this.result.append(".*");
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        this.getChildNode(node, InfixExpression.LEFT_OPERAND_PROPERTY).accept(this);
        this.result.append(' ');
        String operator = this.getAttribute(node, InfixExpression.OPERATOR_PROPERTY).toString();
        this.result.append(operator);
        this.result.append(' ');
        this.getChildNode(node, InfixExpression.RIGHT_OPERAND_PROPERTY).accept(this);
        String separator = String.valueOf(' ') + operator + ' ';
        this.visitList(node, InfixExpression.EXTENDED_OPERANDS_PROPERTY, separator, separator, Util.EMPTY_STRING);
        return false;
    }

    @Override
    public boolean visit(Initializer node) {
        ASTNode javadoc = this.getChildNode(node, Initializer.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_INITIALIZER_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, Initializer.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, Initializer.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        this.getChildNode(node, InstanceofExpression.LEFT_OPERAND_PROPERTY).accept(this);
        this.result.append(" instanceof ");
        this.getChildNode(node, InstanceofExpression.RIGHT_OPERAND_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(PatternInstanceofExpression node) {
        this.getChildNode(node, PatternInstanceofExpression.LEFT_OPERAND_PROPERTY).accept(this);
        this.result.append(" instanceof ");
        this.getChildNode(node, PatternInstanceofExpression.RIGHT_OPERAND_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(IntersectionType node) {
        this.visitList(node, IntersectionType.TYPES_PROPERTY, " & ", Util.EMPTY_STRING, Util.EMPTY_STRING);
        return false;
    }

    @Override
    public boolean visit(Javadoc node) {
        this.result.append("/**");
        List list = this.getChildList(node, Javadoc.TAGS_PROPERTY);
        int i = 0;
        while (i < list.size()) {
            this.result.append("\n * ");
            ((ASTNode)list.get(i)).accept(this);
            ++i;
        }
        this.result.append("\n */");
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.getChildNode(node, LabeledStatement.LABEL_PROPERTY).accept(this);
        this.result.append(": ");
        this.getChildNode(node, LabeledStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        boolean hasParentheses = this.getBooleanAttribute(node, LambdaExpression.PARENTHESES_PROPERTY);
        if (!hasParentheses) {
            List parameters = this.getChildList(node, LambdaExpression.PARAMETERS_PROPERTY);
            boolean bl = hasParentheses = parameters.size() != 1 || !(parameters.get(0) instanceof VariableDeclarationFragment);
        }
        if (hasParentheses) {
            this.result.append('(');
        }
        this.visitList(node, LambdaExpression.PARAMETERS_PROPERTY, String.valueOf(','));
        if (hasParentheses) {
            this.result.append(')');
        }
        this.result.append("->");
        this.getChildNode(node, LambdaExpression.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, MethodDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_METHOD_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, MethodDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
            this.visitList(node, MethodDeclaration.TYPE_PARAMETERS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        if (!this.getBooleanAttribute(node, MethodDeclaration.CONSTRUCTOR_PROPERTY)) {
            if (node.getAST().apiLevel() == 2) {
                this.getChildNode(node, INTERNAL_METHOD_RETURN_TYPE_PROPERTY).accept(this);
            } else {
                ASTNode returnType = this.getChildNode(node, MethodDeclaration.RETURN_TYPE2_PROPERTY);
                if (returnType != null) {
                    returnType.accept(this);
                } else {
                    this.result.append("void");
                }
            }
            this.result.append(' ');
        }
        this.getChildNode(node, MethodDeclaration.NAME_PROPERTY).accept(this);
        if (!DOMASTUtil.isRecordDeclarationSupported(node.getAST()) || !this.getBooleanAttribute(node, MethodDeclaration.COMPACT_CONSTRUCTOR_PROPERTY)) {
            ASTNode receiverType;
            this.result.append('(');
            if (node.getAST().apiLevel() >= 8 && (receiverType = this.getChildNode(node, MethodDeclaration.RECEIVER_TYPE_PROPERTY)) != null) {
                receiverType.accept(this);
                this.result.append(' ');
                ASTNode qualifier = this.getChildNode(node, MethodDeclaration.RECEIVER_QUALIFIER_PROPERTY);
                if (qualifier != null) {
                    qualifier.accept(this);
                    this.result.append('.');
                }
                this.result.append("this");
                if (this.getChildList(node, MethodDeclaration.PARAMETERS_PROPERTY).size() > 0) {
                    this.result.append(',');
                }
            }
            this.visitList(node, MethodDeclaration.PARAMETERS_PROPERTY, String.valueOf(','));
            this.result.append(')');
        }
        this.visitExtraDimensions(node, INTERNAL_METHOD_EXTRA_DIMENSIONS_PROPERTY, MethodDeclaration.EXTRA_DIMENSIONS2_PROPERTY);
        ChildListPropertyDescriptor exceptionsProperty = node.getAST().apiLevel() < 8 ? INTERNAL_METHOD_THROWN_EXCEPTIONS_PROPERTY : MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY;
        this.visitList(node, exceptionsProperty, String.valueOf(','), " throws ", Util.EMPTY_STRING);
        ASTNode body = this.getChildNode(node, MethodDeclaration.BODY_PROPERTY);
        if (body == null) {
            this.result.append(';');
        } else {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, ModuleDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, ModuleDeclaration.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        if (this.getBooleanAttribute(node, ModuleDeclaration.OPEN_PROPERTY)) {
            this.result.append("open ");
        }
        this.result.append("module ");
        this.getChildNode(node, ModuleDeclaration.NAME_PROPERTY).accept(this);
        this.result.append('{');
        this.visitList(node, ModuleDeclaration.MODULE_DIRECTIVES_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        ASTNode expression = this.getChildNode(node, MethodInvocation.EXPRESSION_PROPERTY);
        if (expression != null) {
            expression.accept(this);
            this.result.append('.');
        }
        if (node.getAST().apiLevel() >= 3) {
            this.visitList(node, MethodInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.getChildNode(node, MethodInvocation.NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(node, MethodInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.result.append("null");
        return false;
    }

    @Override
    public boolean visit(NullPattern node) {
        this.result.append("null");
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.result.append(this.getAttribute(node, NumberLiteral.TOKEN_PROPERTY).toString());
        return false;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            ASTNode javadoc = this.getChildNode(node, PackageDeclaration.JAVADOC_PROPERTY);
            if (javadoc != null) {
                javadoc.accept(this);
            }
            this.visitList(node, PackageDeclaration.ANNOTATIONS_PROPERTY, String.valueOf(' '));
        }
        this.result.append("package ");
        this.getChildNode(node, PackageDeclaration.NAME_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.result.append('(');
        this.getChildNode(node, ParenthesizedExpression.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        this.getChildNode(node, PostfixExpression.OPERAND_PROPERTY).accept(this);
        this.result.append(this.getAttribute(node, PostfixExpression.OPERATOR_PROPERTY).toString());
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.result.append(this.getAttribute(node, PrefixExpression.OPERATOR_PROPERTY).toString());
        this.getChildNode(node, PrefixExpression.OPERAND_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.result.append("provides ");
        this.getChildNode(node, ProvidesDirective.NAME_PROPERTY).accept(this);
        this.result.append(" with ");
        this.visitList(node, ProvidesDirective.IMPLEMENTATIONS_PROPERTY, Util.EMPTY_STRING, Util.COMMA_SEPARATOR, Util.EMPTY_STRING);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(PrimitiveType node) {
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, PrimitiveType.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.result.append(this.getAttribute(node, PrimitiveType.PRIMITIVE_TYPE_CODE_PROPERTY).toString());
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        this.getChildNode(node, QualifiedName.QUALIFIER_PROPERTY).accept(this);
        this.result.append('.');
        this.getChildNode(node, QualifiedName.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, RecordDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, RecordDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.result.append("record ");
        this.getChildNode(node, RecordDeclaration.NAME_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, RecordDeclaration.TYPE_PARAMETERS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        this.result.append('(');
        this.visitList(node, RecordDeclaration.RECORD_COMPONENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        this.result.append(' ');
        this.visitList(node, RecordDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, String.valueOf(','), "implements ", Util.EMPTY_STRING);
        this.result.append('{');
        this.visitList(node, RecordDeclaration.BODY_DECLARATIONS_PROPERTY, Util.EMPTY_STRING, String.valueOf(';'), Util.EMPTY_STRING);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(RequiresDirective node) {
        this.result.append("requires ");
        this.visitList(node, RequiresDirective.MODIFIERS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.getChildNode(node, RequiresDirective.NAME_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.result.append("return");
        ASTNode expression = this.getChildNode(node, ReturnStatement.EXPRESSION_PROPERTY);
        if (expression != null) {
            this.result.append(' ');
            expression.accept(this);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.result.append(this.getAttribute(node, SimpleName.IDENTIFIER_PROPERTY));
        return false;
    }

    @Override
    public boolean visit(SimpleType node) {
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, SimpleType.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_VARIABLE_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, SingleVariableDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, SingleVariableDeclaration.TYPE_PROPERTY).accept(this);
        if (node.getAST().apiLevel() >= 8 && node.isVarargs()) {
            this.visitList(node, SingleVariableDeclaration.VARARGS_ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        if (node.getAST().apiLevel() >= 3 && this.getBooleanAttribute(node, SingleVariableDeclaration.VARARGS_PROPERTY)) {
            this.result.append("...");
        }
        this.result.append(' ');
        this.getChildNode(node, SingleVariableDeclaration.NAME_PROPERTY).accept(this);
        this.visitExtraDimensions(node, INTERNAL_VARIABLE_EXTRA_DIMENSIONS_PROPERTY, SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY);
        ASTNode initializer = this.getChildNode(node, SingleVariableDeclaration.INITIALIZER_PROPERTY);
        if (initializer != null) {
            this.result.append('=');
            initializer.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.result.append(this.getAttribute(node, StringLiteral.ESCAPED_VALUE_PROPERTY));
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        ASTNode expression = this.getChildNode(node, SuperConstructorInvocation.EXPRESSION_PROPERTY);
        if (expression != null) {
            expression.accept(this);
            this.result.append('.');
        }
        if (node.getAST().apiLevel() >= 3) {
            this.visitList(node, SuperConstructorInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append("super(");
        this.visitList(node, SuperConstructorInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(");");
        return false;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        ASTNode qualifier = this.getChildNode(node, SuperFieldAccess.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
            this.result.append('.');
        }
        this.result.append("super.");
        this.getChildNode(node, SuperFieldAccess.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        ASTNode qualifier = this.getChildNode(node, SuperMethodInvocation.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
            this.result.append('.');
        }
        this.result.append("super.");
        if (node.getAST().apiLevel() >= 3) {
            this.visitList(node, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.getChildNode(node, SuperMethodInvocation.NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(node, SuperMethodInvocation.ARGUMENTS_PROPERTY, String.valueOf(','));
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (node.getAST().apiLevel() >= 14) {
            if (node.isDefault()) {
                this.result.append("default");
                this.result.append(this.getBooleanAttribute(node, SwitchCase.SWITCH_LABELED_RULE_PROPERTY) ? " ->" : ":");
            } else {
                this.result.append("case ");
                Iterator it = node.expressions().iterator();
                while (it.hasNext()) {
                    Expression t = (Expression)it.next();
                    t.accept(this);
                    this.result.append(it.hasNext() ? ", " : "");
                }
                this.result.append(this.getBooleanAttribute(node, SwitchCase.SWITCH_LABELED_RULE_PROPERTY) ? " ->" : ":");
            }
        } else {
            ASTNode expression = this.getChildNode(node, INTERNAL_SWITCH_EXPRESSION_PROPERTY);
            if (expression == null) {
                this.result.append("default");
            } else {
                this.result.append("case ");
                expression.accept(this);
            }
            this.result.append(':');
        }
        return false;
    }

    @Override
    public boolean visit(SwitchExpression node) {
        this.visitSwitchNode(node);
        return false;
    }

    private void visitSwitchNode(ASTNode node) {
        this.result.append("switch (");
        if (node instanceof SwitchExpression) {
            this.getChildNode(node, SwitchExpression.EXPRESSION_PROPERTY).accept(this);
        } else if (node instanceof SwitchStatement) {
            this.getChildNode(node, SwitchStatement.EXPRESSION_PROPERTY).accept(this);
        }
        this.result.append(')');
        this.result.append('{');
        if (node instanceof SwitchExpression) {
            this.visitList(node, SwitchExpression.STATEMENTS_PROPERTY, null);
        } else if (node instanceof SwitchStatement) {
            this.visitList(node, SwitchStatement.STATEMENTS_PROPERTY, null);
        }
        this.result.append('}');
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.visitSwitchNode(node);
        return false;
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.result.append("synchronized (");
        this.getChildNode(node, SynchronizedStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, SynchronizedStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        ASTNode qualifier = this.getChildNode(node, ThisExpression.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
            this.result.append('.');
        }
        this.result.append("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.result.append("throw ");
        this.getChildNode(node, ThrowStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.result.append("try ");
        int level = node.getAST().apiLevel();
        if (level >= 4) {
            ChildListPropertyDescriptor desc = level < 9 ? INTERNAL_TRY_STATEMENT_RESOURCES_PROPERTY : TryStatement.RESOURCES2_PROPERTY;
            this.visitList(node, desc, String.valueOf(';'), String.valueOf('('), String.valueOf(')'));
        }
        this.getChildNode(node, TryStatement.BODY_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, TryStatement.CATCH_CLAUSES_PROPERTY, null);
        ASTNode finallyClause = this.getChildNode(node, TryStatement.FINALLY_PROPERTY);
        if (finallyClause != null) {
            this.result.append(" finally ");
            finallyClause.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        int apiLevel = node.getAST().apiLevel();
        ASTNode javadoc = this.getChildNode(node, TypeDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        if (apiLevel == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_TYPE_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, TypeDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        boolean isInterface = this.getBooleanAttribute(node, TypeDeclaration.INTERFACE_PROPERTY);
        this.result.append(isInterface ? "interface " : "class ");
        this.getChildNode(node, TypeDeclaration.NAME_PROPERTY).accept(this);
        if (apiLevel >= 3) {
            this.visitList(node, TypeDeclaration.TYPE_PARAMETERS_PROPERTY, String.valueOf(','), String.valueOf('<'), String.valueOf('>'));
        }
        this.result.append(' ');
        ChildPropertyDescriptor superClassProperty = apiLevel == 2 ? INTERNAL_TYPE_SUPERCLASS_PROPERTY : TypeDeclaration.SUPERCLASS_TYPE_PROPERTY;
        ASTNode superclass = this.getChildNode(node, superClassProperty);
        if (superclass != null) {
            this.result.append("extends ");
            superclass.accept(this);
            this.result.append(' ');
        }
        ChildListPropertyDescriptor superInterfaceProperty = apiLevel == 2 ? INTERNAL_TYPE_SUPER_INTERFACES_PROPERTY : TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY;
        String lead = isInterface ? "extends " : "implements ";
        this.visitList(node, superInterfaceProperty, String.valueOf(','), lead, Util.EMPTY_STRING);
        if (DOMASTUtil.isFeatureSupportedinAST(node.getAST(), 512) && !node.permittedTypes().isEmpty()) {
            this.visitList(node, TypeDeclaration.PERMITS_TYPES_PROPERTY, String.valueOf(','), lead, Util.EMPTY_STRING);
        }
        this.result.append('{');
        this.visitList(node, TypeDeclaration.BODY_DECLARATIONS_PROPERTY, null);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            this.getChildNode(node, INTERNAL_TDS_TYPE_DECLARATION_PROPERTY).accept(this);
        } else {
            this.getChildNode(node, TypeDeclarationStatement.DECLARATION_PROPERTY).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteral node) {
        this.getChildNode(node, TypeLiteral.TYPE_PROPERTY).accept(this);
        this.result.append(".class");
        return false;
    }

    @Override
    public boolean visit(UnionType node) {
        this.visitList(node, UnionType.TYPES_PROPERTY, " | ", Util.EMPTY_STRING, Util.EMPTY_STRING);
        return false;
    }

    @Override
    public boolean visit(UsesDirective node) {
        this.result.append("uses ");
        this.getChildNode(node, UsesDirective.NAME_PROPERTY).accept(this);
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_VDE_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, VariableDeclarationExpression.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, VariableDeclarationExpression.TYPE_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, VariableDeclarationExpression.FRAGMENTS_PROPERTY, String.valueOf(','));
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        this.getChildNode(node, VariableDeclarationFragment.NAME_PROPERTY).accept(this);
        this.visitExtraDimensions(node, INTERNAL_FRAGMENT_EXTRA_DIMENSIONS_PROPERTY, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY);
        ASTNode initializer = this.getChildNode(node, VariableDeclarationFragment.INITIALIZER_PROPERTY);
        if (initializer != null) {
            this.result.append('=');
            initializer.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            ASTRewriteFlattener.printModifiers(this.getIntAttribute(node, INTERNAL_VDS_MODIFIERS_PROPERTY), this.result);
        } else {
            this.visitList(node, VariableDeclarationStatement.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, VariableDeclarationStatement.TYPE_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, VariableDeclarationStatement.FRAGMENTS_PROPERTY, String.valueOf(','));
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.result.append("while (");
        this.getChildNode(node, WhileStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, WhileStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(BlockComment node) {
        return false;
    }

    @Override
    public boolean visit(LineComment node) {
        return false;
    }

    @Override
    public boolean visit(MemberRef node) {
        ASTNode qualifier = this.getChildNode(node, MemberRef.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
        }
        this.result.append('#');
        this.getChildNode(node, MemberRef.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodRef node) {
        ASTNode qualifier = this.getChildNode(node, MethodRef.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
        }
        this.result.append('#');
        this.getChildNode(node, MethodRef.NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(node, MethodRef.PARAMETERS_PROPERTY, ",");
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(MethodRefParameter node) {
        ASTNode name;
        this.getChildNode(node, MethodRefParameter.TYPE_PROPERTY).accept(this);
        if (node.getAST().apiLevel() >= 3 && this.getBooleanAttribute(node, MethodRefParameter.VARARGS_PROPERTY)) {
            this.result.append("...");
        }
        if ((name = this.getChildNode(node, MethodRefParameter.NAME_PROPERTY)) != null) {
            this.result.append(' ');
            name.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(TagElement node) {
        Object tagName = this.getAttribute(node, TagElement.TAG_NAME_PROPERTY);
        if (tagName != null) {
            this.result.append((String)tagName);
        }
        List list = this.getChildList(node, TagElement.FRAGMENTS_PROPERTY);
        int i = 0;
        while (i < list.size()) {
            ASTNode curr;
            if (i > 0 || tagName != null) {
                this.result.append(' ');
            }
            if ((curr = (ASTNode)list.get(i)) instanceof TagElement) {
                this.result.append('{');
                curr.accept(this);
                this.result.append('}');
            } else {
                curr.accept(this);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(TextBlock node) {
        this.result.append(this.getAttribute(node, TextBlock.ESCAPED_VALUE_PROPERTY));
        return false;
    }

    @Override
    public boolean visit(TextElement node) {
        this.result.append(this.getAttribute(node, TextElement.TEXT_PROPERTY));
        return false;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, AnnotationTypeDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.result.append("@interface ");
        this.getChildNode(node, AnnotationTypeDeclaration.NAME_PROPERTY).accept(this);
        this.result.append('{');
        this.visitList(node, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY, Util.EMPTY_STRING);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, AnnotationTypeMemberDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.getChildNode(node, AnnotationTypeMemberDeclaration.TYPE_PROPERTY).accept(this);
        this.result.append(' ');
        this.getChildNode(node, AnnotationTypeMemberDeclaration.NAME_PROPERTY).accept(this);
        this.result.append("()");
        ASTNode def = this.getChildNode(node, AnnotationTypeMemberDeclaration.DEFAULT_PROPERTY);
        if (def != null) {
            this.result.append(" default ");
            def.accept(this);
        }
        this.result.append(';');
        return false;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.result.append("for (");
        this.getChildNode(node, EnhancedForStatement.PARAMETER_PROPERTY).accept(this);
        this.result.append(':');
        this.getChildNode(node, EnhancedForStatement.EXPRESSION_PROPERTY).accept(this);
        this.result.append(')');
        this.getChildNode(node, EnhancedForStatement.BODY_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, EnumConstantDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, EnumConstantDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.getChildNode(node, EnumConstantDeclaration.NAME_PROPERTY).accept(this);
        this.visitList(node, EnumConstantDeclaration.ARGUMENTS_PROPERTY, String.valueOf(','), String.valueOf('('), String.valueOf(')'));
        ASTNode classDecl = this.getChildNode(node, EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY);
        if (classDecl != null) {
            classDecl.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        ASTNode javadoc = this.getChildNode(node, EnumDeclaration.JAVADOC_PROPERTY);
        if (javadoc != null) {
            javadoc.accept(this);
        }
        this.visitList(node, EnumDeclaration.MODIFIERS2_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        this.result.append("enum ");
        this.getChildNode(node, EnumDeclaration.NAME_PROPERTY).accept(this);
        this.result.append(' ');
        this.visitList(node, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, String.valueOf(','), "implements ", Util.EMPTY_STRING);
        this.result.append('{');
        this.visitList(node, EnumDeclaration.ENUM_CONSTANTS_PROPERTY, String.valueOf(','), Util.EMPTY_STRING, Util.EMPTY_STRING);
        this.visitList(node, EnumDeclaration.BODY_DECLARATIONS_PROPERTY, Util.EMPTY_STRING, String.valueOf(';'), Util.EMPTY_STRING);
        this.result.append('}');
        return false;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.getChildNode(node, ExpressionMethodReference.EXPRESSION_PROPERTY).accept(this);
        this.result.append("::");
        this.visitList(node, ExpressionMethodReference.TYPE_ARGUMENTS_PROPERTY, Util.EMPTY_STRING, String.valueOf('<'), String.valueOf('>'));
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.result.append('@');
        this.getChildNode(node, MarkerAnnotation.TYPE_NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(MemberValuePair node) {
        this.getChildNode(node, MemberValuePair.NAME_PROPERTY).accept(this);
        this.result.append('=');
        this.getChildNode(node, MemberValuePair.VALUE_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(Modifier node) {
        this.result.append(this.getAttribute(node, Modifier.KEYWORD_PROPERTY).toString());
        return false;
    }

    @Override
    public boolean visit(ModuleModifier node) {
        this.result.append(this.getAttribute(node, ModuleModifier.KEYWORD_PROPERTY).toString());
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.result.append('@');
        this.getChildNode(node, NormalAnnotation.TYPE_NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.visitList(node, NormalAnnotation.VALUES_PROPERTY, ", ");
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        this.getChildNode(node, NameQualifiedType.QUALIFIER_PROPERTY).accept(this);
        this.result.append('.');
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, NameQualifiedType.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, NameQualifiedType.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        this.getChildNode(node, ParameterizedType.TYPE_PROPERTY).accept(this);
        this.result.append('<');
        this.visitList(node, ParameterizedType.TYPE_ARGUMENTS_PROPERTY, ", ");
        this.result.append('>');
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        this.getChildNode(node, QualifiedType.QUALIFIER_PROPERTY).accept(this);
        this.result.append('.');
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, QualifiedType.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, QualifiedType.NAME_PROPERTY).accept(this);
        return false;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.result.append('@');
        this.getChildNode(node, SingleMemberAnnotation.TYPE_NAME_PROPERTY).accept(this);
        this.result.append('(');
        this.getChildNode(node, SingleMemberAnnotation.VALUE_PROPERTY).accept(this);
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        ASTNode qualifier = this.getChildNode(node, SuperMethodReference.QUALIFIER_PROPERTY);
        if (qualifier != null) {
            qualifier.accept(this);
            this.result.append('.');
        }
        this.result.append("super ::");
        this.visitList(node, SuperMethodReference.TYPE_ARGUMENTS_PROPERTY, Util.EMPTY_STRING, String.valueOf('<'), String.valueOf('>'));
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.getChildNode(node, TypeMethodReference.TYPE_PROPERTY).accept(this);
        this.result.append("::");
        this.visitList(node, TypeMethodReference.TYPE_ARGUMENTS_PROPERTY, Util.EMPTY_STRING, String.valueOf('<'), String.valueOf('>'));
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(TypeParameter node) {
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, TypeParameter.MODIFIERS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.getChildNode(node, TypeParameter.NAME_PROPERTY).accept(this);
        this.visitList(node, TypeParameter.TYPE_BOUNDS_PROPERTY, " & ", " extends ", Util.EMPTY_STRING);
        return false;
    }

    @Override
    public boolean visit(TypePattern node) {
        if (DOMASTUtil.isPatternSupported(node.getAST())) {
            node.getPatternVariable().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(WildcardType node) {
        if (node.getAST().apiLevel() >= 8) {
            this.visitList(node, WildcardType.ANNOTATIONS_PROPERTY, String.valueOf(' '), Util.EMPTY_STRING, String.valueOf(' '));
        }
        this.result.append('?');
        ASTNode bound = this.getChildNode(node, WildcardType.BOUND_PROPERTY);
        if (bound != null) {
            if (this.getBooleanAttribute(node, WildcardType.UPPER_BOUND_PROPERTY)) {
                this.result.append(" extends ");
            } else {
                this.result.append(" super ");
            }
            bound.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(YieldStatement node) {
        if (node.getAST().apiLevel() >= 14 && node.isImplicit() && node.getExpression() == null) {
            return false;
        }
        this.result.append("yield");
        ASTNode expression = this.getChildNode(node, YieldStatement.EXPRESSION_PROPERTY);
        if (expression != null) {
            this.result.append(' ');
            expression.accept(this);
        }
        this.result.append(';');
        return false;
    }
}

